/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.tools.voidtool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbFactory;

public class VoIDTool {
    private final File Db;
    private SimpleGdb Gdb;
    public FileWriter file;
    private String fileName;

    public VoIDTool(File f1, String fileName) throws IOException {
        this.Db = f1;
        this.file = new FileWriter(fileName + "txt", true);
        this.fileName = fileName;
    }

    public void appendStrToFile(String fileName, String str) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            System.out.println("exception occurred" + e);
        }
    }

    public void initDatabases() throws IDMapperException {
        String url = "jdbc:derby:jar:(" + this.Db + ")database";
        this.Gdb = SimpleGdbFactory.createInstance((String)"db1", (String)url);
    }

    public void createRDF() throws SQLException, IDMapperException {
        Connection con = this.Gdb.getConnection();
        Statement st = con.createStatement();
        boolean isSchemaUpdated = false;
        String sqlSchema = "SELECT schemaversion FROM info ";
        ResultSet schema = st.executeQuery(sqlSchema);
        while (schema.next()) {
            if (schema.getInt("schemaversion") != 4) continue;
            isSchemaUpdated = true;
        }
        if (isSchemaUpdated) {
            for (DataSource ds : this.Gdb.getCapabilities().getSupportedSrcDataSources()) {
                String sql = "SELECT * from " + ds.getFullName().toUpperCase();
                ResultSet resultSet = st.executeQuery(sql);
                while (resultSet.next()) {
                    this.appendStrToFile(this.fileName, resultSet.getString("ATTRIB") + " " + resultSet.getString("VAL"));
                }
            }
        } else {
            System.out.println("Schema version less than 4 isn't supported");
        }
    }

    public void run() throws IDMapperException, SQLException {
        this.initDatabases();
        this.createRDF();
    }

    public static void printUsage() {
        System.out.println("Expected 2 arguments: <database> <fileName>");
    }

    public static void main(String[] args) throws IOException, IDMapperException, SQLException {
        if (args.length != 2) {
            VoIDTool.printUsage();
            return;
        }
        VoIDTool main = new VoIDTool(new File(args[0]), args[1]);
        DataSourceTxt.init();
        main.run();
    }
}

