/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.statistics;

import org.bridgedb.statistics.DataSetInfo;
import org.bridgedb.statistics.MappingSetInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MappingSetInfoTest {
    MappingSetInfoTest() {
    }

    @Test
    public void getStringId() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("En", "Ensembl");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.ebi.ac.uk/embl/", targetDataSetInfo, "centre", "none", "Ensembl", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)Integer.toString(1), (Object)mappingSetInfo.getStringId());
        Assertions.assertNotEquals((Object)Integer.toString(0), (Object)mappingSetInfo.getStringId());
    }

    @Test
    public void getIntId() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("En", "Ensembl");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.ebi.ac.uk/embl/", targetDataSetInfo, "centre", "none", "Ensembl", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((int)1, (int)mappingSetInfo.getIntId());
        Assertions.assertNotEquals((int)0, (int)mappingSetInfo.getIntId());
    }

    @Test
    public void combineIds() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("En", "Ensembl");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.ebi.ac.uk/embl/", targetDataSetInfo, "centre", "none", "Ensembl", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        MappingSetInfo mappingSetInfo1 = new MappingSetInfo(2, targetDataSetInfo, "http://www.ebi.ac.uk/embl/", sourceDataSetInfo, "centre", "none", "Affy", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        mappingSetInfo.combineIds(mappingSetInfo1);
        Assertions.assertEquals((Object)"1,2", (Object)mappingSetInfo.getStringId());
    }

    @Test
    public void getPredicate() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("En", "Ensembl");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.ebi.ac.uk/embl/", targetDataSetInfo, "centre", "none", "Ensembl", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"http://www.ebi.ac.uk/embl/", (Object)mappingSetInfo.getPredicate());
    }

    @Test
    public void predicateLocalName() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"/entity/$id/", (Object)mappingSetInfo.predicateLocalName());
    }

    @Test
    public void isSymmetric() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertTrue((boolean)mappingSetInfo.isSymmetric());
        MappingSetInfo mappingSetInfo1 = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertFalse((boolean)mappingSetInfo1.isSymmetric());
    }

    @Test
    public void hasOrIsSymmetric() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertTrue((boolean)mappingSetInfo.hasOrIsSymmetric());
        MappingSetInfo mappingSetInfo1 = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 0, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertFalse((boolean)mappingSetInfo1.hasOrIsSymmetric());
    }

    @Test
    public void getNumberOfLinks() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((int)2, (Integer)mappingSetInfo.getNumberOfLinks());
    }

    @Test
    public void setNumberOfLinks() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        mappingSetInfo.setNumberOfLinks(Integer.valueOf(3));
        Assertions.assertEquals((int)3, (Integer)mappingSetInfo.getNumberOfLinks());
    }

    @Test
    public void toString1() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        String test = "1\n\tsource:" + mappingSetInfo.getSource() + "\n\tpredicate:" + mappingSetInfo.getPredicate() + "\n\ttarget: " + mappingSetInfo.getTarget() + "\n\tsymetric: " + mappingSetInfo.getSymmetric() + "\n\tnumberOfLinks: " + mappingSetInfo.getNumberOfLinks() + "\n";
        Assertions.assertEquals((Object)test, (Object)mappingSetInfo.toString());
    }

    @Test
    public void getJustification() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "centre", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"centre", (Object)mappingSetInfo.getJustification());
    }

    @Test
    public void justificationLocalName() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"/entity/$id/", (Object)mappingSetInfo.justificationLocalName());
    }

    @Test
    public void getSymmetric() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((int)2, (int)mappingSetInfo.getSymmetric());
    }

    @Test
    public void getSource() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)sourceDataSetInfo, (Object)mappingSetInfo.getSource());
        Assertions.assertNotEquals((Object)targetDataSetInfo, (Object)mappingSetInfo.getSource());
    }

    @Test
    public void getTarget() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)targetDataSetInfo, (Object)mappingSetInfo.getTarget());
        Assertions.assertNotEquals((Object)sourceDataSetInfo, (Object)mappingSetInfo.getTarget());
    }

    @Test
    public void isTransitive() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "none", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertFalse((boolean)mappingSetInfo.isTransitive());
    }

    @Test
    public void getMappingResource() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "Affy", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"Affy", (Object)mappingSetInfo.getMappingResource());
        Assertions.assertNotEquals((Object)"SwissLipids", (Object)mappingSetInfo.getMappingResource());
    }

    @Test
    public void resourceLocalName() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "https://www.affymetrix.com/LinkServlet?probeset=$id", "SwissLipids.", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"LinkServlet?probeset=$id", (Object)mappingSetInfo.resourceLocalName());
    }

    @Test
    public void getMappingSource() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "https://www.affymetrix.com/LinkServlet?probeset=$id", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"SwissLipids", (Object)mappingSetInfo.getMappingSource());
    }

    @Test
    public void sourceLocalName() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "https://www.affymetrix.com/LinkServlet?probeset=$id", "http://www.swisslipids.org/#/entity/$id/", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((Object)"/entity/$id/", (Object)mappingSetInfo.sourceLocalName());
    }

    @Test
    public void getNumberOfSources() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "Affy", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((int)1, (Integer)mappingSetInfo.getNumberOfSources());
        Assertions.assertNotEquals((int)2, (Integer)mappingSetInfo.getNumberOfSources());
    }

    @Test
    public void getNumberOfTargets() {
        DataSetInfo sourceDataSetInfo = new DataSetInfo("Sl", "SwissLipids");
        DataSetInfo targetDataSetInfo = new DataSetInfo("X", "Affy");
        MappingSetInfo mappingSetInfo = new MappingSetInfo(1, sourceDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", targetDataSetInfo, "http://www.swisslipids.org/#/entity/$id/", "Affy", "SwissLipids", 2, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
        Assertions.assertEquals((int)1, (Integer)mappingSetInfo.getNumberOfTargets());
        Assertions.assertNotEquals((int)2, (Integer)mappingSetInfo.getNumberOfTargets());
    }
}

