/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.uri.ws.client;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.bridgedb.uri.ws.WSUriInterface;
import org.bridgedb.uri.ws.bean.DataSourceUriPatternBean;
import org.bridgedb.uri.ws.bean.LensBean;
import org.bridgedb.uri.ws.bean.LensesBean;
import org.bridgedb.uri.ws.bean.MappingSetInfoBean;
import org.bridgedb.uri.ws.bean.MappingSetInfosBean;
import org.bridgedb.uri.ws.bean.MappingsBean;
import org.bridgedb.uri.ws.bean.MappingsBySetBean;
import org.bridgedb.uri.ws.bean.OverallStatisticsBean;
import org.bridgedb.uri.ws.bean.SourceInfosBean;
import org.bridgedb.uri.ws.bean.SourceTargetInfosBean;
import org.bridgedb.uri.ws.bean.UriExistsBean;
import org.bridgedb.uri.ws.bean.UriMappings;
import org.bridgedb.uri.ws.bean.UriSearchBean;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.WSCoreClient;
import org.bridgedb.ws.bean.XrefBean;

public class WSUriClient
extends WSCoreClient
implements WSUriInterface {
    public final String NO_REPORT;
    public final String NO_EXCEPTION;

    public WSUriClient(String serviceAddress) throws BridgeDBException {
        super(serviceAddress);
        this.NO_REPORT = null;
        this.NO_EXCEPTION = null;
    }

    public Response map(String id, String scrCode, String uri, String lensUri, Boolean includeXrefResults, Boolean includeUriResults, List<String> targetCodes, String graph, List<String> targetUriPattern) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (id != null) {
            params.add((Object)"id", (Object)id);
        }
        if (scrCode != null) {
            params.add((Object)"code", (Object)scrCode);
        }
        if (uri != null) {
            params.add((Object)"Uri", (Object)uri);
        }
        if (lensUri != null) {
            params.add((Object)"lensUri", (Object)lensUri);
        }
        if (includeXrefResults != null) {
            params.add((Object)"includeXrefResults", (Object)includeXrefResults.toString());
        }
        if (includeUriResults != null) {
            params.add((Object)"includeUriResults", (Object)includeUriResults.toString());
        }
        if (targetCodes != null) {
            for (String target : targetCodes) {
                params.add((Object)"targetCode", (Object)target);
            }
        }
        if (graph != null) {
            params.add((Object)"graph", (Object)graph);
        }
        if (targetUriPattern != null) {
            for (String target : targetUriPattern) {
                params.add((Object)"targetUriPattern", (Object)target);
            }
        }
        try {
            MappingsBean result = (MappingsBean)this.webResource.path("map").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<MappingsBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response mapBySet(List<String> uris, String lensUri, String graph, List<String> targetUriPattern) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        for (String uri : uris) {
            if (uri == null) continue;
            params.add((Object)"Uri", (Object)uri);
        }
        if (lensUri != null) {
            params.add((Object)"lensUri", (Object)lensUri);
        }
        if (graph != null) {
            params.add((Object)"graph", (Object)graph);
        }
        if (targetUriPattern != null) {
            for (String target : targetUriPattern) {
                params.add((Object)"targetUriPattern", (Object)target);
            }
        }
        try {
            MappingsBySetBean result = (MappingsBySetBean)this.webResource.path("mapBySet").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<MappingsBySetBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response UriExists(String uri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"Uri", (Object)uri);
        try {
            UriExistsBean result = (UriExistsBean)this.webResource.path("UriExists").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<UriExistsBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response UriSearch(String text, String limitString) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"text", (Object)text);
        params.add((Object)"limit", (Object)limitString);
        try {
            UriSearchBean result = (UriSearchBean)this.webResource.path("UriSearch").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<UriSearchBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    private String encode(String original) {
        return original.replaceAll("%", "%20");
    }

    public Response toXref(String uri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"Uri", (Object)this.encode(uri));
        try {
            XrefBean result = (XrefBean)this.webResource.path("toXref").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<XrefBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response toUris(String id, String scrCode) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)this.encode(id));
        params.add((Object)"code", (Object)this.encode(scrCode));
        try {
            UriMappings result = (UriMappings)this.webResource.path("toXref").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<UriMappings>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getOverallStatistics(String lensUri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"lensUri", (Object)this.encode(lensUri));
        try {
            OverallStatisticsBean result = (OverallStatisticsBean)this.webResource.path("getOverallStatistics").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<OverallStatisticsBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getSourceInfos(String lensUri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"lensUri", (Object)this.encode(lensUri));
        try {
            SourceInfosBean result = (SourceInfosBean)this.webResource.path("SourceInfos").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<SourceInfosBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getSourceTargetInfos(String sourceSysCode, String lensUri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"sourceCode", (Object)this.encode(sourceSysCode));
        params.add((Object)"lensUri", (Object)this.encode(lensUri));
        try {
            SourceTargetInfosBean result = (SourceTargetInfosBean)this.webResource.path("SourceTargetInfos").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<SourceTargetInfosBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            ex.printStackTrace();
            return Response.noContent().build();
        }
    }

    public Response getMappingSetInfo(String mappingSetId) throws BridgeDBException {
        try {
            MappingSetInfoBean result = (MappingSetInfoBean)this.webResource.path("mappingSet/" + mappingSetId).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<MappingSetInfoBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getMappingSetInfos(String sourceSysCode, String targetSysCode, String lensUri) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"sourceCode", (Object)sourceSysCode);
        params.add((Object)"targetCode", (Object)targetSysCode);
        params.add((Object)"lensUri", (Object)this.encode(lensUri));
        try {
            MappingSetInfosBean result = (MappingSetInfosBean)this.webResource.path("mappingSet").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<MappingSetInfosBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getDataSource(String dataSource) throws BridgeDBException {
        try {
            DataSourceUriPatternBean result = (DataSourceUriPatternBean)this.webResource.path("dataSource/" + dataSource).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<DataSourceUriPatternBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getLenses() {
        try {
            List result = (List)this.webResource.path("Lens").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<List<LensBean>>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getLens(String id) throws BridgeDBException {
        try {
            LensBean result = (LensBean)this.webResource.path("Lens/" + id).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<LensBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getSqlCompatVersion() throws BridgeDBException {
        try {
            String result = (String)this.webResource.path("SqlCompatVersion").accept(new String[]{"text/plain"}).get((GenericType)new GenericType<String>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response mapUri(List<String> uris, String lensUri, String graph, List<String> targetUriPatterns) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        for (String uri : uris) {
            if (uri == null) continue;
            params.add((Object)"Uri", (Object)uri);
        }
        if (lensUri != null) {
            params.add((Object)"lensUri", (Object)lensUri);
        }
        if (graph != null) {
            params.add((Object)"graph", (Object)graph);
        }
        if (targetUriPatterns != null) {
            for (String target : targetUriPatterns) {
                params.add((Object)"targetUriPattern", (Object)target);
            }
        }
        try {
            UriMappings result = (UriMappings)this.webResource.path("mapUri").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<UriMappings>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getLenses(String lensUri, String lensGroup) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (lensUri != null) {
            params.add((Object)"lensUri", (Object)lensUri);
        }
        if (lensGroup != null) {
            params.add((Object)"lensGroup", (Object)lensGroup);
        }
        try {
            LensesBean result = (LensesBean)this.webResource.path("mapUri").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<LensesBean>(){});
            return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }
}

