/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.WSCoreInterface;
import org.bridgedb.ws.bean.CapabilitiesBean;
import org.bridgedb.ws.bean.DataSourcesBean;
import org.bridgedb.ws.bean.FreeSearchSupportedBean;
import org.bridgedb.ws.bean.MappingSupportedBean;
import org.bridgedb.ws.bean.PropertiesBean;
import org.bridgedb.ws.bean.PropertyBean;
import org.bridgedb.ws.bean.XrefExistsBean;
import org.bridgedb.ws.bean.XrefMapsBean;
import org.bridgedb.ws.bean.XrefsBean;

public class WSCoreClient
implements WSCoreInterface {
    protected final String serviceAddress;
    protected final WebResource webResource;

    public WSCoreClient(String serviceAddress) {
        this.serviceAddress = serviceAddress;
        DefaultClientConfig config = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)config);
        this.webResource = client.resource(serviceAddress);
    }

    public Response mapID(List<String> id, List<String> scrCode, List<String> targetCodes) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        for (String one : id) {
            params.add((Object)"id", (Object)one);
        }
        for (String one : scrCode) {
            params.add((Object)"code", (Object)one);
        }
        for (String target : targetCodes) {
            params.add((Object)"targetCode", (Object)target);
        }
        try {
            XrefMapsBean bean = (XrefMapsBean)this.webResource.path("mapID").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<XrefMapsBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response freeSearch(String text, String limit) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"text", (Object)text);
        params.add((Object)"limit", (Object)limit);
        try {
            XrefsBean bean = (XrefsBean)this.webResource.path("freeSearch").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<XrefsBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getKeys() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        try {
            PropertiesBean bean = (PropertiesBean)this.webResource.path("getKeys").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<PropertiesBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getProperty(String key) {
        try {
            PropertyBean bean = (PropertyBean)this.webResource.path("property/" + key).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<PropertyBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getSupportedSrcDataSources() throws BridgeDBException {
        try {
            DataSourcesBean bean = (DataSourcesBean)this.webResource.path("getSupportedSrcDataSources").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<DataSourcesBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response getSupportedTgtDataSources() throws BridgeDBException {
        try {
            DataSourcesBean bean = (DataSourcesBean)this.webResource.path("getSupportedTgtDataSources").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<DataSourcesBean>(){});
            return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (UniformInterfaceException ex) {
            return Response.noContent().build();
        }
    }

    public Response isFreeSearchSupported() {
        FreeSearchSupportedBean bean = (FreeSearchSupportedBean)this.webResource.path("isFreeSearchSupported").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<FreeSearchSupportedBean>(){});
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    public Response isMappingSupported(String sourceCode, String targetCode) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"sourceCode", (Object)sourceCode);
        params.add((Object)"targetCode", (Object)targetCode);
        MappingSupportedBean bean = (MappingSupportedBean)this.webResource.path("isMappingSupported").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<MappingSupportedBean>(){});
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    public Response xrefExists(String id, String scrCode) throws BridgeDBException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)id);
        params.add((Object)"code", (Object)scrCode);
        XrefExistsBean bean = (XrefExistsBean)this.webResource.path("xrefExists").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<XrefExistsBean>(){});
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    public Response getCapabilities() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        CapabilitiesBean bean = (CapabilitiesBean)this.webResource.path("getCapabilities").queryParams((MultivaluedMap)params).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get((GenericType)new GenericType<CapabilitiesBean>(){});
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }
}

