/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.pairs.CodeMapper;
import org.bridgedb.pairs.SyscodeBasedCodeMapper;
import org.bridgedb.sql.SQLIdMapper;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.bridgedb.ws.WSCoreInterface;
import org.bridgedb.ws.bean.CapabilitiesBean;
import org.bridgedb.ws.bean.DataSourcesBean;
import org.bridgedb.ws.bean.FreeSearchSupportedBean;
import org.bridgedb.ws.bean.MappingSupportedBean;
import org.bridgedb.ws.bean.PropertiesBean;
import org.bridgedb.ws.bean.PropertyBean;
import org.bridgedb.ws.bean.XrefExistsBean;
import org.bridgedb.ws.bean.XrefMapsBean;
import org.bridgedb.ws.bean.XrefsBean;

@Path(value="/")
public class WSCoreService
implements WSCoreInterface {
    static final String NO_CONTENT_ON_EMPTY = "no.content.on.empty";
    protected final boolean noContentOnEmpty;
    static final Logger logger = Logger.getLogger(WSCoreService.class);
    protected IDMapper idMapper;

    private WSCoreService() throws BridgeDBException {
        this((IDMapper)new SQLIdMapper(false, (CodeMapper)new SyscodeBasedCodeMapper()));
    }

    public WSCoreService(IDMapper idMapper) throws BridgeDBException {
        this.idMapper = idMapper;
        String property = ConfigReader.getProperty((String)NO_CONTENT_ON_EMPTY);
        this.noContentOnEmpty = Boolean.valueOf(property);
        logger.info((Object)"WS Service running using supplied idMapper");
    }

    private DataSourcesBean getSupportedSrcDataSourcesInner() throws BridgeDBException {
        IDMapperCapabilities capabilities = this.idMapper.getCapabilities();
        try {
            Set dataSources = capabilities.getSupportedSrcDataSources();
            return new DataSourcesBean(dataSources);
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/getSupportedSrcDataSources")
    public Response getSupportedSrcDataSources() throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedSrcDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getSupportedSrcDataSources")
    public Response getSupportedSrcDataSourcesJson() throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedSrcDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/getSupportedSrcDataSources")
    public Response getSupportedSrcDataSources(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedSrcDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private XrefsBean freeSearchInner(String text, String limitString) throws BridgeDBException {
        Set mappings;
        if (text == null) {
            throw new BridgeDBException("text parameter missing");
        }
        try {
            if (limitString == null || limitString.isEmpty()) {
                mappings = this.idMapper.freeSearch(text, Integer.MAX_VALUE);
            } else {
                int limit = Integer.parseInt(limitString);
                mappings = this.idMapper.freeSearch(text, limit);
            }
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
        return new XrefsBean(mappings);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/freeSearch")
    public Response freeSearch(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString) throws BridgeDBException {
        XrefsBean bean = this.freeSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/freeSearch")
    public Response freeSearchJson(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString) throws BridgeDBException {
        XrefsBean bean = this.freeSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/freeSearch")
    public Response freeSearch(@QueryParam(value="text") String text, @QueryParam(value="limit") String limitString, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        XrefsBean bean = this.freeSearchInner(text, limitString);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private XrefMapsBean mapIDInner(List<String> id, List<String> scrCode, List<String> targetCodes) throws BridgeDBException {
        if (id == null) {
            throw new BridgeDBException("id parameter missing");
        }
        if (id.isEmpty()) {
            throw new BridgeDBException("id parameter missing");
        }
        if (scrCode == null) {
            throw new BridgeDBException("code parameter missing");
        }
        if (scrCode.isEmpty()) {
            throw new BridgeDBException("code parameter missing");
        }
        if (id.size() != scrCode.size()) {
            throw new BridgeDBException("Must have same number of id and code parameters");
        }
        ArrayList<Xref> srcXrefs = new ArrayList<Xref>();
        for (int i = 0; i < id.size(); ++i) {
            try {
                DataSource dataSource = DataSource.getExistingBySystemCode((String)scrCode.get(i));
                Xref source = new Xref(id.get(i), dataSource);
                srcXrefs.add(source);
                continue;
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        DataSource[] targetDataSources = new DataSource[targetCodes.size()];
        for (int i = 0; i < targetCodes.size(); ++i) {
            targetDataSources[i] = DataSource.getExistingBySystemCode((String)targetCodes.get(i));
        }
        try {
            Map mappings = this.idMapper.mapID(srcXrefs, targetDataSources);
            return new XrefMapsBean(mappings);
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/mapID")
    public Response mapID(@QueryParam(value="id") List<String> id, @QueryParam(value="code") List<String> scrCode, @QueryParam(value="targetCode") List<String> targetCodes) throws BridgeDBException {
        XrefMapsBean bean = this.mapIDInner(id, scrCode, targetCodes);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mapID")
    public Response mapIDJson(@QueryParam(value="id") List<String> id, @QueryParam(value="code") List<String> scrCode, @QueryParam(value="targetCode") List<String> targetCodes) throws BridgeDBException {
        XrefMapsBean bean = this.mapIDInner(id, scrCode, targetCodes);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/mapID")
    public Response mapID(@QueryParam(value="id") List<String> id, @QueryParam(value="code") List<String> scrCode, @QueryParam(value="targetCode") List<String> targetCodes, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        XrefMapsBean bean = this.mapIDInner(id, scrCode, targetCodes);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private XrefExistsBean xrefExistsInner(String id, String scrCode) throws BridgeDBException {
        DataSource dataSource;
        if (id == null) {
            throw new BridgeDBException("id parameter can not be null");
        }
        if (scrCode == null) {
            throw new BridgeDBException("code parameter can not be null");
        }
        try {
            dataSource = DataSource.getExistingBySystemCode((String)scrCode);
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)ex.getMessage());
            return new XrefExistsBean(id, scrCode, false);
        }
        Xref source = new Xref(id, dataSource);
        try {
            return new XrefExistsBean(source, this.idMapper.xrefExists(source));
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/xrefExists")
    public Response xrefExists(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode) throws BridgeDBException {
        XrefExistsBean bean = this.xrefExistsInner(id, scrCode);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/xrefExists")
    public Response xrefExistsJson(@QueryParam(value="id") String id, @QueryParam(value="code") String scrCode) throws BridgeDBException {
        XrefExistsBean bean = this.xrefExistsInner(id, scrCode);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private DataSourcesBean getSupportedTgtDataSourcesInner() throws BridgeDBException {
        try {
            Set dataSources = this.idMapper.getCapabilities().getSupportedSrcDataSources();
            return new DataSourcesBean(dataSources);
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/getSupportedTgtDataSources")
    public Response getSupportedTgtDataSources() throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedTgtDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getSupportedTgtDataSources")
    public Response getSupportedTgtDataSourcesJson() throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedTgtDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/getSupportedTgtDataSources")
    public Response getSupportedTgtDataSources(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        DataSourcesBean bean = this.getSupportedTgtDataSourcesInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="isFreeSearchSupported")
    public Response isFreeSearchSupported() {
        FreeSearchSupportedBean bean = new FreeSearchSupportedBean(this.idMapper.getCapabilities().isFreeSearchSupported());
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="isFreeSearchSupported")
    public Response isFreeSearchSupportedJson() {
        FreeSearchSupportedBean bean = new FreeSearchSupportedBean(this.idMapper.getCapabilities().isFreeSearchSupported());
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private MappingSupportedBean isMappingSupportedInner(String sourceCode, String targetCode) throws BridgeDBException {
        if (sourceCode == null) {
            throw new BridgeDBException("sourceCode parameter can not be null");
        }
        if (targetCode == null) {
            throw new BridgeDBException("targetCode parameter can not be null");
        }
        DataSource src = DataSource.getExistingBySystemCode((String)sourceCode);
        DataSource tgt = DataSource.getExistingBySystemCode((String)targetCode);
        try {
            return new MappingSupportedBean(src, tgt, this.idMapper.getCapabilities().isMappingSupported(src, tgt));
        }
        catch (IDMapperException e) {
            throw BridgeDBException.convertToBridgeDB((IDMapperException)e);
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/isMappingSupported")
    public Response isMappingSupported(@QueryParam(value="sourceCode") String sourceCode, @QueryParam(value="targetCode") String targetCode) throws BridgeDBException {
        MappingSupportedBean bean = this.isMappingSupportedInner(sourceCode, targetCode);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/isMappingSupported")
    public Response isMappingSupportedJson(@QueryParam(value="sourceCode") String sourceCode, @QueryParam(value="targetCode") String targetCode) throws BridgeDBException {
        MappingSupportedBean bean = this.isMappingSupportedInner(sourceCode, targetCode);
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private PropertyBean getPropertyInner(String key) {
        String property = this.idMapper.getCapabilities().getProperty(key);
        return new PropertyBean(key, property);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/property/{key}")
    public Response getProperty(@PathParam(value="key") String key) {
        PropertyBean bean = this.getPropertyInner(key);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/property/{key}")
    public Response getPropertyJson(@PathParam(value="key") String key) {
        PropertyBean bean = this.getPropertyInner(key);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/property/{key}")
    public Response getProperty(@PathParam(value="key") String key, @Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        PropertyBean bean = this.getPropertyInner(key);
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private PropertiesBean getKeysInner() {
        PropertiesBean bean = new PropertiesBean();
        Set keys = this.idMapper.getCapabilities().getKeys();
        IDMapperCapabilities idMapperCapabilities = this.idMapper.getCapabilities();
        for (String key : keys) {
            bean.addProperty(key, idMapperCapabilities.getProperty(key));
        }
        return bean;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/getKeys")
    public Response getKeys() {
        PropertiesBean bean = this.getKeysInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getKeys")
    public Response getKeysJson() {
        PropertiesBean bean = this.getKeysInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/getKeys")
    public Response getKeys(@Context HttpServletRequest httpServletRequest) throws BridgeDBException {
        PropertiesBean bean = this.getKeysInner();
        if (this.noContentOnEmpty & bean.isEmpty()) {
            return this.noContentWrapper(httpServletRequest);
        }
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/getCapabilities")
    public Response getCapabilities() {
        CapabilitiesBean bean = new CapabilitiesBean(this.idMapper.getCapabilities());
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getCapabilities")
    public Response getCapabilitiesJson() {
        CapabilitiesBean bean = new CapabilitiesBean(this.idMapper.getCapabilities());
        return Response.ok((Object)bean, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Response noContentWrapper(HttpServletRequest httpServletRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" ");
        sb.append("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
        sb.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\"/>");
        sb.append("<head>\n");
        sb.append("<title>No Results found</title>\n");
        sb.append("</head>\n<body>\n");
        sb.append("<h1>Sorry no results found!</h1>\n");
        sb.append("<h2>The parameters provided resulted in an empty set.</h2>\n");
        sb.append("<h3>No exception was thrown so the parameters where valid just too restrictive.</h3>\n");
        sb.append("<h2>XML and json version return status 204 in this case</h2>\n");
        sb.append("</body></html>");
        return Response.ok((Object)sb.toString(), (String)"text/html").build();
    }
}

