/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.ws.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.file.IDMapperText;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.ws.WSCoreInterface;
import org.bridgedb.ws.WSCoreMapper;
import org.bridgedb.ws.WSCoreService;
import org.bridgedb.ws.bean.CapabilitiesBean;
import org.bridgedb.ws.bean.DataSourcesBean;
import org.bridgedb.ws.bean.FreeSearchSupportedBean;
import org.bridgedb.ws.bean.XrefExistsBean;
import org.bridgedb.ws.bean.XrefMapsBean;
import org.bridgedb.ws.server.IDMapperCapabilitiesTest;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="mysql")
public class IDMapperTest
extends org.bridgedb.utils.IDMapperTest {
    @BeforeAll
    public static void setupIDMapper() throws IDMapperException, MalformedURLException {
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        idMapper = new WSCoreMapper((WSCoreInterface)webService);
        capabilities = idMapper.getCapabilities();
    }

    @Test
    public void test() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        URL INTERFACE_TEST_FILE_EMPTY = IDMapperCapabilitiesTest.class.getResource("/interfaceTest3.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest3.txt", (Object)INTERFACE_TEST_FILE_EMPTY);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        IDMapperText empty = new IDMapperText(INTERFACE_TEST_FILE_EMPTY);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        WSCoreService webServiceEmpty = new WSCoreService((IDMapper)empty);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respMapping = webService.mapID(id, scrCode, targetCode);
        XrefMapsBean xmb = (XrefMapsBean)respMapping.getEntity();
        Assertions.assertFalse((boolean)xmb.isEmpty());
        Response respMappingJson = webService.mapIDJson(id, scrCode, targetCode);
        XrefMapsBean xmbj = (XrefMapsBean)respMappingJson.getEntity();
        Assertions.assertFalse((boolean)xmbj.isEmpty());
        Response respSupportedDS = webServiceEmpty.getSupportedSrcDataSources();
        Assertions.assertNull((Object)respSupportedDS.getEntity());
        Response respSupportedDSJson = webServiceEmpty.getSupportedSrcDataSourcesJson();
        Assertions.assertNull((Object)respSupportedDSJson.getEntity());
        Response respSupportedTgtDS = webServiceEmpty.getSupportedTgtDataSources();
        Assertions.assertNull((Object)respSupportedTgtDS.getEntity());
        Response respSupportedTgtDSJson = webServiceEmpty.getSupportedTgtDataSourcesJson();
        Assertions.assertNull((Object)respSupportedTgtDSJson.getEntity());
    }

    @Test
    public void testXrefExists() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respXrefExists = webService.xrefExists("YHR055C", "En");
        XrefExistsBean xb = (XrefExistsBean)respXrefExists.getEntity();
        Assertions.assertTrue((boolean)xb.getExists());
        Response respXrefExistsJson = webService.xrefExistsJson("YHR055C", "En");
        XrefExistsBean xb2 = (XrefExistsBean)respXrefExistsJson.getEntity();
        Assertions.assertTrue((boolean)xb2.getExists());
    }

    @Test
    public void testGetTgtDS() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respSupportedTgtDataSources = webService.getSupportedTgtDataSources();
        DataSourcesBean ds = (DataSourcesBean)respSupportedTgtDataSources.getEntity();
        Set dsSet = ds.getDataSources();
        Assertions.assertFalse((boolean)dsSet.isEmpty());
        Response respSupportedTgtDataSourcesJson = webService.getSupportedTgtDataSourcesJson();
        DataSourcesBean ds2 = (DataSourcesBean)respSupportedTgtDataSourcesJson.getEntity();
        Set dsSet2 = ds2.getDataSources();
        Assertions.assertFalse((boolean)dsSet2.isEmpty());
    }

    @Test
    public void testFreeSearchSupported() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respFreeSearchSupported = webService.isFreeSearchSupported();
        FreeSearchSupportedBean fsb = (FreeSearchSupportedBean)respFreeSearchSupported.getEntity();
        Assertions.assertFalse((boolean)fsb.getIsFreeSearchSupported());
        Response isFreeSearchSupportedJson = webService.isFreeSearchSupportedJson();
        FreeSearchSupportedBean fsbj = (FreeSearchSupportedBean)isFreeSearchSupportedJson.getEntity();
        Assertions.assertFalse((boolean)fsbj.getIsFreeSearchSupported());
    }

    @Test
    public void testGetCapabilities() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respGetPropertyNoContent = webService.getProperty("ID");
        Assertions.assertNull((Object)respGetPropertyNoContent.getEntity());
        Response respGetPropertyJsonNoContent = webService.getPropertyJson("ID");
        Assertions.assertNull((Object)respGetPropertyJsonNoContent.getEntity());
        Response respGetKeys = webService.getKeys();
        Assertions.assertNull((Object)respGetKeys.getEntity());
        Response respGetKeysJson = webService.getKeysJson();
        Assertions.assertNull((Object)respGetKeysJson.getEntity());
        Response respCapabilities = webService.getCapabilities();
        CapabilitiesBean cb = (CapabilitiesBean)respCapabilities.getEntity();
        Assert.assertNotNull((Object)cb.getSupportedSrcDataSources());
        Response respCapabilitiesJson = webService.getCapabilitiesJson();
        CapabilitiesBean cbj = (CapabilitiesBean)respCapabilitiesJson.getEntity();
        Assert.assertNotNull((Object)cbj.getSupportedSrcDataSources());
    }

    @Test
    public void testMappingSupported() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        id.add("YHR055C");
        ArrayList<String> scrCode = new ArrayList<String>();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Response respMappingSupported = webService.isMappingSupported("En", "L");
        Assert.assertNotNull((Object)respMappingSupported.getEntity());
        Response respMappingSupportedJson = webService.isMappingSupportedJson("En", "L");
        Assert.assertNotNull((Object)respMappingSupportedJson.getEntity());
    }

    @Test
    public void testExceptions() throws Exception {
        DataSourceTxt.init();
        URL INTERFACE_TEST_FILE = IDMapperCapabilitiesTest.class.getResource("/interfaceTest2.txt");
        Assert.assertNotNull((String)"Can't find test-data/interfaceTest2.txt", (Object)INTERFACE_TEST_FILE);
        IDMapperText inner = new IDMapperText(INTERFACE_TEST_FILE);
        WSCoreService webService = new WSCoreService((IDMapper)inner);
        ArrayList<String> id = new ArrayList<String>();
        ArrayList idEmpty = new ArrayList();
        id.add("YHR055C");
        id.add("YPR161C");
        ArrayList<String> scrCode = new ArrayList<String>();
        ArrayList scrCodeEmpty = new ArrayList();
        scrCode.add("En");
        ArrayList<String> targetCode = new ArrayList<String>();
        targetCode.add("L");
        DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        DataSource.register((String)"L", (String)"Entrez Gene").asDataSource();
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.mapID(id, scrCode, targetCode);
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.mapID(null, scrCode, targetCode);
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.mapID(idEmpty, scrCode, targetCode);
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.mapID(id, null, targetCode);
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.mapID(id, scrCodeEmpty, targetCode);
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.isMappingSupported(null, "L");
        });
        Assertions.assertThrows(BridgeDBException.class, () -> {
            Response respMapping = webService.isMappingSupported("En", null);
        });
    }
}

