/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridgedb.Xref;

public final class DataSource {
    private static final String URN_PREFIX = "urn:miriam:";
    private static final String IDENTIFIERS_ORG_PREFIX = "http://identifiers.org/";
    public static final String UNKOWN = "unknown";
    private static Map<String, DataSource> bySysCode = new HashMap<String, DataSource>();
    private static Map<String, DataSource> byFullName = new HashMap<String, DataSource>();
    private static Set<DataSource> registry = new HashSet<DataSource>();
    private static Map<String, DataSource> byAlias = new HashMap<String, DataSource>();
    private static Map<String, DataSource> byMiriamBase = new HashMap<String, DataSource>();
    private String sysCode = null;
    private String fullName = null;
    private String mainUrl = null;
    private String prefix = null;
    private String postfix = "";
    private Object organism = null;
    private String idExample = null;
    private boolean isPrimary = true;
    private boolean isDeprecated = false;
    private DataSource isDeprecatedBy = null;
    private String type = "unknown";
    private String miriamBase = null;
    private String alternative = null;
    private String description = null;
    private static boolean strictDataSourceChecking = true;

    private DataSource(String sysCode, String fullName) {
        this.sysCode = sysCode;
        this.fullName = fullName;
        if (DataSource.isSuitableKey(sysCode)) {
            bySysCode.put(sysCode, this);
        }
        if (DataSource.isSuitableKey(fullName)) {
            byFullName.put(fullName, this);
        }
    }

    @Deprecated
    public static void setStrictDataSourceChecking(boolean checkDataSources) {
        strictDataSourceChecking = checkDataSources;
    }

    public String getUrl(String id) {
        if (this.prefix == null) {
            return id + this.postfix;
        }
        return this.prefix + id + this.postfix;
    }

    public String getKnownUrl(String id) {
        if (this.prefix == null) {
            return null;
        }
        return this.prefix + id + this.postfix;
    }

    public boolean urlPatternKnown() {
        return this.prefix != null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSystemCode() {
        return this.sysCode;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getURN(String id) {
        String idPart;
        try {
            idPart = URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            idPart = id;
        }
        if (this.miriamBase == null) {
            return this.sysCode + ":" + id;
        }
        return URN_PREFIX + this.miriamBase + ":" + idPart;
    }

    public String getMiriamURN(String id) {
        String idPart;
        if (this.miriamBase == null) {
            return null;
        }
        try {
            idPart = URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            idPart = id;
        }
        return URN_PREFIX + this.miriamBase + ":" + idPart;
    }

    public String getIdentifiersOrgUri(String id) {
        if (this.miriamBase == null) {
            return null;
        }
        return IDENTIFIERS_ORG_PREFIX + this.miriamBase + "/" + id;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder register(String sysCode, String fullName) {
        if (!DataSource.isSuitableKey(sysCode)) {
            throw new IllegalArgumentException("Unsuitable sysCode " + sysCode + " with " + fullName);
        }
        if (!DataSource.isSuitableKey(fullName)) {
            throw new IllegalArgumentException("Unsuitable fullName " + fullName + " with " + sysCode);
        }
        return DataSource.findOrRegister(sysCode, fullName);
    }

    private static Builder findOrRegister(String sysCode, String fullName) {
        DataSource current = null;
        if (fullName == null && sysCode == null) {
            throw new NullPointerException();
        }
        if (byFullName.containsKey(fullName)) {
            current = byFullName.get(fullName);
            if (strictDataSourceChecking) {
                if (sysCode == null) {
                    if (current.getSystemCode() != null) {
                        throw new IllegalArgumentException("System code does not match for DataSource " + fullName + " was " + current.getSystemCode() + " so it can not be changed to null.");
                    }
                } else if (!sysCode.equals(current.getSystemCode())) {
                    throw new IllegalArgumentException("System code does not match for DataSource " + fullName + " was " + current.getSystemCode() + " so it can not be changed to " + sysCode);
                }
            }
        } else if (bySysCode.containsKey(sysCode)) {
            current = bySysCode.get(sysCode);
            if (strictDataSourceChecking) {
                if (fullName == null) {
                    if (current.getFullName() != null) {
                        throw new IllegalArgumentException("Full name does not match for DataSource " + sysCode + " was " + current.getFullName() + " so it can not be changed to " + null);
                    }
                } else if (!fullName.equals(current.getFullName())) {
                    throw new IllegalArgumentException("Full name does not match for DataSource " + sysCode + " was " + current.getFullName() + " so it can not be changed to " + fullName);
                }
            }
        } else {
            current = new DataSource(sysCode, fullName);
            registry.add(current);
        }
        return new Builder(current);
    }

    public void registerAlias(String alias) {
        byAlias.put(alias, this);
    }

    private static boolean isSuitableKey(String key) {
        return key != null && !"".equals(key);
    }

    public static DataSource getBySystemCode(String systemCode) {
        if (!bySysCode.containsKey(systemCode) && DataSource.isSuitableKey(systemCode)) {
            System.err.println("Warning creating a new DataSource with systemCode " + systemCode + " and null fullName!");
            DataSource.findOrRegister(systemCode, null);
        }
        return bySysCode.get(systemCode);
    }

    public static DataSource getExistingBySystemCode(String systemCode) {
        if (bySysCode.containsKey(systemCode)) {
            return bySysCode.get(systemCode);
        }
        throw new IllegalArgumentException("No DataSource known for " + systemCode);
    }

    public static boolean systemCodeExists(String systemCode) {
        return bySysCode.containsKey(systemCode);
    }

    public static DataSource getByFullName(String fullName) {
        if (!byFullName.containsKey(fullName) && DataSource.isSuitableKey(fullName)) {
            System.err.println("Warning creating a new DataSource with fullName " + fullName + " and null systemCode!");
            DataSource.findOrRegister(null, fullName);
        }
        return byFullName.get(fullName);
    }

    public static DataSource getExistingByFullName(String fullName) {
        if (byFullName.containsKey(fullName)) {
            return byFullName.get(fullName);
        }
        throw new IllegalArgumentException("No DataSource known for " + fullName);
    }

    public static boolean fullNameExists(String fullName) {
        return byFullName.containsKey(fullName);
    }

    public static DataSource getByAlias(String alias) {
        return byAlias.get(alias);
    }

    public static Set<DataSource> getDataSources() {
        return registry;
    }

    public static Set<DataSource> getFilteredSet(Boolean primary, Boolean metabolite, Object o) {
        HashSet<DataSource> result = new HashSet<DataSource>();
        for (DataSource ds : registry) {
            if (primary != null && ds.isPrimary() != primary.booleanValue() || metabolite != null && ds.isMetabolite() != metabolite.booleanValue() || o != null && ds.organism != null && o != ds.organism) continue;
            result.add(ds);
        }
        return result;
    }

    public static List<String> getFullNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(byFullName.keySet());
        return result;
    }

    public String toString() {
        return this.fullName;
    }

    public Xref getExample() {
        return new Xref(this.idExample, this);
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public DataSource isDeprecatedBy() {
        return this.isDeprecatedBy;
    }

    public boolean isMetabolite() {
        return this.type.equals("metabolite");
    }

    public Object getOrganism() {
        return this.organism;
    }

    public static DataSource getByUrnBase(String base) {
        if (base == null || !base.startsWith(URN_PREFIX)) {
            return null;
        }
        String key = base.substring(URN_PREFIX.length());
        if (byMiriamBase.containsKey(key)) {
            return byMiriamBase.get(key);
        }
        DataSource current = DataSource.getByFullName(key);
        current.miriamBase = key;
        byMiriamBase.put(key, current);
        return current;
    }

    public static DataSource getByMiriamBase(String base) {
        if (base == null || !base.startsWith(URN_PREFIX)) {
            return null;
        }
        String key = base.substring(URN_PREFIX.length());
        return byMiriamBase.get(key);
    }

    public static DataSource getByIdentiferOrgBase(String base) {
        if (base == null || !base.startsWith(IDENTIFIERS_ORG_PREFIX)) {
            return null;
        }
        Object current = null;
        String key = base.substring(IDENTIFIERS_ORG_PREFIX.length());
        if (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        return byMiriamBase.get(key);
    }

    static {
        strictDataSourceChecking = "true".equalsIgnoreCase(System.getProperty("strictDataSourceChecking", "true"));
    }

    public static final class Builder {
        private final DataSource current;

        private Builder(DataSource current) {
            this.current = current;
        }

        public DataSource asDataSource() {
            return this.current;
        }

        public Builder urlPattern(String urlPattern) {
            if (urlPattern == null || "".equals(urlPattern)) {
                return this;
            }
            String oldUrlPattern = this.current.getKnownUrl("$id");
            if (oldUrlPattern != null) {
                if (oldUrlPattern.equals(urlPattern)) {
                    return this;
                }
                throw new IllegalArgumentException("DataSource " + this.current + " already has a URL Pattern of " + oldUrlPattern + " so unable to set to " + urlPattern);
            }
            int pos = urlPattern.indexOf("$id");
            if (pos == -1) {
                throw new IllegalArgumentException("Url maker pattern for " + this.current + "' should have $id in it");
            }
            this.current.prefix = urlPattern.substring(0, pos);
            this.current.postfix = urlPattern.substring(pos + 3);
            return this;
        }

        public Builder mainUrl(String mainUrl) {
            if (mainUrl == null || mainUrl.isEmpty()) {
                return this;
            }
            if (this.current.mainUrl == null) {
                this.current.mainUrl = mainUrl;
                return this;
            }
            if (this.current.mainUrl.equals(mainUrl)) {
                return this;
            }
            throw new IllegalArgumentException("Illegal attempt to change mainUrl for " + this.current + " from " + this.current.mainUrl + " to " + mainUrl);
        }

        public Builder idExample(String idExample) {
            this.current.idExample = idExample;
            return this;
        }

        public Builder primary(boolean isPrimary) {
            this.current.isPrimary = isPrimary;
            return this;
        }

        public Builder deprecated(boolean isDeprecated) {
            if (!isDeprecated) {
                this.current.isDeprecatedBy = null;
            }
            this.current.isDeprecated = isDeprecated;
            return this;
        }

        public Builder deprecatedBy(DataSource sourceToUseInstead) {
            if (sourceToUseInstead == null) {
                throw new IllegalArgumentException("DataSource cannot be null.");
            }
            this.current.isDeprecated = true;
            this.current.isDeprecatedBy = sourceToUseInstead;
            return this;
        }

        public Builder type(String type) {
            if (type == null || type.isEmpty()) {
                return this;
            }
            if (this.current.type.equals(DataSource.UNKOWN)) {
                this.current.type = type;
                return this;
            }
            if (this.current.type.equals(type)) {
                return this;
            }
            throw new IllegalArgumentException("Illegal attempt to change the type of DataSource " + this.current + " from " + this.current.type + " to " + type);
        }

        public Builder organism(Object organism) {
            if (organism == null) {
                return this;
            }
            if (this.current.organism == null) {
                this.current.organism = organism;
                return this;
            }
            if (this.current.organism.equals(organism)) {
                return this;
            }
            if (this.current.organism instanceof String && organism instanceof String && ((String)this.current.organism).equals((String)organism)) {
                return this;
            }
            throw new IllegalArgumentException("Illegal attempt to change the organism of DataSource " + this.current + " from " + this.current.organism + " to " + organism);
        }

        public Builder urnBase(String base) {
            if (base == null) {
                return this;
            }
            if (base.equals(this.current.sysCode)) {
                return this;
            }
            if ((base = base.trim()).isEmpty()) {
                return this;
            }
            if (base.startsWith(DataSource.URN_PREFIX)) {
                return this.miriamBase(base.substring(DataSource.URN_PREFIX.length()));
            }
            throw new IllegalArgumentException("UrnBase must start with urn:miriam: so can not accept " + base);
        }

        public Builder identifiersOrgBase(String base) {
            if (base == null) {
                return this;
            }
            if ((base = base.trim()).isEmpty()) {
                return this;
            }
            if (base.startsWith(DataSource.IDENTIFIERS_ORG_PREFIX)) {
                if (base.endsWith("/$id")) {
                    base = base.substring(0, base.length() - 4);
                } else if (base.endsWith("/")) {
                    base = base.substring(0, base.length() - 1);
                }
                return this.miriamBase(base.substring(DataSource.IDENTIFIERS_ORG_PREFIX.length()));
            }
            throw new IllegalArgumentException("identifiers.org base must start with http://identifiers.org/ so can not accept " + base);
        }

        private Builder miriamBase(String base) {
            if (this.current.miriamBase == null) {
                this.current.miriamBase = base;
                byMiriamBase.put(base, this.current);
            } else if (!this.current.miriamBase.equals(base)) {
                throw new IllegalArgumentException("Illegal attempt to change miriam base for " + this.current + " from " + this.current.miriamBase + " to " + base);
            }
            return this;
        }

        public Builder alternative(String alternative) {
            if (alternative == null || alternative.isEmpty()) {
                return this;
            }
            if (this.current.alternative == null) {
                this.current.alternative = alternative;
            } else if (!this.current.alternative.equals(alternative)) {
                throw new IllegalArgumentException("Illegal attempt to change alternative for " + this.current + " from " + this.current.alternative + " to " + alternative);
            }
            return this;
        }

        public Builder description(String description) {
            if (description == null || description.isEmpty()) {
                return this;
            }
            if (this.current.description == null) {
                this.current.description = description;
            } else if (!this.current.description.equals(description)) {
                throw new IllegalArgumentException("Illegal attempt to change description for " + this.current + " from " + this.current.description + " to " + description);
            }
            return this;
        }
    }
}

