/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashSet;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DataSourceRegisterTest {
    private static Set<String> NO_ALTERNATIVES = new HashSet<String>();

    @Test
    public void testBoth() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_Both";
        String fullName = "DataSourceRegistryTest_testBoth";
        DataSource ds = DataSource.register((String)sysCode, (String)fullName).asDataSource();
        Assert.assertEquals((Object)fullName, (Object)ds.getFullName());
        Assert.assertEquals((Object)sysCode, (Object)ds.getSystemCode());
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testFullNameOnly() throws IDMapperException {
        String fullName = "DataSourceRegistryTest_testFullNameOnly";
        DataSource ds = DataSource.register(null, (String)fullName).asDataSource();
        Assert.assertEquals((Object)fullName, (Object)ds.getFullName());
        Assert.assertEquals(null, (Object)ds.getSystemCode());
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSysCodeOnly() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_SysCodeOnly";
        DataSource ds = DataSource.register((String)sysCode, null).asDataSource();
        Assert.assertEquals(null, (Object)ds.getFullName());
        Assert.assertEquals((Object)sysCode, (Object)ds.getSystemCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecondFullName() throws IDMapperException {
        System.out.println("SecondFullName");
        String sysCode = "DataSourceRegistryTest_SecondFullName";
        String fullName1 = "DataSourceRegistryTest_testSecondFullName1";
        String fullName2 = "DataSourceRegistryTest_testSecondFullName2";
        DataSource ds1 = DataSource.register((String)sysCode, (String)fullName1).asDataSource();
        DataSource ds2 = DataSource.register((String)sysCode, (String)fullName2).asDataSource();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecondNullFullName() throws IDMapperException {
        System.out.println("SecondNullFullName");
        String sysCode = "DataSourceRegistryTest_SecondNullFullName";
        String fullName1 = "DataSourceRegistryTest_SecondNullFullName";
        DataSource ds1 = DataSource.register((String)sysCode, (String)fullName1).asDataSource();
        DataSource ds2 = DataSource.register((String)sysCode, null).asDataSource();
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testNullThenFullName() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_NullThenFullName";
        String fullName2 = "DataSourceRegistryTest_testNullThenFullName";
        DataSource ds1 = DataSource.register((String)sysCode, null).asDataSource();
        DataSource ds2 = DataSource.register((String)sysCode, (String)fullName2).asDataSource();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecondSysCode() throws IDMapperException {
        String sysCode1 = "DataSourceRegistryTest_SecondSysCode1";
        String sysCode2 = "DataSourceRegistryTest_SecondSysCode2";
        String fullName = "DataSourceRegistryTest_testFactorySecondSysCode";
        DataSource ds1 = DataSource.register((String)sysCode1, (String)fullName).asDataSource();
        DataSource ds2 = DataSource.register((String)sysCode2, (String)fullName).asDataSource();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecondNullSysCode() throws IDMapperException {
        String sysCode1 = "DataSourceRegistryTest_RegisterSecondNullSysCode1";
        String fullName = "DataSourceRegistryTest_testSecondNullSysCode";
        DataSource ds1 = DataSource.register((String)sysCode1, (String)fullName).asDataSource();
        DataSource ds2 = DataSource.register(null, (String)fullName).asDataSource();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThenSysCode() throws IDMapperException {
        String sysCode2 = "DataSourceRegistryTest_NullThenSysCode";
        String fullName = "DataSourceRegistryTest_NullThenSysCode";
        DataSource ds1 = DataSource.register(null, (String)fullName).asDataSource();
        DataSource ds2 = DataSource.register((String)sysCode2, (String)fullName).asDataSource();
    }
}

