/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.junit.BeforeClass;
import org.junit.Ignore;

@Ignore
public abstract class IDMapperTestBase {
    protected static String dataSource1Code;
    protected static String dataSource2Code;
    protected static String dataSource3Code;
    protected static DataSource DataSource1;
    protected static DataSource DataSource2;
    protected static DataSource DataSource3;
    protected static DataSource DataSourceBad;
    protected static String ds1Id1;
    protected static String ds2Id1;
    protected static String ds3Id1;
    protected static String ds1Id2;
    protected static String ds2Id2;
    protected static String ds3Id2;
    protected static String ds1Id3;
    protected static String ds2Id3;
    protected static String ds3Id3;
    protected static Xref map1xref1;
    protected static Xref map1xref2;
    protected static Xref map1xref3;
    protected static Xref map2xref1;
    protected static Xref map2xref2;
    protected static Xref map2xref3;
    protected static Xref map3xref1;
    protected static Xref map3xref2;
    protected static Xref map3xref3;
    protected static String badID;
    protected static Xref mapBadxref1;
    protected static Xref mapBadxref2;
    protected static Xref mapBadxref3;
    protected static Xref HALFNULL1;
    protected static Xref HALFNULL2;
    protected static String badKey;
    protected static final String uriSpace1 = "http://www.conceptwiki.org/concept/$id";
    protected static final String uriSpace2 = "http://www.chemspider.com/Chemical-Structure.$id.html";
    protected static final String uriSpace3 = "http://chemistry.openphacts.org/OPS$id";

    @BeforeClass
    public static void setupXref() throws IDMapperException {
        dataSource1Code = "ConceptWiki";
        DataSource1 = DataSource.register((String)dataSource1Code, (String)"ConceptWiki").urlPattern(uriSpace1).idExample("33a28bb2-35ed-4d94-adfd-3c96053cbaaf").asDataSource();
        dataSource2Code = "Cs";
        DataSource2 = DataSource.register((String)dataSource2Code, (String)"Chemspider").urlPattern(uriSpace2).idExample("56586").asDataSource();
        dataSource3Code = "OPS-CRS";
        DataSource3 = DataSource.register((String)dataSource3Code, (String)"OPS Chemical Registry Service").urlPattern(uriSpace3).idExample("8").asDataSource();
        DataSourceBad = DataSource.register((String)"TestDSBad", (String)"TestDSBad").urlPattern("http://www.NotInTheURlMapper.com#$id").asDataSource();
        ds1Id1 = "f25a234e-df03-419f-8504-cde8689a4d1f";
        map1xref1 = new Xref(ds1Id1, DataSource1);
        ds2Id1 = "28509384";
        map1xref2 = new Xref(ds2Id1, DataSource2);
        ds3Id1 = "8";
        map1xref3 = new Xref(ds3Id1, DataSource3);
        ds1Id2 = "23a8be84-7177-42ba-800c-dd9192d69ac6";
        map2xref1 = new Xref(ds1Id2, DataSource1);
        ds2Id2 = "28524249";
        map2xref2 = new Xref(ds2Id2, DataSource2);
        ds3Id2 = "70263";
        map2xref3 = new Xref(ds3Id2, DataSource3);
        ds1Id3 = "f65bcedd-f18f-41ae-b1dd-9af4ed6a1f26";
        map3xref1 = new Xref(ds1Id3, DataSource1);
        ds2Id3 = "23202612";
        map3xref2 = new Xref(ds2Id3, DataSource2);
        ds3Id3 = "1497600";
        map3xref3 = new Xref(ds3Id3, DataSource3);
        badID = "ThisIdIsNotinTheSystem";
        mapBadxref1 = new Xref("123", DataSourceBad);
        mapBadxref2 = new Xref(badID, DataSource2);
        mapBadxref3 = new Xref("789", DataSourceBad);
        HALFNULL1 = new Xref("123", null);
        HALFNULL2 = new Xref(null, DataSource1);
        badKey = "NoT A ProPertY keY";
    }

    public void report(String message) {
        System.out.println(message);
    }
}

