/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.file.IDMapperText;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFile {
    private static final File YEAST_IDS = new File("test-data/yeast_id_mapping.txt");
    private static final DataSource ENS_YEAST = DataSource.getByFullName((String)"Ensembl Yeast");
    private static final DataSource ENTREZ = DataSource.getByFullName((String)"Entrez Gene");
    private static final DataSource EMBL = DataSource.getByFullName((String)"EMBL");
    private static final Xref XREF1 = new Xref("YHR055C", ENS_YEAST);

    @Before
    public void setUp() {
    }

    @Test
    public void testFiles() {
        Assert.assertTrue((boolean)YEAST_IDS.exists());
    }

    @Test
    public void testRead() throws IDMapperException, IOException {
        IDMapperText idMapper = new IDMapperText(YEAST_IDS.toURL());
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(XREF1);
        DataSource[] tgtDataSources = new DataSource[]{ENS_YEAST, ENTREZ, EMBL};
        long start = System.currentTimeMillis();
        Map mapXrefs = idMapper.mapID(srcXrefs, tgtDataSources);
        long end = System.currentTimeMillis();
        long delta = end - start;
        System.out.println(delta);
        HashSet<Xref> expected = new HashSet<Xref>();
        expected.addAll(Arrays.asList(new Xref("YHR055C", ENS_YEAST), new Xref("U00061", EMBL), new Xref("K02204", EMBL), new Xref("AY558517", EMBL), new Xref("AY693077", EMBL), new Xref("856452", ENTREZ), new Xref("856450", ENTREZ)));
        Set xrefs = (Set)mapXrefs.get(XREF1);
        Assert.assertEquals(expected, (Object)xrefs);
        for (Xref xr : xrefs) {
            System.out.println(xr.getDataSource().getFullName() + ": " + xr.getId());
        }
        Xref nonsense = new Xref("Humbug", DataSource.getByFullName((String)"Ebenizer Scrooge"));
        Assert.assertEquals((long)0L, (long)idMapper.mapID(nonsense, new DataSource[0]).size());
    }

    public void _testTransitive() throws MalformedURLException, IDMapperException {
        IDMapperText idMapper = new IDMapperText(YEAST_IDS.toURL(), new char[]{'\t'}, new char[]{','}, true);
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(XREF1);
        DataSource[] tgtDataSources = new DataSource[]{ENS_YEAST, ENTREZ, EMBL};
        long start = System.currentTimeMillis();
        Map mapXrefs = idMapper.mapID(srcXrefs, tgtDataSources);
        long end = System.currentTimeMillis();
        long delta = end - start;
        System.out.println(delta);
        System.out.println(mapXrefs);
        Set xrefs = (Set)mapXrefs.get(XREF1);
        for (Xref xr : xrefs) {
            System.out.println(xr.getDataSource().getFullName() + ": " + xr.getId());
        }
    }
}

