/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashMap;
import java.util.Map;
import org.bridgedb.Driver;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;

public final class BridgeDb {
    private static Map<String, Driver> drivers = new HashMap<String, Driver>();

    private BridgeDb() {
    }

    public static IDMapper connect(String connectionString) throws IDMapperException {
        int pos = connectionString.indexOf(":");
        if (pos < 0) {
            throw new IDMapperException("connection String must be of the form 'protocol:location'");
        }
        String protocol = connectionString.substring(0, pos);
        String location = connectionString.substring(pos + 1);
        if (drivers.containsKey(protocol)) {
            return drivers.get(protocol).connect(location);
        }
        throw new IDMapperException("Unknown protocol: " + protocol);
    }

    public static void register(String protocol, Driver driver) {
        drivers.put(protocol, driver);
    }
}

