/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class InternalUtils {
    private static final int MS_CONNECTION_TIMEOUT = 2000;

    private InternalUtils() {
    }

    public static Map<Xref, Set<Xref>> mapMultiFromSingle(IDMapper mapper, Collection<Xref> srcXrefs, DataSource ... tgt) throws IDMapperException {
        HashMap<Xref, Set<Xref>> result = new HashMap<Xref, Set<Xref>>();
        for (Xref src : srcXrefs) {
            Set<Xref> refs = mapper.mapID(src, tgt);
            if (refs.size() <= 0) continue;
            result.put(src, refs);
        }
        return result;
    }

    public static Set<Xref> mapSingleFromMulti(IDMapper mapper, Xref src, DataSource ... tgt) throws IDMapperException {
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(src);
        Map<Xref, Set<Xref>> mapXrefs = mapper.mapID(srcXrefs, tgt);
        if (mapXrefs.containsKey(src)) {
            return mapXrefs.get(src);
        }
        return Collections.emptySet();
    }

    public static Map<String, String> parseLocation(String location, String ... allowedParams) {
        String[] args;
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> allowedSet = new HashSet<String>(Arrays.asList(allowedParams));
        String param = location;
        int idx = location.indexOf(63);
        if (idx > -1) {
            if (idx > 0) {
                result.put("BASE", location.substring(0, idx));
            }
            param = location.substring(idx + 1);
        }
        if ("".equals(param)) {
            return result;
        }
        for (String arg : args = param.split("&")) {
            String key;
            idx = arg.indexOf("=");
            if (idx > -1) {
                key = arg.substring(0, idx);
                if (!allowedSet.contains(key)) {
                    throw new IllegalArgumentException("Unexpected property '" + key + "'");
                }
            } else {
                throw new IllegalArgumentException("Could not parse argument " + arg + ". Expected key=val format");
            }
            String val = arg.substring(idx + 1);
            result.put(key, val);
        }
        return result;
    }

    public static InputStream getInputStream(String source) throws IOException {
        URL url = new URL(source);
        return InternalUtils.getInputStream(url);
    }

    public static InputStream getInputStream(URL source) throws IOException {
        InputStream stream = null;
        int expCount = 0;
        int timeOut = 2000;
        while (true) {
            try {
                URLConnection uc = source.openConnection();
                uc.setUseCaches(false);
                uc.setConnectTimeout(timeOut);
                stream = uc.getInputStream();
            }
            catch (IOException e) {
                if (expCount++ == 4) {
                    throw e;
                }
                timeOut *= 2;
                continue;
            }
            break;
        }
        return stream;
    }

    public static <T, U> void multiMapPut(Map<T, Set<U>> map, T key, U val) {
        Set<Object> set;
        if (map.containsKey(key)) {
            set = map.get(key);
        } else {
            set = new HashSet();
            map.put(key, set);
        }
        set.add(val);
    }

    public static <T, U> void multiMapAdd(Map<T, List<U>> map, T key, U val) {
        List<Object> list;
        if (map.containsKey(key)) {
            list = map.get(key);
        } else {
            list = new ArrayList();
            map.put(key, list);
        }
        list.add(val);
    }

    public static <T, U> void multiMapPutAll(Map<T, Set<U>> map, T key, Collection<U> vals) {
        Set<Object> set;
        if (map.containsKey(key)) {
            set = map.get(key);
        } else {
            set = new HashSet();
            map.put(key, set);
        }
        set.addAll(vals);
    }

    public static Map<DataSource, Set<Xref>> groupByDataSource(Collection<Xref> srcXrefs) {
        HashMap<DataSource, Set<Xref>> result = new HashMap<DataSource, Set<Xref>>();
        for (Xref ref : srcXrefs) {
            InternalUtils.multiMapPut(result, ref.getDataSource(), ref);
        }
        return result;
    }

    public static String joinIds(Collection<Xref> refs, String sep) {
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (Xref ref : refs) {
            if (!first) {
                builder.append(sep);
            }
            builder.append(ref.getId());
            first = false;
        }
        return builder.toString();
    }

    public static void readXmlConfig(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(new ConfigXmlHandler());
        xmlReader.parse(is);
    }

    private static class ConfigXmlHandler
    extends DefaultHandler {
        DataSource current = null;

        private ConfigXmlHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String alias;
            if ("datasource".equals(localName)) {
                String fullname = atts.getValue("fullname");
                if (fullname == null) {
                    throw new SAXException("missing attribute fullname");
                }
                this.current = DataSource.getByFullName(fullname);
            }
            if ("alias".equals(localName) && (alias = atts.getValue("name")) != null && this.current != null) {
                this.current.registerAlias(alias);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ("datasource".equals(localName)) {
                this.current = null;
            }
        }
    }
}

