/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilitiesTest;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public abstract class IDMapperTest
extends IDMapperCapabilitiesTest {
    protected static IDMapper idMapper;
    protected static boolean connectionOk;

    @AfterAll
    public static void testClose() throws IDMapperException {
        if (connectionOk) {
            Assert.assertTrue((boolean)idMapper.isConnected());
            idMapper.close();
            Assert.assertFalse((boolean)idMapper.isConnected());
        }
    }

    @Test
    public void testMapIDManyToManyNoDataSources() throws IDMapperException {
        this.report("MapIDManyToManyNoDataSources");
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(map1xref1);
        srcXrefs.add(map2xref2);
        srcXrefs.add(mapBadxref1);
        Map results = idMapper.mapID(srcXrefs, new DataSource[0]);
        Set resultSet = (Set)results.get(map1xref1);
        Assert.assertNotNull((Object)resultSet);
        Assert.assertTrue((boolean)resultSet.contains(map1xref2));
        Assert.assertTrue((boolean)resultSet.contains(map1xref3));
        Assert.assertFalse((boolean)resultSet.contains(map2xref1));
        Assert.assertFalse((boolean)resultSet.contains(map2xref3));
        resultSet = (Set)results.get(map2xref2);
        Assert.assertNotNull((Object)resultSet);
        Assert.assertFalse((boolean)resultSet.contains(map1xref2));
        Assert.assertFalse((boolean)resultSet.contains(map1xref3));
        Assert.assertTrue((boolean)resultSet.contains(map2xref1));
        Assert.assertTrue((boolean)resultSet.contains(map2xref3));
        resultSet = (Set)results.get(map2xref1);
        Assert.assertNull((Object)resultSet);
        resultSet = (Set)results.get(map3xref1);
        Assert.assertNull((Object)resultSet);
        resultSet = (Set)results.get(mapBadxref1);
        if (resultSet != null && !resultSet.isEmpty()) {
            Assert.assertEquals((long)1L, (long)resultSet.size());
            Assert.assertTrue((boolean)resultSet.contains(mapBadxref1));
        }
    }

    @Test
    public void testMapIDOneToManyNoDataSources() throws IDMapperException {
        this.report("MapIDOneToManyNoDataSources");
        Set results = idMapper.mapID(map1xref1, new DataSource[0]);
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertTrue((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneBad() throws IDMapperException {
        this.report("MapIDOneToManyNoDataSources");
        Set results = idMapper.mapID(mapBadxref1, new DataSource[0]);
        if (results != null && !results.isEmpty()) {
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(mapBadxref1));
        }
    }

    @Test
    public void testMapIDOneBadWithTarget() throws IDMapperException {
        this.report("MapIDOneToManyNoDataSourcesWithTarget");
        Set results = idMapper.mapID(mapBadxref1, new DataSource[]{DataSource2});
        if (results != null && !results.isEmpty()) {
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(mapBadxref1));
        }
    }

    @Test
    public void testMapIDOneToManyWithOneDataSource() throws IDMapperException {
        this.report("MapIDOneToManyWithOneDataSource");
        Set results = idMapper.mapID(map1xref1, new DataSource[]{DataSource2});
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertFalse((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneToManyWithTwoDataSources() throws IDMapperException {
        this.report("MapIDOneToManyWithTwoDataSources");
        Set results = idMapper.mapID(map1xref1, new DataSource[]{DataSource2, DataSource3});
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertTrue((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneToManyNoDataSources2() throws IDMapperException {
        this.report("MapIDOneToManyNoDataSources");
        Set results = idMapper.mapID(map2xref1, new DataSource[0]);
        Assert.assertTrue((boolean)results.contains(map2xref2));
        Assert.assertTrue((boolean)results.contains(map2xref3));
        Assert.assertFalse((boolean)results.contains(map1xref2));
        Assert.assertFalse((boolean)results.contains(map3xref2));
    }

    @Test
    public void testXrefSupported() throws Exception {
        this.report("XrefSupported");
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref3));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref3));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref3));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref1));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref2));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref3));
    }

    @Test
    public void testFreeSearchBad() throws IDMapperException {
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        Assume.assumeTrue((badID != null ? 1 : 0) != 0);
        this.report("FreeSearchBad");
        Set results = idMapper.freeSearch(badID, 10);
        Assert.assertTrue((results == null || results.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testFreeSearchGood() throws IDMapperException {
        this.report("FreeSearchGood");
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        this.report("FreeSearchGood");
        Set results = idMapper.freeSearch(ds1Id1, 10);
        if (results.size() < 10) {
            Assert.assertTrue((boolean)results.contains(map1xref1));
        }
        Assert.assertFalse((boolean)results.contains(map2xref1));
    }

    @Test
    @Disabled
    public void testFreeSearchGoodJust2() throws IDMapperException {
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        this.report("FreeSearchGoodJust2");
        Set results = idMapper.freeSearch("An id used more than twice here", 2);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testXrefWithHalfNullXrefs() throws IDMapperException {
        this.report("XrefWithHalfNullXrefs");
        Assert.assertFalse((boolean)idMapper.xrefExists(HALFNULL1));
        Assert.assertFalse((boolean)idMapper.xrefExists(HALFNULL2));
    }

    @Test
    public void testIDMapperHalfNullXrefs() throws IDMapperException {
        this.report("IDMapperHalfNullXrefs");
        Set result = idMapper.mapID(HALFNULL1, new DataSource[0]);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs2() throws IDMapperException {
        this.report("IDMapperHalfNullXrefs2");
        Set result = idMapper.mapID(HALFNULL2, new DataSource[0]);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs3() throws IDMapperException {
        this.report("IDMapperHalfNullXrefs3");
        Set result = idMapper.mapID(HALFNULL1, new DataSource[]{DataSource2, DataSource3});
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs4() throws IDMapperException {
        this.report("IDMapperHalfNullXrefs4");
        Set result = idMapper.mapID(HALFNULL2, new DataSource[]{DataSource2, DataSource3});
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperSeveralHalfNullXrefs() throws IDMapperException {
        this.report("IDMapperSeveralHalfNullXrefs");
        HashSet<Xref> src = new HashSet<Xref>();
        src.add(HALFNULL1);
        src.add(HALFNULL2);
        Map result = idMapper.mapID(src, new DataSource[]{DataSource2, DataSource3});
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    static {
        connectionOk = true;
    }
}

