/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.bridgedb.DataSource;

public class Xref
implements Comparable<Xref> {
    private final String id;
    private final DataSource ds;
    private final boolean isPrimary;
    private final String rep;

    public Xref(String id, DataSource ds) {
        this.id = id;
        this.ds = ds;
        this.rep = (ds == null ? "" : (ds.getSystemCode() == null ? ds.getFullName() : ds.getSystemCode())) + ":" + id;
        this.isPrimary = true;
    }

    public Xref(String id, DataSource ds, boolean isPrimary) {
        this.id = id;
        this.ds = ds;
        this.rep = (ds == null ? "" : (ds.getSystemCode() == null ? ds.getFullName() : ds.getSystemCode())) + ":" + id;
        this.isPrimary = isPrimary;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public String toString() {
        return this.rep + ":" + (this.isPrimary() ? "T" : "F");
    }

    public int hashCode() {
        return this.rep.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Xref)) {
            return false;
        }
        Xref ref = (Xref)o;
        return (this.id == null ? ref.id == null : this.id.equals(ref.id)) && (this.ds == null ? ref.ds == null : this.ds.equals(ref.ds)) && ref.isPrimary() == this.isPrimary;
    }

    @Override
    public int compareTo(Xref idc) {
        return this.rep.compareTo(idc.rep);
    }

    public String getKnownUrl() {
        if (this.ds == null) {
            return null;
        }
        return this.ds.getKnownUrl(this.id);
    }

    public String getMiriamURN() {
        return this.ds.getMiriamURN(this.id);
    }

    public String getCompactidentifier() {
        return this.ds.getCompactIdentifier(this.id);
    }

    public static Xref fromMiriamUrn(String urn) {
        String id;
        int pos = urn.lastIndexOf(":");
        if (pos < 0) {
            return null;
        }
        String base = urn.substring(0, pos);
        try {
            id = URLDecoder.decode(urn.substring(pos + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        DataSource ds = DataSource.getByMiriamBase(base);
        if (ds == null) {
            return null;
        }
        return new Xref(id, ds);
    }

    public static Xref fromCompactIdentifier(String compact) {
        int pos = compact.lastIndexOf(":");
        if (pos < 0) {
            return null;
        }
        String base = compact.substring(0, pos);
        String id = compact.substring(pos + 1);
        DataSource ds = DataSource.getByMiriamBase("urn:miriam:" + base);
        if (ds == null) {
            return null;
        }
        return new Xref(id, ds);
    }
}

