/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashSet;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DataSourceRegisterTest {
    private static Set<String> NO_ALTERNATIVES = new HashSet<String>();

    @Test
    public void testBoth() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_Both";
        String fullName = "DataSourceRegistryTest_testBoth";
        DataSource ds = DataSource.register((String)sysCode, (String)fullName).asDataSource();
        Assertions.assertEquals((Object)fullName, (Object)ds.getFullName());
        Assertions.assertEquals((Object)sysCode, (Object)ds.getSystemCode());
    }

    @Disabled
    @Test
    public void testFullNameOnly() throws IDMapperException {
        String fullName = "DataSourceRegistryTest_testFullNameOnly";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds = DataSource.register(null, (String)fullName).asDataSource();
            Assertions.assertEquals((Object)fullName, (Object)ds.getFullName());
        });
    }

    @Disabled
    @Test
    public void testSysCodeOnly() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_SysCodeOnly";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds = DataSource.register((String)sysCode, null).asDataSource();
            Assertions.assertNull((Object)ds.getFullName());
            Assertions.assertEquals((Object)sysCode, (Object)ds.getSystemCode());
        });
    }

    @Test
    public void testSecondFullName() throws IDMapperException {
        System.out.println("SecondFullName");
        String sysCode = "DataSourceRegistryTest_SecondFullName";
        String fullName1 = "DataSourceRegistryTest_testSecondFullName1";
        String fullName2 = "DataSourceRegistryTest_testSecondFullName2";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register((String)sysCode, (String)fullName1).asDataSource();
            DataSource ds2 = DataSource.register((String)sysCode, (String)fullName2).asDataSource();
        });
    }

    @Test
    public void testSecondNullFullName() throws IDMapperException {
        System.out.println("SecondNullFullName");
        String sysCode = "DataSourceRegistryTest_SecondNullFullName";
        String fullName1 = "DataSourceRegistryTest_SecondNullFullName";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register((String)sysCode, (String)fullName1).asDataSource();
            DataSource ds2 = DataSource.register((String)sysCode, null).asDataSource();
        });
    }

    @Disabled
    @Test
    public void testNullThenFullName() throws IDMapperException {
        String sysCode = "DataSourceRegistryTest_NullThenFullName";
        String fullName2 = "DataSourceRegistryTest_testNullThenFullName";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register((String)sysCode, null).asDataSource();
            DataSource ds2 = DataSource.register((String)sysCode, (String)fullName2).asDataSource();
        });
    }

    @Test
    public void testSecondSysCode() throws IDMapperException {
        String sysCode1 = "DataSourceRegistryTest_SecondSysCode1";
        String sysCode2 = "DataSourceRegistryTest_SecondSysCode2";
        String fullName = "DataSourceRegistryTest_testFactorySecondSysCode";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register((String)sysCode1, (String)fullName).asDataSource();
            DataSource ds2 = DataSource.register((String)sysCode2, (String)fullName).asDataSource();
        });
    }

    @Test
    public void testSecondNullSysCode() throws IDMapperException {
        String sysCode1 = "DataSourceRegistryTest_RegisterSecondNullSysCode1";
        String fullName = "DataSourceRegistryTest_testSecondNullSysCode";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register((String)sysCode1, (String)fullName).asDataSource();
            DataSource ds2 = DataSource.register(null, (String)fullName).asDataSource();
        });
    }

    @Test
    public void testNullThenSysCode() throws IDMapperException {
        String sysCode2 = "DataSourceRegistryTest_NullThenSysCode";
        String fullName = "DataSourceRegistryTest_NullThenSysCode";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource ds1 = DataSource.register(null, (String)fullName).asDataSource();
            DataSource ds2 = DataSource.register((String)sysCode2, (String)fullName).asDataSource();
        });
    }
}

