/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.List;
import java.util.Set;
import org.bridgedb.DataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DataSourceTest {
    @Test
    public void testAsDataSource() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").asDataSource();
        Assertions.assertNotNull((Object)source);
    }

    @Test
    public void testDataSourceCategories() {
        String[] categories = new String[]{"gene", "disease"};
        DataSource source = DataSource.mock((String)"Me", (String)"MeSH").categories(categories).asDataSource();
        Assertions.assertNotNull((Object)source);
        Assertions.assertNotNull((Object)source.getCategories());
        Assertions.assertEquals((int)2, (int)source.getCategories().length);
    }

    @Test
    public void testAddingCategories() {
        String[] categoriesArray = new String[]{"metabolites", "test", "test2"};
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").categories(categoriesArray).asDataSource();
        Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
        Assertions.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testBuilding() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").asDataSource();
        Assertions.assertEquals((Object)"X", (Object)source.getSystemCode());
        Assertions.assertEquals((Object)"Affymetrix", (Object)source.getFullName());
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register(null, (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"X", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"X", null));
    }

    @Test
    public void testBuildingMainUrl() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com").urlPattern(null).asDataSource();
        Assertions.assertEquals((Object)"http://www.affymetrix.com", (Object)source.getMainUrl());
        Assertions.assertEquals((Object)false, (Object)source.urlPatternKnown());
        DataSource source2 = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").urlPattern("http://www.uniprot.org/uniprot/$id").asDataSource();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source3 = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").urlPattern("http://www.uniprot.org/uniprot/$id").asDataSource();
            source3 = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").urlPattern("http://www.uniprot.org/$id").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source6 = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").urlPattern("http://www.uniprot.org/$id").asDataSource();
        });
        Assertions.assertEquals((Object)true, (Object)source2.urlPatternKnown());
        Assertions.assertEquals((Object)"http://identifiers.org/orphanet:$id/1234", (Object)source.getIdentifiersOrgUri("1234"));
        Assertions.assertEquals((Object)"orphanet:$id:1234", (Object)source.getCompactIdentifier("1234"));
    }

    @Test
    public void testChangeMainUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
            source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com/A").asDataSource();
        });
    }

    @Test
    public void testBuildingType() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("probe").asDataSource();
        Assertions.assertEquals((Object)"probe", (Object)source.getType());
        Assertions.assertFalse((boolean)source.isMetabolite());
    }

    @Disabled
    @Test
    public void testBuildingType1() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("metabolite").asDataSource();
        Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
        Assertions.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testBuildingPrimary() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").primary(false).asDataSource();
        Assertions.assertFalse((boolean)source.isPrimary());
        source = DataSource.register((String)"X", (String)"Affymetrix").primary(true).asDataSource();
        Assertions.assertTrue((boolean)source.isPrimary());
    }

    @Test
    public void testBuildingMetabolite() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").type("metabolite").asDataSource();
        Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
        Assertions.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testDeprecated() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecated(true).asDataSource();
        Assertions.assertTrue((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecated_False() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecated(true).deprecated(false).asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDefaultNotDeprecated() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecatedBy() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(DataSource.register((String)"En", (String)"Ensembl").asDataSource()).asDataSource();
        Assertions.assertTrue((boolean)source.isDeprecated());
        Assertions.assertNotNull((Object)source.isDeprecatedBy());
        Assertions.assertEquals((Object)"En", (Object)source.isDeprecatedBy().getSystemCode());
    }

    @Test
    public void testDeprecatedByUndoneByDeprecatedFalse() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(DataSource.register((String)"En", (String)"Ensembl").asDataSource()).deprecated(false).asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
        Assertions.assertNull((Object)source.isDeprecatedBy());
    }

    @Test
    public void testDeprecatedByNullCausesException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(null).asDataSource());
    }

    @Test
    public void testDefaultNoDeprecatedBy() {
        DataSource source = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        Assertions.assertNull((Object)source.isDeprecatedBy());
    }

    @Test
    public void testEquals() {
        DataSource source = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        DataSource source2 = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        Assertions.assertEquals((Object)source, (Object)source2);
    }

    @Test
    public void testEqualsToo() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"Cpc", (String)"PubChem-compound").asDataSource();
            DataSource source2 = DataSource.register((String)"Cpc", (String)"PubChem compound").asDataSource();
            Assertions.assertEquals((Object)source, (Object)source2);
        });
    }

    @Test
    public void testChangeType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("metabolite").asDataSource();
            Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
            Assertions.assertTrue((boolean)source.isMetabolite());
            source = DataSource.register((String)"X", (String)"Affymetrix").type("probe").asDataSource();
            Assertions.assertEquals((Object)"probe", (Object)source.getType());
            Assertions.assertFalse((boolean)source.isMetabolite());
        });
    }

    @Test
    public void testBuildingAlternative() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").alternative("MetaboLoci Alternative").asDataSource();
        Assertions.assertEquals((Object)"MetaboLoci Alternative", (Object)source.getAlternative());
    }

    @Test
    public void testBuildingDescription() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").description("MetaboLoci description").asDataSource();
        Assertions.assertEquals((Object)"MetaboLoci description", (Object)source.getDescription());
    }

    @Test
    public void testGetByPrefix() {
        DataSource chebi = DataSource.register((String)"Ce", (String)"ChEBI").compactIdentifierPrefix("chebi").identifiersOrgBase("").urnBase(null).type(null).idExample("Ce").mainUrl(null).asDataSource();
        Assertions.assertNotNull((Object)chebi);
        DataSource chebi2 = DataSource.register((String)"Ce", (String)"ChEBI").miriamBase("chebi").type("").identifiersOrgBase(null).mainUrl("").asDataSource();
        Assertions.assertNotNull((Object)chebi2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"Ce", (String)"ChEBI").miriamBase(null).asDataSource());
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"Ce", (String)"ChEBI").compactIdentifierPrefix(null).asDataSource());
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.register((String)"Ce", (String)"ChEBI").urnBase("test").asDataSource());
        DataSource source = DataSource.getByCompactIdentifierPrefix((String)"chebi");
        source = DataSource.register((String)"Gpl", (String)"Guide to Pharmacology").asDataSource();
        Assertions.assertEquals(null, (Object)source.getMiriamURN(""));
        Assertions.assertEquals(null, (Object)source.getCompactIdentifier("H"));
        Assertions.assertEquals(null, (Object)source.getCompactIdentifier("Gpl"));
        Assertions.assertEquals(null, (Object)source.getIdentifiersOrgUri(""));
        Assertions.assertEquals((Object)false, (Object)DataSource.systemCodeExists((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.getExistingBySystemCode((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DataSource.getExistingByFullName((String)""));
    }

    @Test
    public void testBuilders() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("probe").organism(null).alternative(null).urnBase("").identifiersOrgBase("http://identifiers.org/orphanet:$id").asDataSource();
        Assertions.assertEquals((Object)"probe", (Object)source.getType());
        Assertions.assertEquals(null, (Object)source.getOrganism());
        Assertions.assertEquals((Object)"Affymetrix", (Object)DataSource.getExistingByFullName((String)"Affymetrix").toString());
        Assertions.assertEquals((Object)true, (Object)DataSource.fullNameExists((String)"Affymetrix"));
        DataSource source2 = DataSource.register((String)"Eco", (String)"Ecocyc").alternative("").organism((Object)"Escherichia coli").identifiersOrgBase("http://identifiers.org/orphanet/$id").urnBase("Eco").asDataSource();
        Assertions.assertEquals((Object)"Escherichia coli", (Object)source2.getOrganism());
        Assertions.assertNotNull((Object)source2.getOrganism());
        DataSource source3 = DataSource.register((String)"Ec", (String)"Ecogene").urnBase("urn:miriam:ecogene").description(null).identifiersOrgBase("http://identifiers.org/ecogene/").alternative("MetaboLoci Alternative").asDataSource();
        Assertions.assertEquals((Object)"Ecogene", (Object)DataSource.getByMiriamBase((String)"urn:miriam:ecogene").toString());
        Assertions.assertEquals((Object)"urn:miriam:ecogene:urn%3Amiriam%3Aecogene", (Object)source3.getMiriamURN("urn:miriam:ecogene").toString());
        DataSource source4 = DataSource.register((String)"Ect", (String)"EPA CompTox").urnBase("urn:miriam:Ect").description("").asDataSource();
        Assertions.assertEquals((Object)"EPA CompTox", (Object)DataSource.getByMiriamBase((String)"urn:miriam:Ect").toString());
        Assertions.assertEquals(null, (Object)DataSource.getByMiriamBase(null));
        Assertions.assertEquals(null, (Object)DataSource.getByMiriamBase((String)"test"));
        source4.registerAlias("Ect");
        Assertions.assertEquals((Object)"EPA CompTox", (Object)DataSource.getByAlias((String)"Ect").toString());
        DataSource.getExistingBySystemCode((String)"Ect");
        DataSource source6 = DataSource.register((String)"R", (String)"RGD").organism((Object)"Rattus norvegicus").asDataSource();
        source6 = DataSource.register((String)"R", (String)"RGD").organism((Object)"Rattus norvegicus").asDataSource();
        Assertions.assertEquals((Object)"Rattus norvegicus", (Object)source6.getOrganism());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"R", (String)"RGD").organism((Object)"Rattus norvegicus").asDataSource();
            source5 = DataSource.register((String)"R", (String)"RGD").organism((Object)"Rattus").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").urnBase("urn:miriam:Ect").asDataSource();
            source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").urnBase("urn:miriam:ecogene").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").alternative("Metaboloci Alternative").asDataSource();
            source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").alternative("test").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").alternative("Metaboloci Alternative").asDataSource();
            source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").alternative("test").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").description("EPA CompTox Dashboard").asDataSource();
            source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").description("test").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").asDataSource();
            source5 = DataSource.register((String)"L", (String)"EPA CompTox").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ect", (String)"EPA CompTox").asDataSource();
            source5 = DataSource.register(null, (String)"EPA CompTox").asDataSource();
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source5 = DataSource.register((String)"Ec", (String)"Ecogene").identifiersOrgBase("test").asDataSource();
        });
    }

    @Test
    public void testGetters() {
        Set set = DataSource.getDataSources();
        Assertions.assertNotNull((Object)set);
        DataSource source = DataSource.register((String)"Ect", (String)"EPA CompTox").urnBase("urn:miriam:Ect").asDataSource();
        Assertions.assertEquals(null, (Object)source.getKnownUrl("Ect"));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet((Boolean)false, (Boolean)false, (Object)source));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet(null, null, null));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet((Boolean)true, (Boolean)true, (Object)source));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet(null, (Boolean)true, (Object)source));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet(null, (Boolean)false, (Object)source));
        Assertions.assertNotNull((Object)DataSource.getFilteredSet(null, (Boolean)false, (Object)"Escherichia coli"));
        List result = DataSource.getFullNames();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(null, (Object)DataSource.getByIdentiferOrgBase((String)"base"));
        Assertions.assertEquals(null, (Object)DataSource.getByIdentiferOrgBase(null));
        Assertions.assertEquals(null, (Object)DataSource.getByIdentiferOrgBase((String)"http://identifiers.org/ccds/"));
        Assertions.assertEquals(null, (Object)DataSource.getByIdentiferOrgBase((String)"http://identifiers.org/ccds"));
        Assertions.assertNotNull((Object)source.getCompactIdentifierPrefix());
    }
}

