/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import buildsystem.Measure;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.file.IDMapperText;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFile {
    private Measure measure;
    private static URL YEAST_IDS;
    private static DataSource ENSEMBL;
    private static DataSource ENTREZ;
    private static DataSource EMBL;
    private static Xref XREF1;

    @BeforeAll
    public static void init() {
        YEAST_IDS = TestFile.class.getClassLoader().getResource("yeast_id_mapping.txt");
        ENSEMBL = DataSource.mock((String)"En", (String)"Ensembl").asDataSource();
        ENTREZ = DataSource.mock((String)"L", (String)"Entrez Gene").asDataSource();
        EMBL = DataSource.mock((String)"Em", (String)"EMBL").asDataSource();
        XREF1 = new Xref("YHR055C", ENSEMBL);
    }

    @BeforeEach
    public void setUp() {
        this.measure = new Measure("bridgedb_timing.txt");
    }

    @Test
    public void testFiles() {
        Assertions.assertNotNull((Object)YEAST_IDS);
    }

    @Test
    public void testRead() throws IDMapperException, IOException {
        IDMapperText idMapper = new IDMapperText(YEAST_IDS);
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(XREF1);
        DataSource[] tgtDataSources = new DataSource[]{ENSEMBL, ENTREZ, EMBL};
        long start = System.currentTimeMillis();
        Map mapXrefs = idMapper.mapID(srcXrefs, tgtDataSources);
        long end = System.currentTimeMillis();
        long delta = end - start;
        System.out.println(delta);
        HashSet<Xref> expected = new HashSet<Xref>();
        expected.addAll(Arrays.asList(new Xref("YHR055C", ENSEMBL), new Xref("U00061", EMBL), new Xref("K02204", EMBL), new Xref("AY558517", EMBL), new Xref("AY693077", EMBL), new Xref("856452", ENTREZ), new Xref("856450", ENTREZ)));
        Set xrefs = (Set)mapXrefs.get(XREF1);
        Assertions.assertEquals(expected, (Object)xrefs);
        for (Xref xr : xrefs) {
            System.out.println(xr.getDataSource().getFullName() + ": " + xr.getId());
        }
        Xref nonsense = new Xref("Humbug", DataSource.register((String)"EbSc", (String)"Ebenizer Scrooge").asDataSource());
        Assertions.assertEquals((int)0, (int)idMapper.mapID(nonsense, new DataSource[0]).size());
    }

    public void _testTransitive() throws MalformedURLException, IDMapperException {
        IDMapperText idMapper = new IDMapperText(YEAST_IDS, new char[]{'\t'}, new char[]{','}, true);
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(XREF1);
        DataSource[] tgtDataSources = new DataSource[]{ENSEMBL, ENTREZ, EMBL};
        long start = System.currentTimeMillis();
        Map mapXrefs = idMapper.mapID(srcXrefs, tgtDataSources);
        long end = System.currentTimeMillis();
        long delta = end - start;
        System.out.println(delta);
        this.measure.add("timing::text file transitive", "" + delta, "msec");
        System.out.println(mapXrefs);
        Set xrefs = (Set)mapXrefs.get(XREF1);
        for (Xref xr : xrefs) {
            System.out.println(xr.getDataSource().getFullName() + ": " + xr.getId());
        }
    }
}

