/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bridgedb.Driver;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;

public final class BridgeDb {
    private static Map<String, Driver> drivers = new HashMap<String, Driver>();
    private static volatile String version;

    private BridgeDb() {
    }

    public static IDMapper connect(String connectionString) throws IDMapperException {
        int pos = connectionString.indexOf(":");
        if (pos < 0) {
            throw new IDMapperException("connection String must be of the form 'protocol:location'");
        }
        String protocol = connectionString.substring(0, pos);
        String location = connectionString.substring(pos + 1);
        if (drivers.containsKey(protocol)) {
            return drivers.get(protocol).connect(location);
        }
        throw new IDMapperException("Unknown protocol: " + protocol);
    }

    public static void register(String protocol, Driver driver) {
        drivers.put(protocol, driver);
    }

    public static String getVersion() {
        String string;
        block9: {
            if (version != null) {
                return version;
            }
            InputStream stream = BridgeDb.class.getResourceAsStream("/version.props");
            try {
                Properties props = new Properties();
                props.load(stream);
                string = version = props.getProperty("bridgedb.version");
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }
}

