/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class IDMapperCapabilitiesTest
extends IDMapperTestBase {
    protected static IDMapperCapabilities capabilities;

    @Test
    public void testDataSourceSupported() throws Exception {
        this.report("DataSourceSupported");
        Set dataSources = capabilities.getSupportedSrcDataSources();
        Assertions.assertTrue((boolean)dataSources.contains(DataSource1));
        Assertions.assertTrue((boolean)dataSources.contains(DataSource2));
        Assertions.assertTrue((boolean)dataSources.contains(DataSource3));
        Assertions.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testDataTargetSupported() throws Exception {
        this.report("DataTagerSupported");
        Set dataSources = capabilities.getSupportedTgtDataSources();
        DataSource expected = (DataSource)dataSources.iterator().next();
        Assertions.assertTrue((boolean)dataSources.contains(DataSource1));
        Assertions.assertTrue((boolean)dataSources.contains(DataSource2));
        Assertions.assertTrue((boolean)dataSources.contains(DataSource3));
        Assertions.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testIsMappingSupported() throws IDMapperException {
        this.report("isMappingSupported");
        Assertions.assertTrue((boolean)capabilities.isMappingSupported(DataSource1, DataSource2));
        Assertions.assertFalse((boolean)capabilities.isMappingSupported(DataSource1, DataSourceBad));
    }

    @Test
    public void testGetKeys() throws IDMapperException {
        this.report("GetKeys");
        Assertions.assertNotNull((Object)capabilities.getKeys());
    }

    @Test
    public void testKeysHaveProperties() {
        this.report("KeysHaveProperties");
        for (String key : capabilities.getKeys()) {
            Assertions.assertNotNull((Object)capabilities.getProperty(key));
        }
    }

    @Test
    public void testBadKeyNoProperties() {
        this.report("BadKeyNoProperties");
        Assertions.assertNull((Object)capabilities.getProperty(badKey));
    }
}

