/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IDMapperStackTest {
    public static Map<String, IDMapper> mappers;
    public static final String[] FILENAMES;
    private static IDMapperStack stack;
    private static DataSource dsW;
    private static DataSource dsX;
    private static DataSource dsY;
    private static DataSource dsZ;
    private static DataSource dsA;
    private static DataSource dsE;
    private static DataSource dsB;
    private static DataSource dsC;
    private static DataSource dsD;

    @Test
    protected void setUp() throws ClassNotFoundException, IDMapperException, MalformedURLException {
        Class.forName("org.bridgedb.file.IDMapperText");
        mappers = new HashMap<String, IDMapper>();
        stack = new IDMapperStack();
        stack.setTransitive(true);
        for (String fileName : FILENAMES) {
            String fullName = fileName + ".csv";
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL url = classLoader.getResource(fullName);
            Assertions.assertNotNull((Object)url, (String)("Could not find resource in classpath: " + fullName));
            IDMapper m = BridgeDb.connect((String)("idmapper-text:" + url));
            mappers.put(fileName, m);
            stack.addIDMapper(m);
        }
        dsW = DataSource.register((String)"dsW", (String)"W").asDataSource();
        dsX = DataSource.register((String)"dsX", (String)"X").asDataSource();
        dsY = DataSource.register((String)"dsY", (String)"Y").asDataSource();
        dsZ = DataSource.register((String)"dsZ", (String)"Z").asDataSource();
        dsA = DataSource.register((String)"dsA", (String)"A").asDataSource();
        dsB = DataSource.register((String)"dsB", (String)"B").asDataSource();
        dsC = DataSource.register((String)"dsC", (String)"C").asDataSource();
        dsD = DataSource.register((String)"dsD", (String)"D").asDataSource();
        dsE = DataSource.register((String)"dsE", (String)"E").asDataSource();
    }

    @Test
    public void testMapIDXrefDataSourceArray() throws IDMapperException {
        Xref src = new Xref("e1", dsE);
        Set results = stack.mapID(src, new DataSource[0]);
        System.out.println("src Xref: " + src);
        Assertions.assertEquals((int)4, (int)results.size());
        Assertions.assertTrue((boolean)results.contains(new Xref("a1", dsA)));
        Assertions.assertTrue((boolean)results.contains(new Xref("b1", dsB)));
        Assertions.assertTrue((boolean)results.contains(new Xref("c1", dsC)));
        Assertions.assertTrue((boolean)results.contains(new Xref("d1", dsD)));
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testSimpleMapID() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("x1", dsX);
            Set results = stack.getIDMapperAt(0).mapID(src, new DataSource[]{dsY});
            System.out.println("single IDMapper");
            System.out.println("src Xref: " + src);
            System.out.println("src.dataSource: " + src.getDataSource());
            System.out.println("results.size(): " + results.size());
            for (Xref x : results) {
                System.out.println(x);
            }
        });
    }

    @Test
    public void testMapID_A_to_E() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("a1", dsA);
            Set results = stack.mapID(src, new DataSource[]{dsE});
            System.out.println("results.size(): " + results.size());
            for (Xref x : results) {
                System.out.println(x);
            }
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertTrue((boolean)results.contains(new Xref("e1", dsE)));
        });
    }

    @Test
    public void testMapID_X_W_via_Y() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("x2", dsX);
            Set results = stack.mapID(src, new DataSource[]{dsW});
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
        });
    }

    @Test
    public void testMapID_all() throws IDMapperException {
        Xref src = new Xref("x2", dsX);
        Set results = stack.mapID(src, new DataSource[0]);
        System.out.println("RESULTS");
        for (Xref ref : results) {
            System.out.println(ref);
        }
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertTrue((boolean)results.contains(new Xref("y2", dsY)));
        Assertions.assertTrue((boolean)results.contains(new Xref("z2", dsZ)));
        Assertions.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
    }

    static {
        FILENAMES = new String[]{"AB", "BC", "CD", "DE", "XY", "XZ", "YW", "YZ"};
    }
}

