/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.bridgedb.Xref;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class XrefTest {
    private static DataSource EN;
    private static DataSource UNIPROT;

    @BeforeAll
    public static void registerDataSources() {
        EN = DataSource.register((String)"En", (String)"Ensembl").asDataSource();
        UNIPROT = DataSource.register((String)"S", (String)"Uniprot-TrEMBL").urnBase("urn:miriam:uniprot").asDataSource();
    }

    @Test
    public void testConstructor() {
        Xref xref = new Xref("ENSG000001", EN);
        Assertions.assertNotNull((Object)xref);
        Assertions.assertEquals((Object)"ENSG000001", (Object)xref.getId());
        Assertions.assertNotNull((Object)xref.getDataSource());
        Assertions.assertEquals((Object)"En", (Object)xref.getDataSource().getSystemCode());
    }

    @Test
    public void testEquals_Null() {
        Xref xref = new Xref("ENSG000001", EN);
        Assertions.assertNotEquals(null, (Object)xref);
    }

    @Test
    public void testEquals_NonXref() {
        Xref xref = new Xref("ENSG000001", EN);
        Assertions.assertNotEquals((Object)"ENSG000001", (Object)xref);
    }

    @Test
    public void testEquals_DiffId() {
        Xref xref = new Xref("ENSG000001", EN);
        Xref xref2 = new Xref("ENSG000002", EN);
        Assertions.assertNotEquals((Object)0, (Object)xref.compareTo(xref2));
        Assertions.assertNotEquals((Object)0, (Object)xref.compareTo(xref2));
    }

    @Test
    public void testEquals() {
        Xref xref = new Xref("ENSG000001", EN);
        Xref xref2 = new Xref("ENSG000001", EN);
        Assertions.assertEquals((int)0, (int)xref2.compareTo(xref));
        Assertions.assertEquals((int)0, (int)xref.compareTo(xref2));
        Xref xref3 = new Xref("ENSG000001", EN, true);
        Xref xref4 = new Xref("ENSG000001", EN, false);
        Assertions.assertFalse((boolean)xref3.equals((Object)xref4));
    }

    @Test
    public void testCompareTo() {
        Xref xref1 = new Xref("ENSG000001", EN);
        Xref xref2 = new Xref("ENSG000001", EN);
        Assertions.assertEquals((int)0, (int)xref1.compareTo(xref2));
        Assertions.assertEquals((int)0, (int)xref2.compareTo(xref1));
        Xref xref3 = new Xref("ENSG000001", EN, true);
        Xref xref4 = new Xref("ENSG000001", EN, false);
        Assertions.assertFalse((boolean)xref3.equals((Object)xref4));
        Assertions.assertFalse((boolean)xref4.equals((Object)xref3));
    }

    @Test
    public void testCompareTo_Diff() {
        Xref xref = new Xref("ENSG000001", EN);
        Xref xref2 = new Xref("ENSG000002", EN);
        Assertions.assertNotSame((Object)0, (Object)xref.compareTo(xref2));
        Assertions.assertNotSame((Object)0, (Object)xref2.compareTo(xref));
    }

    @Test
    public void testGetDataSource() {
        Xref xref = new Xref("ENSG000001", EN);
        Assertions.assertEquals((Object)EN, (Object)xref.getDataSource());
    }

    @Test
    public void testGetId() {
        Xref xref = new Xref("P12345", UNIPROT);
        Assertions.assertEquals((Object)"P12345", (Object)xref.getId());
    }

    @Test
    public void testGetCompactidentifier() {
        Xref xref = new Xref("P12345", UNIPROT);
        Assertions.assertEquals((Object)"uniprot:P12345", (Object)xref.getCompactidentifier());
    }

    @Test
    public void testFromCompactidentifier() {
        Xref xref = Xref.fromCompactIdentifier((String)"uniprot:P12345");
        Assertions.assertEquals((Object)UNIPROT, (Object)xref.getDataSource());
        Assertions.assertEquals((Object)"P12345", (Object)xref.getId());
    }
}

