/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSourceUrnBaseTest {
    @Test
    public void testRegisterUrnBase() throws IDMapperException {
        String fullName = "DataSourceUrnBase_TestRegisterUrnBase";
        String rootURL = "http://identifiers.org/" + fullName;
        String urnBase = "urn:miriam:" + fullName;
        DataSource source = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).asDataSource();
        String id = "1234";
        String result = source.getMiriamURN(id);
        String expected = urnBase + ":" + id;
        Assert.assertEquals((Object)expected, (Object)result);
        result = source.getIdentifiersOrgUri(id);
        expected = rootURL + "/" + id;
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRegisterUrnShortFirst() throws IDMapperException {
        String shortBase = "shortBase";
        String fullName = "DataSourceUrnBase_testRegisterUrnShortFirst";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source1 = DataSource.register(null, (String)fullName).urnBase(shortBase).asDataSource();
        });
    }

    @Test
    public void testRegisterDifferentUrns() {
        String fullName = "DataSourceUrnBase_testRegisterDifferentUrns";
        String urnBase1 = "urn:miriam:testUrnBase3a";
        String urnBase2 = "urn:miriam:testUrnBase3b";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source1 = DataSource.register(null, (String)fullName).urnBase(urnBase1).asDataSource();
            DataSource source2 = DataSource.register(null, (String)fullName).urnBase(urnBase2).asDataSource();
        });
    }

    @Test
    public void testRegisterSameUrn() {
        String fullName = "DataSourceUrnBase_testRegisterSameUrn";
        String urnBase = "urn:miriam:testRegisterSameUrn";
        DataSource source1 = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).asDataSource();
        String id = "1234";
        String result = source1.getMiriamURN(id);
        String expected = urnBase + ":" + id;
        Assert.assertEquals((Object)expected, (Object)result);
        DataSource source2 = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).asDataSource();
        Assert.assertEquals((Object)source1, (Object)source2);
        result = source2.getMiriamURN(id);
        Assert.assertEquals((Object)expected, (Object)result);
        result = source1.getMiriamURN(id);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetIdentifiersOrgUri() throws IDMapperException {
        String fullName = "DataSourceUrnBase_TestIdentifiersOrgUri";
        String rootURL = "http://identifiers.org/" + fullName;
        String urnBase = "urn:miriam:" + fullName;
        DataSource source = DataSource.register((String)fullName, (String)fullName).identifiersOrgBase(rootURL).asDataSource();
        String id = "1234";
        String result = source.getMiriamURN(id);
        String expected = urnBase + ":" + id;
        Assert.assertEquals((Object)expected, (Object)result);
        result = source.getIdentifiersOrgUri(id);
        expected = rootURL + "/" + id;
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRegisterBoth() throws IDMapperException {
        String fullName = "DataSourceUrnBase_testRegisterBoth()";
        String rootURL = "http://identifiers.org/" + fullName;
        String urnBase = "urn:miriam:" + fullName;
        DataSource source1 = DataSource.register((String)fullName, (String)fullName).identifiersOrgBase(rootURL).asDataSource();
        DataSource source2 = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).asDataSource();
        Assert.assertEquals((Object)source1, (Object)source2);
        String id = "1234";
        String result = source1.getMiriamURN(id);
        String expected = urnBase + ":" + id;
        Assert.assertEquals((Object)expected, (Object)result);
        result = source2.getIdentifiersOrgUri(id);
        expected = rootURL + "/" + id;
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRegisterDifferentUrnBaseToUrn() throws IDMapperException {
        String fullName = "DataSourceUrnBase_testRegisterDifferentUrnBaseToUrn";
        String rootURL = "http://identifiers.org/" + fullName + "A";
        String urnBase = "urn:miriam:" + fullName + "B";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source1 = DataSource.register((String)fullName, (String)fullName).identifiersOrgBase(rootURL).asDataSource();
            DataSource source2 = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).asDataSource();
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testSetDifferentUrnBaseToUrn2() throws IDMapperException {
        String fullName = "DataSourceUrnBase_TestDifferentUrnBaseToUrn2";
        String rootURL = "http://identifiers.org/" + fullName + "A";
        String urnBase = "urn:miriam:" + fullName + "B";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).identifiersOrgBase(rootURL).asDataSource();
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testSetUrnBaseSysCode() throws IDMapperException {
        String sysCode = "DataSourceUrnBase-TestSetUrnBaseNonMiram";
        String fullName = "DataSourceUrnBase_TestSetUrnBaseNonMiram";
        DataSource source = DataSource.register((String)sysCode, (String)fullName).urnBase(sysCode).asDataSource();
    }

    @Test
    public void testSetUrnBaseNonMiram() throws IDMapperException {
        String sysCode = "DataSourceUrnBase-TestSetUrnBaseNonMiram";
        String fullName = "DataSourceUrnBase_TestSetUrnBaseNonMiram";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)sysCode, (String)fullName).urnBase(fullName).asDataSource();
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testIdentifiersOverWriteNonMiriam() throws IDMapperException {
        String fullName = "DataSourceUrnBase_testIdentifiersOverWriteNonMiriam";
        String rootURL = "http://identifiers.org/" + fullName + "A";
        String urnBase = fullName + "B";
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)fullName, (String)fullName).urnBase(urnBase).identifiersOrgBase(rootURL).asDataSource();
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testGetBy() throws IDMapperException {
        String fullName = "DataSourceUrnBase_testRegisterBoth()";
        String rootURL = "http://identifiers.org/" + fullName;
        String urnBase = "urn:miriam:" + fullName;
        DataSource source1 = DataSource.register((String)fullName, (String)fullName).identifiersOrgBase(rootURL).asDataSource();
        DataSource source2 = DataSource.getByMiriamBase((String)urnBase);
        Assert.assertEquals((Object)source1, (Object)source2);
        DataSource source3 = DataSource.getByIdentiferOrgBase((String)urnBase);
        Assert.assertEquals((Object)source1, (Object)source2);
    }
}

