/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DataSourceTest {
    @Test
    public void testAsDataSource() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").asDataSource();
        Assertions.assertNotNull((Object)source);
    }

    @Test
    public void testBuilding() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").asDataSource();
        Assertions.assertEquals((Object)"X", (Object)source.getSystemCode());
        Assertions.assertEquals((Object)"Affymetrix", (Object)source.getFullName());
    }

    @Test
    public void testBuildingMainUrl() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
        Assertions.assertEquals((Object)"http://www.affymetrix.com", (Object)source.getMainUrl());
    }

    @Test
    public void testChangeMainUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
            source = DataSource.register((String)"X", (String)"Affymetrix").mainUrl("http://www.affymetrix.com/A").asDataSource();
        });
    }

    @Test
    public void testBuildingType() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("probe").asDataSource();
        Assertions.assertEquals((Object)"probe", (Object)source.getType());
        Assertions.assertFalse((boolean)source.isMetabolite());
    }

    @Disabled
    @Test
    public void testBuildingType1() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("metabolite").asDataSource();
        Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
        Assertions.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testBuildingPrimary() {
        DataSource source = DataSource.register((String)"X", (String)"Affymetrix").primary(false).asDataSource();
        Assertions.assertFalse((boolean)source.isPrimary());
        source = DataSource.register((String)"X", (String)"Affymetrix").primary(true).asDataSource();
        Assertions.assertTrue((boolean)source.isPrimary());
    }

    @Test
    public void testBuildingMetabolite() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").type("metabolite").asDataSource();
        Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
        Assertions.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testDeprecated() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecated(true).asDataSource();
        Assertions.assertTrue((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecated_False() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecated(true).deprecated(false).asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDefaultNotDeprecated() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecatedBy() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(DataSource.register((String)"En", (String)"Ensembl").asDataSource()).asDataSource();
        Assertions.assertTrue((boolean)source.isDeprecated());
        Assertions.assertNotNull((Object)source.isDeprecatedBy());
        Assertions.assertEquals((Object)"En", (Object)source.isDeprecatedBy().getSystemCode());
    }

    @Test
    public void testDeprecatedByUndoneByDeprecatedFalse() {
        DataSource source = DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(DataSource.register((String)"En", (String)"Ensembl").asDataSource()).deprecated(false).asDataSource();
        Assertions.assertFalse((boolean)source.isDeprecated());
        Assertions.assertNull((Object)source.isDeprecatedBy());
    }

    @Test
    public void testDeprecatedByNullCausesException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource.register((String)"EnAg", (String)"Ensembl Mosquito").deprecatedBy(null).asDataSource();
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testDefaultNoDeprecatedBy() {
        DataSource source = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        Assertions.assertNull((Object)source.isDeprecatedBy());
    }

    @Test
    public void testEquals() {
        DataSource source = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        DataSource source2 = DataSource.register((String)"Cps", (String)"PubChem-substance").asDataSource();
        Assertions.assertEquals((Object)source, (Object)source2);
    }

    @Test
    public void testEqualsToo() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"Cpc", (String)"PubChem-compound").asDataSource();
            DataSource source2 = DataSource.register((String)"Cpc", (String)"PubChem compound").asDataSource();
            Assertions.assertEquals((Object)source, (Object)source2);
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testChangeType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DataSource source = DataSource.register((String)"X", (String)"Affymetrix").type("metabolite").asDataSource();
            Assertions.assertEquals((Object)"metabolite", (Object)source.getType());
            Assertions.assertTrue((boolean)source.isMetabolite());
            source = DataSource.register((String)"X", (String)"Affymetrix").type("probe").asDataSource();
            Assertions.assertEquals((Object)"probe", (Object)source.getType());
            Assertions.assertFalse((boolean)source.isMetabolite());
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void testBuildingAlternative() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").alternative("MetaboLoci Alternative").asDataSource();
        Assertions.assertEquals((Object)"MetaboLoci Alternative", (Object)source.getAlternative());
    }

    @Test
    public void testBuildingDescription() {
        DataSource source = DataSource.register((String)"F", (String)"MetaboLoci").description("MetaboLoci description").asDataSource();
        Assertions.assertEquals((Object)"MetaboLoci description", (Object)source.getDescription());
    }

    @Test
    public void testGetByPrefix() {
        DataSource chebi = DataSource.register((String)"Ce", (String)"ChEBI").compactIdentifierPrefix("chebi").asDataSource();
        Assertions.assertNotNull((Object)chebi);
        DataSource source = DataSource.getByCompactIdentifierPrefix((String)"chebi");
        Assertions.assertNotNull((Object)source);
        Assertions.assertEquals((Object)"ChEBI", (Object)source.getFullName());
        Assertions.assertEquals((Object)"chebi", (Object)source.getCompactIdentifierPrefix());
        Assertions.assertEquals((Object)"chebi", (Object)source.getCompactIdentifierPrefix());
        Assertions.assertEquals((Object)"urn:miriam:chebi:1234", (Object)source.getMiriamURN("1234"));
    }
}

