/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IDMapperStackTest {
    public static Map<String, IDMapper> mappers;
    public static final String[] FILENAMES;
    private static IDMapperStack stack;
    private static IDMapperStack stack2;
    private static IDMapperStack stack3;
    private static IDMapperStack stack4;
    private static IDMapperStack stack5;
    private static DataSource dsW;
    private static DataSource dsX;
    private static DataSource dsY;
    private static DataSource dsZ;
    private static DataSource dsA;
    private static DataSource dsE;
    private static DataSource dsB;
    private static DataSource dsC;
    private static DataSource dsD;
    private static DataSource dsOrphanet;

    @Test
    protected void setUp() throws ClassNotFoundException, IDMapperException, MalformedURLException {
        IDMapper m;
        URL url;
        Class.forName("org.bridgedb.file.IDMapperText");
        mappers = new HashMap<String, IDMapper>();
        stack = new IDMapperStack();
        stack2 = new IDMapperStack();
        stack3 = new IDMapperStack();
        stack4 = new IDMapperStack();
        stack5 = new IDMapperStack();
        stack.setTransitive(true);
        for (String fileName : FILENAMES) {
            String fullName = fileName + ".csv";
            ClassLoader classLoader = this.getClass().getClassLoader();
            url = classLoader.getResource(fullName);
            Assertions.assertNotNull((Object)url, (String)("Could not find resource in classpath: " + fullName));
            m = BridgeDb.connect((String)("idmapper-text:" + url));
            mappers.put(fileName, m);
            stack.addIDMapper(m);
            stack3.addIDMapper(m);
            stack5.addIDMapper(m);
            stack.addIDMapper("idmapper-text:" + url);
            stack3.addIDMapper("idmapper-text:" + url);
            stack5.addIDMapper("idmapper-text:" + url);
        }
        String fileName = "yeast_id_mapping";
        String fullNameYeast = fileName + ".txt";
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL urlYeast = classLoader.getResource(fullNameYeast);
        IDMapper yeastMap = BridgeDb.connect((String)("idmapper-text:" + urlYeast));
        stack.addIDMapper(yeastMap);
        Assertions.assertThrows(IDMapperException.class, () -> stack.addIDMapper("test"));
        Assertions.assertTrue((boolean)stack.getTransitive());
        String fullName = "AB.csv";
        classLoader = this.getClass().getClassLoader();
        url = classLoader.getResource(fullName);
        m = BridgeDb.connect((String)("idmapper-text:" + url));
        stack4.addIDMapper(m);
        stack4.removeIDMapper(m);
        Assertions.assertEquals((int)0, (int)stack4.getSize());
        m = null;
        stack4.addIDMapper(m);
        Assertions.assertEquals((int)0, (int)stack4.getSize());
        dsW = DataSource.register((String)"dsW", (String)"W").asDataSource();
        dsX = DataSource.register((String)"dsX", (String)"X").asDataSource();
        dsY = DataSource.register((String)"dsY", (String)"Y").asDataSource();
        dsZ = DataSource.register((String)"dsZ", (String)"Z").asDataSource();
        dsA = DataSource.register((String)"dsA", (String)"A").asDataSource();
        dsB = DataSource.register((String)"dsB", (String)"B").asDataSource();
        dsC = DataSource.register((String)"dsC", (String)"C").asDataSource();
        dsD = DataSource.register((String)"dsD", (String)"D").asDataSource();
        dsE = DataSource.register((String)"dsE", (String)"E").asDataSource();
        dsOrphanet = DataSource.register((String)"On", (String)"Orphanet").mainUrl("http://www.orpha.net/consor/").identifiersOrgBase("http://identifiers.org/orphanet:$id").asDataSource();
    }

    @Test
    public void testMapIDXrefDataSourceArray() throws IDMapperException {
        Xref src = new Xref("e1", dsE);
        Xref src2 = new Xref("e2", dsE);
        Set results = stack.mapID(src, new DataSource[0]);
        stack5.mapID(src, new DataSource[0]);
        System.out.println("src Xref: " + src);
        Assertions.assertEquals((int)5, (int)results.size());
        Assertions.assertTrue((boolean)results.contains(new Xref("a1", dsA)));
        Assertions.assertTrue((boolean)results.contains(new Xref("b1", dsB)));
        Assertions.assertTrue((boolean)results.contains(new Xref("c1", dsC)));
        Assertions.assertTrue((boolean)results.contains(new Xref("d1", dsD)));
        Assertions.assertTrue((boolean)true);
        Assertions.assertTrue((boolean)stack.isConnected());
        Assertions.assertTrue((boolean)stack5.isConnected());
        Assertions.assertFalse((boolean)stack2.isConnected());
        Assertions.assertTrue((boolean)stack.xrefExists(src));
        Assertions.assertFalse((boolean)stack2.xrefExists(src2));
        stack2.close();
        stack5.close();
        Assertions.assertFalse((stack5.isConnected() && stack2.isConnected() ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleMapID() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("x1", dsX);
            Set results = stack.getIDMapperAt(0).mapID(src, new DataSource[]{dsY});
            System.out.println("single IDMapper");
            System.out.println("src Xref: " + src);
            System.out.println("src.dataSource: " + src.getDataSource());
            System.out.println("results.size(): " + results.size());
            for (Xref x : results) {
                System.out.println(x);
            }
        });
    }

    @Test
    public void testMapID_A_to_E() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("a1", dsA);
            Set results = stack.mapID(src, new DataSource[]{dsE});
            System.out.println("results.size(): " + results.size());
            for (Xref x : results) {
                System.out.println(x);
            }
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertTrue((boolean)results.contains(new Xref("e1", dsE)));
        });
    }

    @Test
    public void testMapID_X_W_via_Y() throws IDMapperException {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Xref src = new Xref("x2", dsX);
            Set results = stack.mapID(src, new DataSource[]{dsW});
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
        });
    }

    @Test
    public void testMapID_all() throws IDMapperException {
        Xref src = new Xref("x2", dsX);
        Xref srcOrphanet = new Xref("85163", dsOrphanet);
        Set results = stack.mapID(src, new DataSource[0]);
        stack.mapID(srcOrphanet, new DataSource[0]);
        stack2.setTransitive(false);
        stack3.setTransitive(false);
        Set results2 = stack2.mapID(src, new DataSource[0]);
        Set results3 = stack3.mapID(srcOrphanet, new DataSource[0]);
        Assertions.assertNotNull((Object)results2);
        Assertions.assertNotNull((Object)results3);
        System.out.println("RESULTS");
        for (Xref ref : results) {
            System.out.println(ref);
        }
        Assertions.assertEquals((int)4, (int)results.size());
        Assertions.assertTrue((boolean)results.contains(new Xref("y2", dsY)));
        Assertions.assertTrue((boolean)results.contains(new Xref("z2", dsZ)));
        Assertions.assertTrue((boolean)results.contains(new Xref("w2", dsW)));
        Assertions.assertNotNull((Object)stack.getCapabilities());
        Map resultsTransitive = stack.mapID((Collection)results, new DataSource[0]);
        Map resultsNonTransitive = stack2.mapID((Collection)results2, new DataSource[0]);
        Map resultsNonTransitive2 = stack3.mapID((Collection)results3, new DataSource[0]);
        for (Map.Entry entry : resultsTransitive.entrySet()) {
            System.out.println("mapping");
            System.out.println(entry.getKey() + ":" + entry.getValue());
        }
        Assertions.assertNotNull((Object)resultsTransitive);
        Assertions.assertNotNull((Object)resultsNonTransitive);
        Assertions.assertNotNull((Object)resultsNonTransitive2);
        Set getAttributesResults = new HashSet();
        getAttributesResults = stack.getAttributes(srcOrphanet, "Description");
        Assertions.assertTrue((getAttributesResults.isEmpty() && stack.getAttributeSet().isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((stack3.getAttributes(srcOrphanet).isEmpty() && stack3.getAttributesForAllMappings(srcOrphanet, new DataSource[]{dsOrphanet}).isEmpty() ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)stack.isFreeAttributeSearchSupported());
    }

    static {
        FILENAMES = new String[]{"AB", "BC", "CD", "DE", "XY", "XZ", "YW", "YZ"};
    }
}

