/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.order;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.grid.events.SelectionChangedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionEvent;
import java.util.HashMap;
import org.broadleafcommerce.admin.client.datasource.order.BundledOrderItemListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.CountryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.DiscreteOrderItemFeePriceDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.FulfillmentGroupAdjustmentListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.FulfillmentGroupListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.OfferCodeListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.OrderAdjustmentListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.OrderItemAdjustmentListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.OrderItemListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.OrderListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.PaymentAdditionalAttributesDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.PaymentInfoListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.StateListDataSourceFactory;
import org.broadleafcommerce.admin.client.presenter.order.OrderItemPresenter;
import org.broadleafcommerce.admin.client.view.order.OrderDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.AbstractDynamicDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicEntityPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresentable;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.CreateBasedListStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.SimpleMapStructurePresenter;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.NullAsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.EntitySearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.DynamicFormDisplay;
import org.broadleafcommerce.openadmin.client.view.dynamic.grid.GridStructureDisplay;

public class OrderPresenter
extends DynamicEntityPresenter
implements Instantiable {
    protected OrderItemPresenter orderItemPresenter;
    protected SubPresentable fulfillmentGroupPresenter;
    protected SubPresentable paymentInfoPresenter;
    protected SubPresentable additionalPaymentAttributesPresenter;
    protected SubPresentable offerCodePresenter;
    protected SubPresentable orderAdjustmentPresenter;
    protected SubPresentable orderItemAdjustmentPresenter;
    protected SubPresentable fulfillmentGroupAdjustmentPresenter;
    protected SubPresentable feesPresenter;
    protected HashMap<String, Object> library = new HashMap(10);

    protected void changeSelection(Record selectedRecord) {
        this.orderItemPresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("orderDS"), null);
        this.fulfillmentGroupPresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("orderDS"), null);
        this.paymentInfoPresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("orderDS"), null);
        this.offerCodePresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("orderDS"), null);
        this.orderAdjustmentPresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("orderDS"), null);
    }

    public void bind() {
        super.bind();
        this.orderItemPresenter.bind();
        this.fulfillmentGroupPresenter.bind();
        this.paymentInfoPresenter.bind();
        this.additionalPaymentAttributesPresenter.bind();
        this.offerCodePresenter.bind();
        this.orderAdjustmentPresenter.bind();
        this.orderItemAdjustmentPresenter.bind();
        this.fulfillmentGroupAdjustmentPresenter.bind();
        this.feesPresenter.bind();
        this.selectionChangedHandlerRegistration.removeHandler();
        this.display.getListDisplay().getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                ListGridRecord selectedRecord = event.getSelectedRecord();
                if (event.getState() && !selectedRecord.equals(OrderPresenter.this.lastSelectedRecord)) {
                    OrderPresenter.this.lastSelectedRecord = selectedRecord;
                    if (selectedRecord.getAttributeAsStringArray("_type") == null) {
                        OrderPresenter.this.formPresenter.disable();
                        OrderPresenter.this.display.getListDisplay().getRemoveButton().disable();
                    } else {
                        OrderPresenter.this.formPresenter.setStartState();
                        OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("orderDS").resetPermanentFieldVisibilityBasedOnType(selectedRecord.getAttributeAsStringArray("_type"));
                        OrderPresenter.this.display.getDynamicFormDisplay().getFormOnlyDisplay().buildFields(OrderPresenter.this.display.getListDisplay().getGrid().getDataSource(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
                        OrderPresenter.this.display.getDynamicFormDisplay().getFormOnlyDisplay().getForm().editRecord((Record)selectedRecord);
                        OrderPresenter.this.display.getListDisplay().getRemoveButton().enable();
                    }
                    OrderPresenter.this.changeSelection((Record)selectedRecord);
                }
            }
        });
        this.getDisplay().getPaymentInfoDisplay().getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                ListGridRecord selectedRecord = event.getSelectedRecord();
                if (event.getState()) {
                    OrderPresenter.this.additionalPaymentAttributesPresenter.load((Record)selectedRecord, (AbstractDynamicDataSource)OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("paymentInfoDS"), null);
                }
            }
        });
        this.getDisplay().getOrderItemsDisplay().getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                ListGridRecord selectedRecord = event.getSelectedRecord();
                if (event.getState()) {
                    OrderPresenter.this.orderItemAdjustmentPresenter.load((Record)selectedRecord, (AbstractDynamicDataSource)OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("orderItemDS"), null);
                    OrderPresenter.this.feesPresenter.load((Record)selectedRecord, (AbstractDynamicDataSource)OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("discreteOrderItemFeePriceDS"), null);
                }
            }
        });
        this.getDisplay().getFulfillmentGroupDisplay().getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                ListGridRecord selectedRecord = event.getSelectedRecord();
                if (event.getState()) {
                    OrderPresenter.this.fulfillmentGroupAdjustmentPresenter.load((Record)selectedRecord, (AbstractDynamicDataSource)OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("fulfillmentGroupDS"), null);
                }
            }
        });
        this.setReadOnly(true);
    }

    public OrderDisplay getDisplay() {
        return (OrderDisplay)this.display;
    }

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("orderDS", (DataSourceFactory)new OrderListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource top) {
                OrderPresenter.this.setupDisplayItems(top, new DataSource[0]);
                ((ListGridDataSource)top).setupGridFields(new String[]{"customer.firstName", "customer.lastName", "name", "orderNumber", "status"});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("orderItemDS", (DataSourceFactory)new OrderItemListDataSourceFactory(), (AsyncCallbackAdapter)new NullAsyncCallbackAdapter()));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("bundleOrderItemDS", (DataSourceFactory)new BundledOrderItemListDataSourceFactory(), null, new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.orderItemPresenter = new OrderItemPresenter(OrderPresenter.this.getDisplay().getOrderItemsDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderImpl"});
                OrderPresenter.this.orderItemPresenter.setDataSource((ListGridDataSource)OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("orderItemDS"), new String[]{"name", "quantity", "price", "retailPrice", "salePrice"}, new Boolean[]{false, false, false, false, false});
                OrderPresenter.this.orderItemPresenter.setExpansionDataSource((ListGridDataSource)result, new String[]{"name", "quantity", "price", "retailPrice", "salePrice"}, new Boolean[]{false, false, false, false, false});
                OrderPresenter.this.orderItemPresenter.setReadOnly(true);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("countryDS", (DataSourceFactory)new CountryListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"abbreviation", "name"});
                EntitySearchDialog countrySearchView = new EntitySearchDialog((ListGridDataSource)result);
                OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("orderDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.country", countrySearchView, BLCMain.getMessageManager().getString("countrySearchPrompt"), (DynamicFormDisplay)OrderPresenter.this.getDisplay().getFulfillmentGroupDisplay());
                OrderPresenter.this.library.put("countrySearchView", countrySearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("stateDS", (DataSourceFactory)new StateListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"abbreviation", "name"});
                EntitySearchDialog stateSearchView = new EntitySearchDialog((ListGridDataSource)result);
                OrderPresenter.this.getPresenterSequenceSetupManager().getDataSource("orderDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.state", stateSearchView, BLCMain.getMessageManager().getString("stateSearchPrompt"), (DynamicFormDisplay)OrderPresenter.this.getDisplay().getFulfillmentGroupDisplay());
                OrderPresenter.this.library.put("stateSearchView", stateSearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("fulfillmentGroupDS", (DataSourceFactory)new FulfillmentGroupListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.fulfillmentGroupPresenter = new SubPresenter(OrderPresenter.this.getDisplay().getFulfillmentGroupDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderImpl"});
                OrderPresenter.this.fulfillmentGroupPresenter.setDataSource((ListGridDataSource)result, new String[]{"referenceNumber", "method", "service", "shippingPrice", "status", "address.postalCode"}, new Boolean[]{false, false, false, false, false, false});
                OrderPresenter.this.fulfillmentGroupPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("paymentInfoDS", (DataSourceFactory)new PaymentInfoListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.paymentInfoPresenter = new SubPresenter(OrderPresenter.this.getDisplay().getPaymentInfoDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderImpl"});
                OrderPresenter.this.paymentInfoPresenter.setDataSource((ListGridDataSource)result, new String[]{"referenceNumber", "type", "amount"}, new Boolean[]{false, false, false});
                OrderPresenter.this.paymentInfoPresenter.setReadOnly(Boolean.valueOf(true));
                ((DynamicEntityDataSource)result).getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.country", (EntitySearchDialog)OrderPresenter.this.library.get("countrySearchView"), BLCMain.getMessageManager().getString("countrySearchPrompt"), (DynamicFormDisplay)OrderPresenter.this.getDisplay().getFulfillmentGroupDisplay());
                ((DynamicEntityDataSource)result).getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.state", (EntitySearchDialog)OrderPresenter.this.library.get("stateSearchView"), BLCMain.getMessageManager().getString("stateSearchPrompt"), (DynamicFormDisplay)OrderPresenter.this.getDisplay().getFulfillmentGroupDisplay());
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("paymentAdditionalAttributesDS", (DataSourceFactory)new PaymentAdditionalAttributesDataSourceFactory(this), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                HashMap<String, String> initialValues = new HashMap<String, String>(2);
                initialValues.put("key", BLCMain.getMessageManager().getString("paymentAttributeKeyDefault"));
                initialValues.put("value", BLCMain.getMessageManager().getString("paymentAttributeValueDefault"));
                OrderPresenter.this.additionalPaymentAttributesPresenter = new SimpleMapStructurePresenter(OrderPresenter.this.getDisplay().getAdditionalAttributesDisplay(), new String[]{"org.broadleafcommerce.core.payment.domain.PaymentInfoImpl"}, initialValues);
                OrderPresenter.this.additionalPaymentAttributesPresenter.setDataSource((ListGridDataSource)result, new String[]{"key", "value"}, new Boolean[]{true, true});
                OrderPresenter.this.additionalPaymentAttributesPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("offerCodeDS", (DataSourceFactory)new OfferCodeListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.offerCodePresenter = new SubPresenter(OrderPresenter.this.getDisplay().getOfferCodeDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderImpl"});
                OrderPresenter.this.offerCodePresenter.setDataSource((ListGridDataSource)result, new String[]{"offerCode", "startDate", "endDate", "offer.name", "offer.type", "offer.value"}, new Boolean[]{false, false, false, false, false, false});
                OrderPresenter.this.offerCodePresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("orderAdjustmentDS", (DataSourceFactory)new OrderAdjustmentListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.orderAdjustmentPresenter = new CreateBasedListStructurePresenter(OrderPresenter.this.getDisplay().getOrderAdjustmentDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderImpl"}, BLCMain.getMessageManager().getString("newOrderAdjustmentTitle"));
                OrderPresenter.this.orderAdjustmentPresenter.setDataSource((ListGridDataSource)result, new String[]{"reason", "value", "offer.name", "offer.type"}, new Boolean[]{false, false, false, false});
                OrderPresenter.this.orderAdjustmentPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("orderItemAdjustmentDS", (DataSourceFactory)new OrderItemAdjustmentListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.orderItemAdjustmentPresenter = new CreateBasedListStructurePresenter(OrderPresenter.this.getDisplay().getOrderItemAdjustmentDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderItemImpl"}, BLCMain.getMessageManager().getString("newOrderItemAdjustmentTitle"));
                OrderPresenter.this.orderItemAdjustmentPresenter.setDataSource((ListGridDataSource)result, new String[]{"reason", "value", "offer.type"}, new Boolean[]{false, false, false});
                OrderPresenter.this.orderItemAdjustmentPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("fulfillmentGroupAdjustmentDS", (DataSourceFactory)new FulfillmentGroupAdjustmentListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.fulfillmentGroupAdjustmentPresenter = new CreateBasedListStructurePresenter(OrderPresenter.this.getDisplay().getFulfillmentGroupAdjustmentDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl"}, BLCMain.getMessageManager().getString("newFGAdjustmentTitle"));
                OrderPresenter.this.fulfillmentGroupAdjustmentPresenter.setDataSource((ListGridDataSource)result, new String[]{"reason", "value", "offer.type"}, new Boolean[]{false, false, false});
                OrderPresenter.this.fulfillmentGroupAdjustmentPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("discreteOrderItemFeePriceDS", (DataSourceFactory)new DiscreteOrderItemFeePriceDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OrderPresenter.this.feesPresenter = new CreateBasedListStructurePresenter((GridStructureDisplay)OrderPresenter.this.getDisplay().getOrderItemFeeDisplay(), new String[]{"org.broadleafcommerce.core.order.domain.OrderItemImpl"}, BLCMain.getMessageManager().getString("newOrderItemFeeTitle"));
                OrderPresenter.this.feesPresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "amount", "reportingCode"}, new Boolean[]{false, false, false});
                OrderPresenter.this.feesPresenter.setReadOnly(Boolean.valueOf(true));
            }
        }));
    }
}

