/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.server.service.handler;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;

public class ProductCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(ProductCustomPersistenceHandler.class);

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        Object[] customCriteria = persistencePackage.getCustomCriteria();
        return !ArrayUtils.isEmpty((Object[])customCriteria) && "productDirectEdit".equals(customCriteria[0]) && Product.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleAdd(persistencePackage);
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Product adminInstance = (Product)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(Product.class.getName(), persistencePerspective);
            adminInstance = (Product)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            if (adminInstance.getDefaultCategory() != null && !adminInstance.getAllParentCategories().contains(adminInstance.getDefaultCategory())) {
                adminInstance.getAllParentCategories().add(adminInstance.getDefaultCategory());
            }
            adminInstance = (Product)dynamicEntityDao.merge((Serializable)adminInstance);
            return helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(Product.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            Product adminInstance = (Product)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            adminInstance = (Product)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            if (adminInstance.getDefaultCategory() != null && !adminInstance.getAllParentCategories().contains(adminInstance.getDefaultCategory())) {
                adminInstance.getAllParentCategories().add(adminInstance.getDefaultCategory());
            }
            adminInstance = (Product)dynamicEntityDao.merge((Serializable)adminInstance);
            return helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to update entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to update entity for " + entity.getType()[0], (Throwable)e);
        }
    }
}

