/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.promotion;

import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.admin.client.presenter.promotion.FilterType;
import org.broadleafcommerce.admin.client.presenter.promotion.OfferPresenter;
import org.broadleafcommerce.admin.client.view.promotion.OfferDisplay;
import org.broadleafcommerce.openadmin.client.translation.AdvancedCriteriaToMVELTranslator;
import org.broadleafcommerce.openadmin.client.translation.IncompatibleMVELTranslationException;
import org.broadleafcommerce.openadmin.client.view.dynamic.ItemBuilderDisplay;

public class OfferPresenterExtractor {
    private static Map<FilterType, String> MVELKEYWORDMAP = new HashMap<FilterType, String>();
    private static final AdvancedCriteriaToMVELTranslator TRANSLATOR;
    protected OfferPresenter presenter;

    public OfferPresenterExtractor(OfferPresenter presenter) {
        this.presenter = presenter;
    }

    protected OfferDisplay getDisplay() {
        return this.presenter.getDisplay();
    }

    public void removeItemQualifer(final ItemBuilderDisplay builder) {
        if (builder.getRecord() != null) {
            this.presenter.getPresenterSequenceSetupManager().getDataSource("offerItemCriteriaDS").removeData(builder.getRecord(), new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    OfferPresenterExtractor.this.getDisplay().removeItemBuilder(builder);
                }
            });
        } else {
            this.getDisplay().removeItemBuilder(builder);
        }
    }

    protected void setData(Record record, String fieldName, Object value, Map<String, Object> dirtyValues) {
        String val;
        String attr = record.getAttribute(fieldName);
        String string = val = value == null ? null : String.valueOf(value);
        if (!(attr == val || attr != null && val != null && attr.equals(val))) {
            record.setAttribute(fieldName, value);
            dirtyValues.put(fieldName, value);
        }
    }

    public void applyData(final Record selectedRecord) {
        try {
            final HashMap<String, Object> dirtyValues = new HashMap<String, Object>();
            this.setData(selectedRecord, "totalitarianOffer", this.getDisplay().getRestrictRuleRadio().getValue().equals("YES"), dirtyValues);
            this.setData(selectedRecord, "deliveryType", this.getDisplay().getDeliveryTypeRadio().getValue(), dirtyValues);
            if (this.getDisplay().getDeliveryTypeRadio().getValue().equals("CODE")) {
                this.setData(selectedRecord, "offerCode.offerCode", this.getDisplay().getCodeField().getValue().toString().trim(), dirtyValues);
            }
            final String type = this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("type").getValue().toString();
            this.extractCustomerData(selectedRecord, dirtyValues);
            this.extractOrderData(selectedRecord, type, dirtyValues);
            this.extractQualifierRuleType(selectedRecord, dirtyValues);
            this.extractTargetItemData(selectedRecord, type, dirtyValues);
            this.extractTargetRuleType(selectedRecord, dirtyValues);
            this.extractFulfillmentGroupData(selectedRecord, type, dirtyValues);
            for (FormItem formItem : this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getFields()) {
                this.setData(selectedRecord, formItem.getName(), formItem.getValue(), dirtyValues);
            }
            this.extractQualifierData(selectedRecord, type, true, dirtyValues);
            DSRequest requestProperties = new DSRequest();
            requestProperties.setAttribute("dirtyValues", dirtyValues);
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getDataSource().updateData(selectedRecord, new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    try {
                        OfferPresenterExtractor.this.extractQualifierData(selectedRecord, type, false, dirtyValues);
                        OfferPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getSaveButton().disable();
                        OfferPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getRefreshButton().disable();
                    }
                    catch (IncompatibleMVELTranslationException e) {
                        SC.warn((String)e.getMessage());
                    }
                }
            }, requestProperties);
        }
        catch (IncompatibleMVELTranslationException e) {
            SC.warn((String)e.getMessage());
        }
    }

    protected void extractQualifierData(final Record selectedRecord, String type, boolean isValidation, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        if (this.getDisplay().getBogoRadio().getValue().equals("YES") && type.equals("ORDER_ITEM") || this.getDisplay().getItemRuleRadio().getValue().equals("ITEM_RULE") && !type.equals("ORDER_ITEM")) {
            for (final ItemBuilderDisplay builder : this.getDisplay().getItemBuilderViews()) {
                if (!builder.getDirty().booleanValue()) continue;
                String temper = builder.getItemQuantity().getValue().toString();
                Integer quantity = Integer.parseInt(temper);
                String mvel = builder.getIncompatibleMVEL() != false ? builder.getRawItemTextArea().getValueAsString() : TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.ORDER_ITEM), builder.getItemFilterBuilder().getCriteria(), builder.getItemFilterBuilder().getDataSource());
                if (isValidation) continue;
                if (builder.getRecord() != null) {
                    this.setData(builder.getRecord(), "quantity", quantity, dirtyValues);
                    this.setData(builder.getRecord(), "orderItemMatchRule", mvel, dirtyValues);
                    this.presenter.getPresenterSequenceSetupManager().getDataSource("offerItemCriteriaDS").updateData(builder.getRecord(), new DSCallback(){

                        public void execute(DSResponse response, Object rawData, DSRequest request) {
                            builder.setDirty(Boolean.valueOf(false));
                            OfferPresenterExtractor.this.getDisplay().getListDisplay().getGrid().selectRecord(OfferPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getRecordIndex(selectedRecord));
                        }
                    });
                    continue;
                }
                final Record temp = new Record();
                temp.setAttribute("quantity", quantity);
                temp.setAttribute("orderItemMatchRule", mvel);
                temp.setAttribute("_type", new String[]{this.presenter.getPresenterSequenceSetupManager().getDataSource("offerItemCriteriaDS").getDefaultNewEntityFullyQualifiedClassname()});
                temp.setAttribute("offer", this.presenter.getPresenterSequenceSetupManager().getDataSource("offerDS").getPrimaryKeyValue(selectedRecord));
                temp.setAttribute("id", "");
                this.presenter.getPresenterSequenceSetupManager().getDataSource("offerItemCriteriaDS").addData(temp, new DSCallback(){

                    public void execute(DSResponse response, Object rawData, DSRequest request) {
                        builder.setDirty(Boolean.valueOf(false));
                        builder.setRecord(temp);
                        OfferPresenterExtractor.this.getDisplay().getListDisplay().getGrid().selectRecord(OfferPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getRecordIndex(selectedRecord));
                    }
                });
            }
        } else if (!isValidation) {
            ItemBuilderDisplay[] displays = new ItemBuilderDisplay[]{};
            for (ItemBuilderDisplay builder : displays = this.getDisplay().getItemBuilderViews().toArray(displays)) {
                this.removeItemQualifer(builder);
            }
            this.getDisplay().getListDisplay().getGrid().selectRecord(this.getDisplay().getListDisplay().getGrid().getRecordIndex(selectedRecord));
        }
        if (type.equals("ORDER_ITEM")) {
            this.setData(selectedRecord, "combinableWithOtherOffers", this.getDisplay().getOrderItemCombineRuleRadio().getValue().equals("YES"), dirtyValues);
        }
    }

    protected void extractFulfillmentGroupData(Record selectedRecord, String type, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        if (type.equals("FULFILLMENT_GROUP")) {
            if (this.getDisplay().getFgRuleRadio().getValue().equals("FG_RULE")) {
                if (!this.presenter.initializer.fgRuleIncompatible) {
                    this.setData(selectedRecord, "appliesToFulfillmentGroupRules", TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.FULFILLMENT_GROUP), this.getDisplay().getFulfillmentGroupFilterBuilder().getCriteria(), this.getDisplay().getFulfillmentGroupFilterBuilder().getDataSource()), dirtyValues);
                } else {
                    this.setData(selectedRecord, "appliesToFulfillmentGroupRules", this.getDisplay().getRawFGTextArea().getValue(), dirtyValues);
                }
            } else {
                Object value = null;
                this.setData(selectedRecord, "appliesToFulfillmentGroupRules", value, dirtyValues);
                this.getDisplay().getFulfillmentGroupFilterBuilder().clearCriteria();
                this.getDisplay().getRawFGTextArea().setValue("");
            }
            this.setData(selectedRecord, "combinableWithOtherOffers", this.getDisplay().getFgCombineRuleRadio().getValue().equals("YES"), dirtyValues);
        } else {
            Object value = null;
            this.setData(selectedRecord, "appliesToFulfillmentGroupRules", value, dirtyValues);
            this.getDisplay().getFulfillmentGroupFilterBuilder().clearCriteria();
            this.getDisplay().getRawFGTextArea().setValue("");
        }
    }

    protected void extractTargetRuleType(Record selectedRecord, Map<String, Object> dirtyValues) {
        String offerItemTargetRuleType = this.getDisplay().getQualifyForAnotherPromoTargetRadio().getValue().equals("YES") && this.getDisplay().getReceiveFromAnotherPromoTargetRadio().getValue().equals("NO") ? "QUALIFIER" : (this.getDisplay().getQualifyForAnotherPromoTargetRadio().getValue().equals("NO") && this.getDisplay().getReceiveFromAnotherPromoTargetRadio().getValue().equals("YES") ? "TARGET" : (this.getDisplay().getQualifyForAnotherPromoTargetRadio().getValue().equals("YES") && this.getDisplay().getReceiveFromAnotherPromoTargetRadio().getValue().equals("YES") ? "QUALIFIER_TARGET" : "NONE"));
        this.setData(selectedRecord, "offerItemTargetRuleType", offerItemTargetRuleType, dirtyValues);
    }

    protected void extractTargetItemData(Record selectedRecord, String type, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        if (type.equals("ORDER_ITEM")) {
            String temp = this.getDisplay().getTargetItemBuilder().getItemQuantity().getValue().toString();
            Integer quantity = Integer.parseInt(temp);
            String mvel = this.getDisplay().getTargetItemBuilder().getIncompatibleMVEL() != false ? this.getDisplay().getTargetItemBuilder().getRawItemTextArea().getValueAsString() : TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.ORDER_ITEM), this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().getCriteria(), this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().getDataSource());
            this.setData(selectedRecord, "targetItemCriteria.quantity", quantity, dirtyValues);
            this.setData(selectedRecord, "targetItemCriteria.orderItemMatchRule", mvel, dirtyValues);
        } else {
            this.setData(selectedRecord, "targetItemCriteria.quantity", 0, dirtyValues);
            Object attr = null;
            this.setData(selectedRecord, "targetItemCriteria.orderItemMatchRule", attr, dirtyValues);
        }
    }

    protected void extractQualifierRuleType(Record selectedRecord, Map<String, Object> dirtyValues) {
        String offerItemQualifierRuleType = this.getDisplay().getQualifyForAnotherPromoRadio().getValue().equals("YES") && this.getDisplay().getReceiveFromAnotherPromoRadio().getValue().equals("NO") ? "QUALIFIER" : (this.getDisplay().getQualifyForAnotherPromoRadio().getValue().equals("NO") && this.getDisplay().getReceiveFromAnotherPromoRadio().getValue().equals("YES") ? "TARGET" : (this.getDisplay().getQualifyForAnotherPromoRadio().getValue().equals("YES") && this.getDisplay().getReceiveFromAnotherPromoRadio().getValue().equals("YES") ? "QUALIFIER_TARGET" : "NONE"));
        this.setData(selectedRecord, "offerItemQualifierRuleType", offerItemQualifierRuleType, dirtyValues);
    }

    protected void extractOrderData(Record selectedRecord, String type, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        if (this.getDisplay().getOrderRuleRadio().getValue().equals("ORDER_RULE")) {
            if (!this.presenter.initializer.orderRuleIncompatible) {
                this.setData(selectedRecord, "appliesToOrderRules", TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.ORDER), this.getDisplay().getOrderFilterBuilder().getCriteria(), this.getDisplay().getOrderFilterBuilder().getDataSource()), dirtyValues);
            } else {
                this.setData(selectedRecord, "appliesToOrderRules", this.getDisplay().getRawOrderTextArea().getValue(), dirtyValues);
            }
        } else {
            Object value = null;
            this.setData(selectedRecord, "appliesToOrderRules", value, dirtyValues);
            this.getDisplay().getOrderFilterBuilder().clearCriteria();
            this.getDisplay().getRawOrderTextArea().setValue("");
        }
        if (type.equals("ORDER")) {
            this.setData(selectedRecord, "combinableWithOtherOffers", this.getDisplay().getOrderCombineRuleRadio().getValue().equals("YES"), dirtyValues);
        }
    }

    protected void extractCustomerData(Record selectedRecord, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        if (this.getDisplay().getCustomerRuleRadio().getValue().equals("CUSTOMER_RULE")) {
            if (!this.presenter.initializer.customerRuleIncompatible) {
                this.setData(selectedRecord, "appliesToCustomerRules", TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.CUSTOMER), this.getDisplay().getCustomerFilterBuilder().getCriteria(), this.getDisplay().getCustomerFilterBuilder().getDataSource()), dirtyValues);
            } else {
                this.setData(selectedRecord, "appliesToCustomerRules", this.getDisplay().getRawCustomerTextArea().getValue(), dirtyValues);
            }
        } else {
            Object value = null;
            this.setData(selectedRecord, "appliesToCustomerRules", value, dirtyValues);
            this.getDisplay().getCustomerFilterBuilder().clearCriteria();
            this.getDisplay().getRawCustomerTextArea().setValue("");
        }
    }

    static {
        MVELKEYWORDMAP.put(FilterType.ORDER, "order");
        MVELKEYWORDMAP.put(FilterType.ORDER_ITEM, "discreteOrderItem");
        MVELKEYWORDMAP.put(FilterType.FULFILLMENT_GROUP, "fulfillmentGroup");
        MVELKEYWORDMAP.put(FilterType.CUSTOMER, "customer");
        TRANSLATOR = new AdvancedCriteriaToMVELTranslator();
    }
}

