/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.datasource.catalog.category;

import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.TreeNode;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.TreeGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.module.DataSourceModule;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.operation.EntityOperationType;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.operation.EntityServiceAsyncCallback;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.DynamicEntityServiceAsync;

public class CategoryTreeDataSource
extends TreeGridDataSource {
    public CategoryTreeDataSource(String name, PersistencePerspective persistencePerspective, DynamicEntityServiceAsync service, DataSourceModule[] modules, String rootId, String rootName) {
        super(name, persistencePerspective, service, modules, rootId, rootName);
    }

    protected void executeFetch(String requestId, DSRequest request, DSResponse response) {
        TreeNode parentNode;
        CriteriaTransferObject criteriaTransferObject = this.getCompatibleModule(OperationType.ENTITY).getCto(request);
        String[] filterValues = criteriaTransferObject.get("allParentCategories").getFilterValues();
        String parentCategoryId = filterValues.length > 0 ? filterValues[0] : null;
        boolean hasChildren = true;
        if (parentCategoryId != null && (parentNode = ((TreeGrid)this.associatedGrid).getTree().findById(parentCategoryId)) != null) {
            hasChildren = Boolean.parseBoolean(parentNode.getAttribute("hasAllChildCategories"));
        }
        if (hasChildren && parentCategoryId != null) {
            super.executeFetch(requestId, request, response);
        } else if (parentCategoryId == null) {
            TreeNode node = new TreeNode();
            node.setAttribute(this.getPrimaryKeyFieldName(), this.getRootId());
            node.setAttribute("name", this.getRootName());
            node.setAttribute("hasAllChildCategories", String.valueOf(hasChildren));
            node.setAttribute("_type", new String[]{"org.broadleafcommerce.core.catalog.domain.CategoryImpl"});
            TreeNode[] recordList = new TreeNode[]{node};
            response.setData((Record[])recordList);
            response.setTotalRows(Integer.valueOf(0));
            this.processResponse(requestId, response);
        } else {
            TreeNode[] recordList = new TreeNode[]{};
            response.setData((Record[])recordList);
            response.setTotalRows(Integer.valueOf(0));
            this.processResponse(requestId, response);
        }
    }

    protected void executeAdd(final String requestId, DSRequest request, final DSResponse response) {
        BLCMain.NON_MODAL_PROGRESS.startProgress();
        this.setLinkedValue(this.getPrimaryKeyValue((Record)((ListGrid)this.getAssociatedGrid()).getSelectedRecord()));
        JavaScriptObject data = request.getData();
        TreeNode newRecord = new TreeNode(data);
        final DataSourceModule entityModule = this.getCompatibleModule(OperationType.ENTITY);
        Entity entity = entityModule.buildEntity((Record)newRecord, request);
        this.service.add(new PersistencePackage(entityModule.getCeilingEntityFullyQualifiedClassname(), entity, this.persistencePerspective, new String[]{"addNewCategory"}, BLCMain.csrfToken), (AsyncCallback)new EntityServiceAsyncCallback<Entity>(EntityOperationType.ADD, requestId, request, response, (DataSource)this){

            public void onSuccess(Entity result) {
                super.onSuccess((Object)result);
                TreeNode record = (TreeNode)entityModule.buildRecord(result, Boolean.valueOf(true));
                TreeNode[] recordList = new TreeNode[]{record};
                response.setData((Record[])recordList);
                CategoryTreeDataSource.this.processResponse(requestId, response);
            }
        });
    }
}

