/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.catalog.category;

import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.RecordList;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.DataBoundComponent;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.grid.events.SelectionChangedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionEvent;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.TreeNode;
import com.smartgwt.client.widgets.tree.events.DataArrivedEvent;
import com.smartgwt.client.widgets.tree.events.DataArrivedHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.broadleafcommerce.admin.client.datasource.catalog.StaticAssetsTileGridDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.AllProductsDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.CategoryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.CategorySearchDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.CategoryTreeDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.FeaturedProductListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.MediaMapDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.OrphanedCategoryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.ProductListDataSourceFactory;
import org.broadleafcommerce.admin.client.presenter.catalog.category.AllChildCategoriesPresenter;
import org.broadleafcommerce.admin.client.view.catalog.category.CategoryDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.callback.ItemEdited;
import org.broadleafcommerce.openadmin.client.callback.ItemEditedHandler;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelected;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelectedHandler;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.AbstractDynamicDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.TileGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.TreeGridDataSource;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicEntityPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.FormItemCallback;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresentable;
import org.broadleafcommerce.openadmin.client.presenter.structure.EditableJoinStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.MapStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.SimpleSearchJoinStructurePresenter;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.AssetSearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.EntitySearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.MapStructureEntityEditDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.grid.GridStructureDisplay;

public class CategoryPresenter
extends DynamicEntityPresenter
implements Instantiable {
    protected MapStructureEntityEditDialog mapEntityAdd;
    protected String rootId = "1";
    protected String rootName = "Store";
    protected SubPresentable featuredPresenter;
    protected SubPresentable mediaPresenter;
    protected AllChildCategoriesPresenter allChildCategoriesPresenter;
    protected SubPresentable childProductsPresenter;
    protected HashMap<String, Object> library = new HashMap(10);

    protected void addClicked() {
        this.initialValues = new HashMap(10);
        this.initialValues.put("defaultParentCategory", this.getPresenterSequenceSetupManager().getDataSource("categoryTreeDS").getPrimaryKeyValue((Record)this.display.getListDisplay().getGrid().getSelectedRecord()));
        this.initialValues.put("name", BLCMain.getMessageManager().getString("defaultCategoryName"));
        super.addClicked(BLCMain.getMessageManager().getString("newCategoryTitle"));
    }

    protected void addNewItem(String newItemTitle) {
        this.initialValues.put("_type", new String[]{((DynamicEntityDataSource)this.display.getListDisplay().getGrid().getDataSource()).getDefaultNewEntityFullyQualifiedClassname()});
        this.compileDefaultValuesFromCurrentFilter(this.initialValues);
        BLCMain.ENTITY_ADD.editNewRecord(newItemTitle, this.getPresenterSequenceSetupManager().getDataSource("categoryTreeDS"), this.initialValues, new ItemEditedHandler(){

            public void onItemEdited(ItemEdited event) {
                CategoryPresenter.this.reloadParentTreeNodeRecords(false);
                CategoryPresenter.this.getDisplay().getAllCategoriesDisplay().getGrid().clearCriteria();
                CategoryPresenter.this.allChildCategoriesPresenter.load((Record)CategoryPresenter.this.display.getListDisplay().getGrid().getSelectedRecord(), (AbstractDynamicDataSource)CategoryPresenter.this.getPresenterSequenceSetupManager().getDataSource("allChildCategoriesDS"), null);
            }
        }, null, null);
    }

    protected void removeClicked() {
        this.display.getListDisplay().getGrid().removeSelectedData(new DSCallback(){

            public void execute(DSResponse response, Object rawData, DSRequest request) {
                CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().invalidateCache();
                CategoryPresenter.this.getDisplay().getRemoveOrphanedButton().disable();
                CategoryPresenter.this.getDisplay().getInsertOrphanButton().disable();
            }
        }, null);
        this.formPresenter.disable();
        this.display.getListDisplay().getRemoveButton().disable();
        this.allChildCategoriesPresenter.disable();
    }

    protected void changeSelection(final Record selectedRecord) {
        DynamicEntityDataSource dataSource = this.getPresenterSequenceSetupManager().getDataSource("categoryTreeDS");
        if (this.getPresenterSequenceSetupManager().getDataSource("categorySearchDS").stripDuplicateAllowSpecialCharacters(dataSource.getPrimaryKeyValue(selectedRecord)).equals(this.rootId)) {
            this.formPresenter.disable();
            this.display.getListDisplay().getRemoveButton().disable();
        }
        this.allChildCategoriesPresenter.load(selectedRecord, (AbstractDynamicDataSource)dataSource, new DSCallback((AbstractDynamicDataSource)dataSource){
            final /* synthetic */ AbstractDynamicDataSource val$dataSource;
            {
                this.val$dataSource = abstractDynamicDataSource;
            }

            public void execute(DSResponse response, Object rawData, DSRequest request) {
                if (response.getStatus() == RPCResponse.STATUS_FAILURE) {
                    CategoryPresenter.this.getDisplay().getInsertOrphanButton().disable();
                } else {
                    if (CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().getSelectedRecord() != null) {
                        CategoryPresenter.this.getDisplay().getInsertOrphanButton().enable();
                    }
                    CategoryPresenter.this.allChildCategoriesPresenter.enable();
                    CategoryPresenter.this.allChildCategoriesPresenter.setStartState();
                    CategoryPresenter.this.mediaPresenter.load(selectedRecord, this.val$dataSource, null);
                }
            }
        });
        this.display.getListDisplay().getAddButton().enable();
        this.featuredPresenter.load(selectedRecord, (AbstractDynamicDataSource)dataSource, null);
        this.childProductsPresenter.load(selectedRecord, (AbstractDynamicDataSource)dataSource, null);
        this.getDisplay().getAllCategoriesDisplay().getRemoveButton().disable();
    }

    public void bind() {
        super.bind();
        this.fetchDataHandlerRegistration.removeHandler();
        this.featuredPresenter.bind();
        this.mediaPresenter.bind();
        this.allChildCategoriesPresenter.bind();
        this.childProductsPresenter.bind();
        ((TreeGrid)this.display.getListDisplay().getGrid()).addDataArrivedHandler(new DataArrivedHandler(){

            public void onDataArrived(DataArrivedEvent event) {
                Record[] records;
                for (Record record : records = event.getParentNode().getAttributeAsRecordArray("children")) {
                    String hasChildren = record.getAttribute("hasAllChildCategories");
                    if (hasChildren == null || Boolean.parseBoolean(hasChildren)) continue;
                    ((TreeGrid)CategoryPresenter.this.display.getListDisplay().getGrid()).getTree().loadChildren((TreeNode)record);
                }
            }
        });
        this.getDisplay().getRemoveOrphanedButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    SC.confirm((String)BLCMain.getMessageManager().getString("confirmDelete"), (BooleanCallback)new BooleanCallback(){

                        public void execute(Boolean value) {
                            if (value.booleanValue()) {
                                CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().removeSelectedData();
                                CategoryPresenter.this.getDisplay().getRemoveOrphanedButton().disable();
                                CategoryPresenter.this.getDisplay().getInsertOrphanButton().disable();
                            }
                        }
                    });
                }
            }
        });
        this.getDisplay().getInsertOrphanButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    CategoryPresenter.this.getDisplay().getAllCategoriesDisplay().getGrid().addData((Record)CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().getSelectedRecord(), new DSCallback(){

                        public void execute(DSResponse response, Object rawData, DSRequest request) {
                            CategoryPresenter.this.reloadParentTreeNodeRecords(true);
                            CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().invalidateCache();
                            CategoryPresenter.this.getDisplay().getRemoveOrphanedButton().disable();
                            CategoryPresenter.this.getDisplay().getInsertOrphanButton().disable();
                        }
                    });
                }
            }
        });
        this.getDisplay().getOrphanedCategoryGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                if (event.getState()) {
                    CategoryPresenter.this.getDisplay().getRemoveOrphanedButton().enable();
                    if (CategoryPresenter.this.display.getListDisplay().getGrid().getSelectedRecord() != null && !CategoryPresenter.this.getDisplay().getAllCategoriesDisplay().getGrid().isDisabled().booleanValue()) {
                        CategoryPresenter.this.getDisplay().getInsertOrphanButton().enable();
                    }
                } else {
                    CategoryPresenter.this.getDisplay().getRemoveOrphanedButton().disable();
                    CategoryPresenter.this.getDisplay().getInsertOrphanButton().disable();
                }
            }
        });
    }

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("categoryTreeDS", (DataSourceFactory)new CategoryTreeDataSourceFactory(), null, new Object[]{this.rootId, this.rootName}, new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource top) {
                CategoryPresenter.this.setupDisplayItems(top, new DataSource[0]);
                ((TreeGridDataSource)top).setupGridFields(new String[0], new Boolean[0], "250", "100");
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("categorySearchDS", (DataSourceFactory)new CategorySearchDataSourceFactory(), new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.JOINSTRUCTURE, OperationType.ENTITY, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ListGridDataSource categorySearchDataSource = (ListGridDataSource)result;
                categorySearchDataSource.resetPermanentFieldVisibility(new String[]{"name", "urlKey", "activeStartDate", "activeEndDate"});
                EntitySearchDialog categorySearchView = new EntitySearchDialog(categorySearchDataSource);
                CategoryPresenter.this.library.put("categorySearchView", categorySearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("allChildCategoriesDS", (DataSourceFactory)new CategoryListDataSourceFactory(), new OperationTypes(OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                CategoryPresenter.this.allChildCategoriesPresenter = new AllChildCategoriesPresenter(CategoryPresenter.this, CategoryPresenter.this.getDisplay().getAllCategoriesDisplay(), (EntitySearchDialog)CategoryPresenter.this.library.get("categorySearchView"), new String[]{"org.broadleafcommerce.core.catalog.domain.CategoryImpl"}, BLCMain.getMessageManager().getString("categorySearchTitle"));
                CategoryPresenter.this.allChildCategoriesPresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "urlKey"}, new Boolean[]{false, false});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("orphanedCategoriesDS", (DataSourceFactory)new OrphanedCategoryListDataSourceFactory(), null, new Object[]{this.rootId}, new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().setDataSource(result);
                ((ListGridDataSource)result).setAssociatedGrid((DataBoundComponent)CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid());
                ((ListGridDataSource)result).setupGridFields(new String[]{"name", "urlKey"});
                Criteria myCriteria = new Criteria();
                myCriteria.addCriteria("allParentCategories", "0");
                CategoryPresenter.this.getDisplay().getOrphanedCategoryGrid().fetchData(myCriteria);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("productSearchDS", (DataSourceFactory)new ProductListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ListGridDataSource productSearchDataSource = (ListGridDataSource)result;
                productSearchDataSource.resetPermanentFieldVisibility(new String[]{"name", "description", "model", "manufacturer", "activeStartDate", "activeEndDate"});
                EntitySearchDialog productSearchView = new EntitySearchDialog(productSearchDataSource);
                CategoryPresenter.this.library.put("productSearchView", productSearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("featuredProductsDS", (DataSourceFactory)new FeaturedProductListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                CategoryPresenter.this.featuredPresenter = new EditableJoinStructurePresenter(CategoryPresenter.this.getDisplay().getFeaturedDisplay(), (EntitySearchDialog)CategoryPresenter.this.library.get("productSearchView"), new String[]{"org.broadleafcommerce.core.catalog.domain.CategoryImpl"}, BLCMain.getMessageManager().getString("productSearchTitle"), BLCMain.getMessageManager().getString("setPromotionMessageTitle"), new String[]{"promotionMessage"});
                CategoryPresenter.this.featuredPresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "promotionMessage"}, new Boolean[]{false, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("allChildProductsDS", (DataSourceFactory)new AllProductsDataSourceFactory(), new OperationTypes(OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                CategoryPresenter.this.childProductsPresenter = new SimpleSearchJoinStructurePresenter((GridStructureDisplay)CategoryPresenter.this.getDisplay().getAllProductsDisplay(), (EntitySearchDialog)CategoryPresenter.this.library.get("productSearchView"), new String[]{"org.broadleafcommerce.core.catalog.domain.CategoryImpl"}, BLCMain.getMessageManager().getString("productSearchPrompt"));
                CategoryPresenter.this.childProductsPresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "model", "manufacturer"}, new Boolean[]{false, false, false});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("mediaMapDS", (DataSourceFactory)new MediaMapDataSourceFactory(this), null, new Object[]{this.getMediaMapKeys()}, new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                HashMap<String, String> initialValues = new HashMap<String, String>(2);
                initialValues.put("name", BLCMain.getMessageManager().getString("mediaNameDefault"));
                initialValues.put("label", BLCMain.getMessageManager().getString("mediaLabelDefault"));
                CategoryPresenter.this.mediaPresenter = new MapStructurePresenter(CategoryPresenter.this.getDisplay().getMediaDisplay(), CategoryPresenter.this.getMediaEntityView(), new String[]{"org.broadleafcommerce.core.catalog.domain.CategoryImpl"}, BLCMain.getMessageManager().getString("newMediaTitle"), initialValues);
                CategoryPresenter.this.mediaPresenter.setDataSource((ListGridDataSource)result, new String[]{"key", "name", "url", "label"}, new Boolean[]{true, true, true, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("staticAssetTreeDS", (DataSourceFactory)new StaticAssetsTileGridDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource dataSource) {
                TileGridDataSource staticAssetTreeDS = (TileGridDataSource)dataSource;
                final AssetSearchDialog assetSearchDialogView = new AssetSearchDialog(staticAssetTreeDS);
                CategoryPresenter.this.getPresenterSequenceSetupManager().getDataSource("mediaMapDS").getFormItemCallbackHandlerManager().addFormItemCallback("url", new FormItemCallback(){

                    public void execute(final FormItem formItem) {
                        assetSearchDialogView.search("Asset Search", new TileGridItemSelectedHandler(){

                            public void onSearchItemSelected(TileGridItemSelected event) {
                                String staticAssetFullUrl = BLCMain.assetServerUrlPrefix + event.getRecord().getAttribute("fullUrl");
                                formItem.setValue(staticAssetFullUrl);
                                CategoryPresenter.this.getMediaEntityView().updateMedia(staticAssetFullUrl);
                            }
                        });
                    }
                });
            }
        }));
    }

    public void reloadAllChildRecordsForId(String id) {
        String startingId = this.getPresenterSequenceSetupManager().getDataSource("categorySearchDS").stripDuplicateAllowSpecialCharacters(id);
        RecordList resultSet = this.display.getListDisplay().getGrid().getRecordList();
        if (resultSet != null) {
            Record[] myRecords;
            for (Record myRecord : myRecords = resultSet.toArray()) {
                String myId = this.getPresenterSequenceSetupManager().getDataSource("categorySearchDS").stripDuplicateAllowSpecialCharacters(this.getPresenterSequenceSetupManager().getDataSource("categoryTreeDS").getPrimaryKeyValue(myRecord));
                if (!startingId.equals(myId)) continue;
                ((TreeGrid)this.display.getListDisplay().getGrid()).getTree().reloadChildren((TreeNode)myRecord);
            }
        }
    }

    public void reloadParentTreeNodeRecords(boolean disableCategoryButton) {
        TreeNode parentRecord = (TreeNode)this.display.getListDisplay().getGrid().getSelectedRecord();
        this.reloadAllChildRecordsForId(this.getPresenterSequenceSetupManager().getDataSource("categoryTreeDS").getPrimaryKeyValue((Record)parentRecord));
        if (disableCategoryButton) {
            this.getDisplay().getAllCategoriesDisplay().getRemoveButton().disable();
        }
    }

    protected LinkedHashMap<String, String> getMediaMapKeys() {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>(3);
        keys.put("small", BLCMain.getMessageManager().getString("mediaSizeSmall"));
        keys.put("medium", BLCMain.getMessageManager().getString("mediaSizeMedium"));
        keys.put("large", BLCMain.getMessageManager().getString("mediaSizeLarge"));
        return keys;
    }

    protected MapStructureEntityEditDialog getMediaEntityView() {
        if (this.mapEntityAdd == null) {
            this.mapEntityAdd = new MapStructureEntityEditDialog(MediaMapDataSourceFactory.MAPSTRUCTURE, this.getMediaMapKeys());
            this.mapEntityAdd.setShowMedia(true);
            this.mapEntityAdd.setMediaField("url");
        }
        return this.mapEntityAdd;
    }

    public CategoryDisplay getDisplay() {
        return (CategoryDisplay)this.display;
    }
}

