/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.server.service.handler;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.security.domain.AdminUser;
import org.broadleafcommerce.openadmin.server.security.domain.AdminUserImpl;
import org.broadleafcommerce.openadmin.server.security.service.AdminSecurityService;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;

public class AdminUserCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(AdminUserCustomPersistenceHandler.class);
    @Resource(name="blAdminSecurityService")
    protected AdminSecurityService adminSecurityService;

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return persistencePackage.getCeilingEntityFullyQualifiedClassname() != null && persistencePackage.getCeilingEntityFullyQualifiedClassname().equals(AdminUserImpl.class.getName());
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return persistencePackage.getCeilingEntityFullyQualifiedClassname() != null && persistencePackage.getCeilingEntityFullyQualifiedClassname().equals(AdminUserImpl.class.getName());
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            AdminUser adminInstance = (AdminUser)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(AdminUser.class.getName(), persistencePerspective);
            adminInstance = (AdminUser)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            adminInstance.setUnencodedPassword(adminInstance.getPassword());
            adminInstance.setPassword(null);
            adminInstance = this.adminSecurityService.saveAdminUser(adminInstance);
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            return adminEntity;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(AdminUser.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            AdminUser adminInstance = (AdminUser)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            adminInstance = (AdminUser)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            adminInstance.setUnencodedPassword(adminInstance.getPassword());
            adminInstance.setPassword(null);
            adminInstance = this.adminSecurityService.saveAdminUser(adminInstance);
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            return adminEntity;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }
}

