/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.amazon.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.file.FileServiceException;
import org.broadleafcommerce.common.file.domain.FileWorkArea;
import org.broadleafcommerce.common.file.service.BroadleafFileService;
import org.broadleafcommerce.common.file.service.FileServiceProvider;
import org.broadleafcommerce.common.file.service.type.FileApplicationType;
import org.broadleafcommerce.common.site.domain.Site;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.vendor.amazon.s3.S3Configuration;
import org.broadleafcommerce.vendor.amazon.s3.S3ConfigurationService;
import org.springframework.stereotype.Service;

@Service(value="blS3FileServiceProvider")
public class S3FileServiceProvider
implements FileServiceProvider {
    @Resource(name="blS3ConfigurationService")
    protected S3ConfigurationService s3ConfigurationService;
    @Resource(name="blFileService")
    protected BroadleafFileService blFileService;
    protected Map<S3Configuration, AmazonS3Client> configClientMap = new HashMap<S3Configuration, AmazonS3Client>();

    public File getResource(String name) {
        return this.getResource(name, FileApplicationType.ALL);
    }

    public File getResource(String name, FileApplicationType fileApplicationType) {
        File returnFile = this.blFileService.getLocalResource(this.buildResourceName(name));
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            S3Configuration s3config = this.s3ConfigurationService.lookupS3Configuration();
            AmazonS3Client s3 = this.getAmazonS3Client(s3config);
            S3Object object = s3.getObject(new GetObjectRequest(s3config.getDefaultBucketName(), this.buildResourceName(name)));
            inputStream = object.getObjectContent();
            if (!(returnFile.getParentFile().exists() || returnFile.getParentFile().mkdirs() || returnFile.getParentFile().exists())) {
                throw new RuntimeException("Unable to create parent directories for file: " + name);
            }
            outputStream = new FileOutputStream(returnFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error writing s3 file to local file system", ioe);
        }
        catch (AmazonS3Exception s3Exception) {
            if ("NoSuchKey".equals(s3Exception.getErrorCode())) {
                File file = new File("this/path/should/not/exist/" + UUID.randomUUID());
                return file;
            }
            throw s3Exception;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing input stream while writing s3 file to file system", e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing output stream while writing s3 file to file system", e);
                }
            }
        }
        return returnFile;
    }

    public void addOrUpdateResources(FileWorkArea workArea, List<File> files, boolean removeFilesFromWorkArea) {
        this.addOrUpdateResourcesForPaths(workArea, files, removeFilesFromWorkArea);
    }

    public List<String> addOrUpdateResourcesForPaths(FileWorkArea workArea, List<File> files, boolean removeFilesFromWorkArea) {
        S3Configuration s3config = this.s3ConfigurationService.lookupS3Configuration();
        AmazonS3Client s3 = this.getAmazonS3Client(s3config);
        try {
            return this.addOrUpdateResourcesInternal(s3config, s3, workArea, files, removeFilesFromWorkArea);
        }
        catch (AmazonServiceException ase) {
            if ("NoSuchBucket".equals(ase.getErrorCode())) {
                s3.createBucket(s3config.getDefaultBucketName());
                return this.addOrUpdateResourcesInternal(s3config, s3, workArea, files, removeFilesFromWorkArea);
            }
            throw new RuntimeException(ase);
        }
    }

    protected List<String> addOrUpdateResourcesInternal(S3Configuration s3config, AmazonS3Client s3, FileWorkArea workArea, List<File> files, boolean removeFilesFromWorkArea) {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (File srcFile : files) {
            if (!srcFile.getAbsolutePath().startsWith(workArea.getFilePathLocation())) {
                throw new FileServiceException("Attempt to update file " + srcFile.getAbsolutePath() + " that is not in the passed in WorkArea " + workArea.getFilePathLocation());
            }
            String fileName = srcFile.getAbsolutePath().substring(workArea.getFilePathLocation().length());
            String resourceName = this.buildResourceName(fileName);
            s3.putObject(new PutObjectRequest(s3config.getDefaultBucketName(), resourceName, srcFile));
            resourcePaths.add(fileName);
        }
        return resourcePaths;
    }

    public boolean removeResource(String name) {
        S3Configuration s3config = this.s3ConfigurationService.lookupS3Configuration();
        AmazonS3Client s3 = this.getAmazonS3Client(s3config);
        s3.deleteObject(s3config.getDefaultBucketName(), this.buildResourceName(name));
        File returnFile = this.blFileService.getLocalResource(this.buildResourceName(name));
        if (returnFile != null) {
            returnFile.delete();
        }
        return true;
    }

    protected String buildResourceName(String name) {
        String baseDirectory;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (StringUtils.isNotEmpty((CharSequence)(baseDirectory = this.s3ConfigurationService.lookupS3Configuration().getBucketSubDirectory()))) {
            if (baseDirectory.startsWith("/")) {
                baseDirectory = baseDirectory.substring(1);
            }
        } else {
            baseDirectory = "";
        }
        String siteSpecificResourceName = this.getSiteSpecificResourceName(name);
        return FilenameUtils.concat((String)baseDirectory, (String)siteSpecificResourceName);
    }

    protected String getSiteSpecificResourceName(String resourceName) {
        Site site;
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc != null && (site = brc.getNonPersistentSite()) != null) {
            String siteDirectory = this.getSiteDirectory(site);
            if (resourceName.startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return FilenameUtils.concat((String)siteDirectory, (String)resourceName);
        }
        return resourceName;
    }

    protected String getSiteDirectory(Site site) {
        String siteDirectory = "site-" + site.getId();
        return siteDirectory;
    }

    protected AmazonS3Client getAmazonS3Client(S3Configuration s3config) {
        AmazonS3Client client = this.configClientMap.get(s3config);
        if (client == null) {
            client = new AmazonS3Client(this.getAWSCredentials(s3config));
            client.setRegion(RegionUtils.getRegion((String)s3config.getDefaultBucketRegion()));
            if (s3config.getEndpointURI() != null) {
                client.setEndpoint(s3config.getEndpointURI());
            }
            this.configClientMap.put(s3config, client);
        }
        return client;
    }

    protected AWSCredentials getAWSCredentials(final S3Configuration s3configParam) {
        return new AWSCredentials(){
            private final S3Configuration s3ConfigVar;
            {
                this.s3ConfigVar = s3configParam;
            }

            public String getAWSSecretKey() {
                return this.s3ConfigVar.getAwsSecretKey();
            }

            public String getAWSAccessKeyId() {
                return this.s3ConfigVar.getGetAWSAccessKeyId();
            }
        };
    }

    public void setBroadleafFileService(BroadleafFileService bfs) {
        this.blFileService = bfs;
    }
}

