/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.authorizenet.web.controller;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutController;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetCheckoutService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafAuthorizeNetController
extends BroadleafCheckoutController {
    private static final Log LOG = LogFactory.getLog(BroadleafAuthorizeNetController.class);
    @Resource(name="blAuthorizeNetCheckoutService")
    protected AuthorizeNetCheckoutService authorizeNetCheckoutService;
    @Value(value="${authorizenet.error.url}")
    protected String authorizeNetErrorUrl;
    @Value(value="${authorizenet.confirm.url}")
    protected String authorizeNetConfirmUrl;

    public String checkout(HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
        Order order = CartState.getCart();
        if (!(order instanceof NullOrderImpl)) {
            try {
                Map<String, String> formFields = this.authorizeNetCheckoutService.constructAuthorizeAndDebitFields(order);
                for (String key : formFields.keySet()) {
                    model.addAttribute(key, (Object)formFields.get(key));
                }
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)("Error Creating Authorize.net Checkout Form " + e));
            }
            catch (InvalidKeyException e) {
                LOG.error((Object)("Error Creating Authorize.net Checkout Form " + e));
            }
        }
        return super.checkout(request, response, model, redirectAttributes);
    }

    @ResponseBody
    public String processAuthorizeNetAuthorizeAndDebit(HttpServletRequest request, HttpServletResponse response, Model model) throws NoSuchAlgorithmException, PricingException, InvalidKeyException, UnsupportedEncodingException {
        Order order;
        block8: {
            order = this.authorizeNetCheckoutService.findCartForCustomer(request.getParameterMap());
            if (order != null && !(order instanceof NullOrderImpl)) {
                try {
                    this.initializeOrderForCheckout(order);
                    CheckoutResponse checkoutResponse = this.authorizeNetCheckoutService.completeAuthorizeAndDebitCheckout(order, request.getParameterMap());
                    PaymentInfo authorizeNetPaymentInfo = null;
                    for (PaymentInfo paymentInfo : checkoutResponse.getPaymentResponse().getResponseItems().keySet()) {
                        if (!PaymentInfoType.CREDIT_CARD.equals((Object)paymentInfo.getType())) continue;
                        authorizeNetPaymentInfo = paymentInfo;
                    }
                    PaymentResponseItem paymentResponseItem = (PaymentResponseItem)checkoutResponse.getPaymentResponse().getResponseItems().get(authorizeNetPaymentInfo);
                    if (paymentResponseItem.getTransactionSuccess().booleanValue()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Transaction success for order " + checkoutResponse.getOrder().getOrderNumber()));
                            LOG.debug((Object)"Response for Authorize.net to relay to client: ");
                            LOG.debug((Object)this.authorizeNetCheckoutService.buildRelayResponse(this.authorizeNetConfirmUrl + "/" + checkoutResponse.getOrder().getOrderNumber()));
                        }
                        return this.authorizeNetCheckoutService.buildRelayResponse(this.authorizeNetConfirmUrl + "/" + checkoutResponse.getOrder().getOrderNumber());
                    }
                    break block8;
                }
                catch (CheckoutException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Checkout Exception occurred processing Authorize.net relay response (params: [" + this.requestParamToString(request) + "])" + (Object)((Object)e)));
                    }
                    break block8;
                }
            }
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)("The order could not be determined from the Authorize.net relay response (params: [" + this.requestParamToString(request) + "]). NOTE: The transaction may have completed successfully. Check your application keys and hash."));
            }
        }
        this.processFailedOrderCheckout(order);
        return this.authorizeNetCheckoutService.buildRelayResponse(this.authorizeNetErrorUrl);
    }

    private String requestParamToString(HttpServletRequest request) {
        StringBuffer requestMap = new StringBuffer();
        for (String key : request.getParameterMap().keySet()) {
            requestMap.append(key + ": " + request.getParameter(key) + ", ");
        }
        return requestMap.toString();
    }
}

