/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.module;

import java.util.HashMap;
import javax.annotation.Resource;
import net.authorize.ResponseField;
import net.authorize.sim.Result;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.module.PaymentModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoAdditionalFieldType;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetPaymentService;
import org.springframework.util.Assert;

public class AuthorizeNetPaymentModule
implements PaymentModule {
    private static final Log LOG = LogFactory.getLog(AuthorizeNetPaymentModule.class);
    protected AuthorizeNetPaymentService authorizeNetPaymentService;
    protected StateService stateService;
    protected CountryService countryService;
    protected CustomerService customerService;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public PaymentResponseItem authorize(PaymentContext paymentContext) throws PaymentException {
        return this.authorizeAndDebit(paymentContext);
    }

    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("The reverseAuthorize method is not supported by this org.broadleafcommerce.payment.service.module.AuthorizeNetPaymentModule");
    }

    public PaymentResponseItem debit(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("The debit method is not supported by this org.broadleafcommerce.payment.service.module.AuthorizeNetPaymentModule");
    }

    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws PaymentException {
        PaymentInfo paymentInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating Payment Response for authorize and debit.");
        }
        Assert.isTrue(((paymentInfo = paymentContext.getPaymentInfo()).getRequestParameterMap() != null && !paymentInfo.getRequestParameterMap().isEmpty() ? 1 : 0) != 0, (String)"Must set the Request Parameter Map on the PaymentInfo instance.");
        return this.buildBasicDPMResponse(paymentContext);
    }

    public PaymentResponseItem credit(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("The credit method is not supported by this org.broadleafcommerce.payment.service.module.AuthorizeNetPaymentModule");
    }

    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("The voidPayment method is not supported by this org.broadleafcommerce.payment.service.module.AuthorizeNetPaymentModule");
    }

    public PaymentResponseItem balance(PaymentContext paymentContext) throws PaymentException {
        throw new PaymentException("The balance method is not supported by this org.broadleafcommerce.payment.service.module.AuthorizeNetPaymentModule");
    }

    protected PaymentResponseItem buildBasicDPMResponse(PaymentContext paymentContext) {
        Result result = this.authorizeNetPaymentService.createResult(paymentContext.getPaymentInfo().getRequestParameterMap());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Amount               : " + (String)result.getResponseMap().get(ResponseField.AMOUNT.getFieldName())));
            LOG.debug((Object)("Response Code        : " + result.getResponseCode()));
            LOG.debug((Object)("Response Reason Code : " + result.getReasonResponseCode().getResponseReasonCode()));
            LOG.debug((Object)("Response Reason Text : " + (String)result.getResponseMap().get(ResponseField.RESPONSE_REASON_TEXT.getFieldName())));
            LOG.debug((Object)("Transaction ID       : " + (String)result.getResponseMap().get(ResponseField.TRANSACTION_ID.getFieldName())));
        }
        this.setBillingInfo(paymentContext, result);
        this.setShippingInfo(paymentContext, result);
        this.setPaymentInfoAdditionalFields(paymentContext, result);
        PaymentResponseItem responseItem = (PaymentResponseItem)this.entityConfiguration.createEntityInstance(PaymentResponseItem.class.getName(), PaymentResponseItem.class);
        responseItem.setTransactionSuccess(Boolean.valueOf(this.isValidTransaction(result)));
        responseItem.setTransactionTimestamp(SystemTime.asDate());
        responseItem.setAmountPaid(new Money((String)result.getResponseMap().get(ResponseField.AMOUNT.getFieldName())));
        responseItem.setProcessorResponseCode(result.getResponseCode().getCode() + "");
        responseItem.setProcessorResponseText((String)result.getResponseMap().get(ResponseField.RESPONSE_REASON_TEXT.getFieldName()));
        this.setPaymentResponseAdditionalFields(paymentContext, responseItem, result);
        this.saveAnonymousCustomerInfo(paymentContext, responseItem, result);
        return responseItem;
    }

    protected boolean isValidTransaction(Result result) {
        return result.isAuthorizeNet() && result.isApproved();
    }

    protected void saveAnonymousCustomerInfo(PaymentContext paymentContext, PaymentResponseItem responseItem, Result result) {
        if (responseItem.getTransactionSuccess().booleanValue()) {
            Order order;
            Customer customer;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fill out a few customer values for anonymous customers");
            }
            if (StringUtils.isEmpty((String)(customer = (order = paymentContext.getPaymentInfo().getOrder()).getCustomer()).getFirstName()) && result.getResponseMap().get(ResponseField.FIRST_NAME.getFieldName()) != null) {
                customer.setFirstName((String)result.getResponseMap().get(ResponseField.FIRST_NAME.getFieldName()));
            }
            if (StringUtils.isEmpty((String)customer.getLastName()) && result.getResponseMap().get(ResponseField.LAST_NAME.getFieldName()) != null) {
                customer.setLastName((String)result.getResponseMap().get(ResponseField.LAST_NAME.getFieldName()));
            }
            if (StringUtils.isEmpty((String)customer.getEmailAddress()) && result.getResponseMap().get(ResponseField.EMAIL_ADDRESS.getFieldName()) != null) {
                customer.setEmailAddress((String)result.getResponseMap().get(ResponseField.EMAIL_ADDRESS.getFieldName()));
            }
            this.customerService.saveCustomer(customer, false);
        }
    }

    protected void setPaymentInfoAdditionalFields(PaymentContext paymentContext, Result result) {
        PaymentInfo paymentInfo = null;
        for (PaymentInfo pi : paymentContext.getPaymentInfo().getOrder().getPaymentInfos()) {
            if (!PaymentInfoType.CREDIT_CARD.equals((Object)pi.getType())) continue;
            paymentInfo = pi;
        }
        if (paymentInfo != null) {
            HashMap<String, String> additionalFields = new HashMap<String, String>();
            additionalFields.put(PaymentInfoAdditionalFieldType.NAME_ON_CARD.getType(), (String)result.getResponseMap().get(ResponseField.FIRST_NAME.getFieldName()) + " " + (String)result.getResponseMap().get(ResponseField.LAST_NAME.getFieldName()));
            additionalFields.put(PaymentInfoAdditionalFieldType.CARD_TYPE.getType(), (String)result.getResponseMap().get(ResponseField.CARD_TYPE.getFieldName()));
            additionalFields.put(PaymentInfoAdditionalFieldType.LAST_FOUR.getType(), (String)result.getResponseMap().get(ResponseField.ACCOUNT_NUMBER.getFieldName()));
            paymentInfo.setAdditionalFields(additionalFields);
        }
    }

    protected void setPaymentResponseAdditionalFields(PaymentContext paymentContext, PaymentResponseItem responseItem, Result result) {
        HashMap map = new HashMap();
        for (ResponseField field : ResponseField.values()) {
            if (this.isBillingAddressField(field) || this.isShippingAddressField(field) || StringUtils.isEmpty((String)((String)result.getResponseMap().get(field.getFieldName())))) continue;
            map.put(field.getFieldName(), result.getResponseMap().get(field.getFieldName()));
        }
        responseItem.setAdditionalFields(map);
    }

    protected void setBillingInfo(PaymentContext paymentContext, Result result) {
        PaymentInfo paymentInfo = null;
        for (PaymentInfo pi : paymentContext.getPaymentInfo().getOrder().getPaymentInfos()) {
            if (!PaymentInfoType.CREDIT_CARD.equals((Object)pi.getType())) continue;
            paymentInfo = pi;
        }
        Address address = (Address)this.entityConfiguration.createEntityInstance(Address.class.getName(), Address.class);
        this.initializeEmptyAddress(address);
        Phone phone = null;
        boolean billingPopulated = false;
        for (ResponseField field : ResponseField.values()) {
            if (!this.isBillingAddressField(field) || StringUtils.isEmpty((String)((String)result.getResponseMap().get(field.getFieldName())))) continue;
            String value = (String)result.getResponseMap().get(field.getFieldName());
            if (!StringUtils.isEmpty((String)value)) {
                switch (field) {
                    case FIRST_NAME: {
                        address.setFirstName(value);
                        break;
                    }
                    case LAST_NAME: {
                        address.setLastName(value);
                        break;
                    }
                    case COMPANY: {
                        address.setCompanyName(value);
                        break;
                    }
                    case ADDRESS: {
                        address.setAddressLine1(value);
                        break;
                    }
                    case CITY: {
                        address.setCity(value);
                        break;
                    }
                    case STATE: {
                        State state = this.stateService.findStateByAbbreviation(value);
                        if (state == null) break;
                        address.setState(state);
                        break;
                    }
                    case COUNTRY: {
                        Country country = this.countryService.findCountryByAbbreviation(value);
                        address.setCountry(country);
                        break;
                    }
                    case ZIP_CODE: {
                        address.setPostalCode(value);
                        break;
                    }
                    case EMAIL_ADDRESS: {
                        address.setEmailAddress(value);
                        break;
                    }
                    case PHONE: {
                        phone = (Phone)this.entityConfiguration.createEntityInstance(Phone.class.getName(), Phone.class);
                        phone.setPhoneNumber(value);
                        break;
                    }
                }
            }
            billingPopulated = true;
        }
        if (billingPopulated) {
            paymentInfo.setAddress(address);
            paymentInfo.setPhone(phone);
        }
    }

    protected void setShippingInfo(PaymentContext paymentContext, Result result) {
        Order order = paymentContext.getPaymentInfo().getOrder();
        Address address = (Address)this.entityConfiguration.createEntityInstance(Address.class.getName(), Address.class);
        this.initializeEmptyAddress(address);
        boolean shippingPopulated = false;
        for (ResponseField field : ResponseField.values()) {
            if (!this.isShippingAddressField(field) || StringUtils.isEmpty((String)((String)result.getResponseMap().get(field.getFieldName())))) continue;
            String value = (String)result.getResponseMap().get(field.getFieldName());
            if (!StringUtils.isEmpty((String)value) && address != null) {
                switch (field) {
                    case SHIP_TO_FIRST_NAME: {
                        address.setFirstName(value);
                        break;
                    }
                    case SHIP_TO_LAST_NAME: {
                        address.setLastName(value);
                        break;
                    }
                    case SHIP_TO_COMPANY: {
                        address.setCompanyName(value);
                        break;
                    }
                    case SHIP_TO_ADDRESS: {
                        address.setAddressLine1(value);
                        break;
                    }
                    case SHIP_TO_CITY: {
                        address.setCity(value);
                        break;
                    }
                    case SHIP_TO_STATE: {
                        State state = this.stateService.findStateByAbbreviation(value);
                        if (state == null) break;
                        address.setState(state);
                        break;
                    }
                    case SHIP_TO_COUNTRY: {
                        Country country = this.countryService.findCountryByAbbreviation(value);
                        address.setCountry(country);
                        break;
                    }
                    case SHIP_TO_ZIP_CODE: {
                        address.setPostalCode(value);
                        break;
                    }
                }
            }
            shippingPopulated = true;
        }
        if (shippingPopulated) {
            this.populateShippingAddressOnOrder(order, address);
        }
    }

    protected void initializeEmptyAddress(Address address) {
        address.setAddressLine1("");
        address.setCity("");
        address.setPostalCode("");
    }

    protected void populateShippingAddressOnOrder(Order order, Address shippingAddress) {
        if (order.getFulfillmentGroups() != null && order.getFulfillmentGroups().size() == 1) {
            FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
            fg.setAddress(shippingAddress);
        }
    }

    protected boolean isBillingAddressField(ResponseField field) {
        return ResponseField.FIRST_NAME.equals((Object)field) || ResponseField.LAST_NAME.equals((Object)field) || ResponseField.COMPANY.equals((Object)field) || ResponseField.ADDRESS.equals((Object)field) || ResponseField.CITY.equals((Object)field) || ResponseField.STATE.equals((Object)field) || ResponseField.ZIP_CODE.equals((Object)field) || ResponseField.COUNTRY.equals((Object)field) || ResponseField.EMAIL_ADDRESS.equals((Object)field) || ResponseField.PHONE.equals((Object)field);
    }

    protected boolean isShippingAddressField(ResponseField field) {
        return ResponseField.SHIP_TO_FIRST_NAME.equals((Object)field) || ResponseField.SHIP_TO_LAST_NAME.equals((Object)field) || ResponseField.SHIP_TO_COMPANY.equals((Object)field) || ResponseField.SHIP_TO_ADDRESS.equals((Object)field) || ResponseField.SHIP_TO_CITY.equals((Object)field) || ResponseField.SHIP_TO_STATE.equals((Object)field) || ResponseField.SHIP_TO_ZIP_CODE.equals((Object)field) || ResponseField.SHIP_TO_COUNTRY.equals((Object)field);
    }

    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return PaymentInfoType.CREDIT_CARD.equals((Object)paymentType);
    }

    public AuthorizeNetPaymentService getAuthorizeNetPaymentService() {
        return this.authorizeNetPaymentService;
    }

    public void setAuthorizeNetPaymentService(AuthorizeNetPaymentService authorizeNetPaymentService) {
        this.authorizeNetPaymentService = authorizeNetPaymentService;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }
}

