/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.authorizenet.service.payment;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.authorize.ResponseField;
import net.authorize.sim.Fingerprint;
import net.authorize.sim.Result;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetCheckoutService;
import org.broadleafcommerce.vendor.authorizenet.service.payment.AuthorizeNetPaymentService;
import org.springframework.stereotype.Service;

@Service(value="blAuthorizeNetCheckoutService")
public class AuthorizeNetCheckoutServiceImpl
implements AuthorizeNetCheckoutService {
    private static final Log LOG = LogFactory.getLog(AuthorizeNetCheckoutServiceImpl.class);
    public static final String BLC_CID = "blc_cid";
    public static final String BLC_OID = "blc_oid";
    public static final String BLC_TPS = "blc_tps";
    @Resource(name="blSecurePaymentInfoService")
    protected SecurePaymentInfoService securePaymentInfoService;
    @Resource(name="blPaymentInfoService")
    protected PaymentInfoService paymentInfoService;
    @Resource(name="blAuthorizeNetVendorOrientedPaymentService")
    protected AuthorizeNetPaymentService authorizeNetPaymentService;
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    @Override
    public Order findCartForCustomer(Map<String, String[]> responseMap) throws InvalidKeyException, NoSuchAlgorithmException {
        Result result = this.authorizeNetPaymentService.createResult(responseMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Result Reason Text - " + (String)result.getResponseMap().get(ResponseField.RESPONSE_REASON_TEXT.getFieldName())));
        }
        if (result.isAuthorizeNet()) {
            Order order;
            Long customerId = Long.parseLong((String)result.getResponseMap().get(BLC_CID));
            Long orderId = Long.parseLong((String)result.getResponseMap().get(BLC_OID));
            String formTps = (String)result.getResponseMap().get(BLC_TPS);
            String tps = this.createTamperProofSeal(customerId, orderId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Customer ID - " + customerId));
                LOG.debug((Object)("Order ID - " + orderId));
                LOG.debug((Object)("Form tps - " + formTps));
                LOG.debug((Object)("tps - " + tps));
            }
            if (tps.equals(formTps) && (order = this.orderService.findOrderById(orderId)) != null && order.getCustomer().getId().equals(customerId)) {
                return order;
            }
        }
        return null;
    }

    @Override
    public CheckoutResponse completeAuthorizeAndDebitCheckout(Order order, Map<String, String[]> responseMap) throws CheckoutException {
        HashMap<PaymentInfo, CreditCardPaymentInfo> payments = new HashMap<PaymentInfo, CreditCardPaymentInfo>();
        this.orderService.removePaymentsFromOrder(order, PaymentInfoType.CREDIT_CARD);
        PaymentInfo authorizeNetPaymentInfo = this.paymentInfoService.create();
        authorizeNetPaymentInfo.setOrder(order);
        authorizeNetPaymentInfo.setType(PaymentInfoType.CREDIT_CARD);
        authorizeNetPaymentInfo.setReferenceNumber(order.getOrderNumber());
        authorizeNetPaymentInfo.setRequestParameterMap(responseMap);
        order.getPaymentInfos().add(authorizeNetPaymentInfo);
        CreditCardPaymentInfo creditCardPaymentInfo = (CreditCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.CREDIT_CARD);
        creditCardPaymentInfo.setReferenceNumber(authorizeNetPaymentInfo.getReferenceNumber());
        payments.put(authorizeNetPaymentInfo, creditCardPaymentInfo);
        return this.checkoutService.performCheckout(order, payments);
    }

    @Override
    public Map<String, String> constructAuthorizeAndDebitFields(Order order) throws InvalidKeyException, NoSuchAlgorithmException {
        if (order != null) {
            String apiLoginId = this.authorizeNetPaymentService.getGatewayRequest().getApiLoginId();
            String transactionKey = this.authorizeNetPaymentService.getGatewayRequest().getTransactionKey();
            String relayResponseURL = this.authorizeNetPaymentService.getGatewayRequest().getRelayResponseUrl();
            String merchantTransactionVersion = this.authorizeNetPaymentService.getGatewayRequest().getMerchantTransactionVersion();
            String xTestRequest = this.authorizeNetPaymentService.getGatewayRequest().getxTestRequest();
            String serverUrl = this.authorizeNetPaymentService.getGatewayRequest().getServerUrl();
            Fingerprint fingerprint = Fingerprint.createFingerprint((String)apiLoginId, (String)transactionKey, (long)System.currentTimeMillis(), (String)order.getTotal().toString());
            HashMap<String, String> formFields = new HashMap<String, String>();
            formFields.put("x_invoice_num", System.currentTimeMillis() + "");
            formFields.put("x_relay_url", relayResponseURL);
            formFields.put("x_login", apiLoginId);
            formFields.put("x_fp_sequence", fingerprint.getSequence() + "");
            formFields.put("x_fp_timestamp", fingerprint.getTimeStamp() + "");
            formFields.put("x_fp_hash", fingerprint.getFingerprintHash());
            formFields.put("x_version", merchantTransactionVersion);
            formFields.put("x_method", "CC");
            formFields.put("x_type", "AUTH_CAPTURE");
            formFields.put("x_amount", order.getTotal().toString());
            formFields.put("x_test_request", xTestRequest);
            formFields.put(BLC_CID, order.getCustomer().getId().toString());
            formFields.put(BLC_OID, order.getId().toString());
            formFields.put(BLC_TPS, this.createTamperProofSeal(order.getCustomer().getId(), order.getId()));
            formFields.put("authorizenet_server_url", serverUrl);
            return formFields;
        }
        return null;
    }

    @Override
    public String buildRelayResponse(String receiptUrl) {
        StringBuffer response = new StringBuffer();
        response.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n \"http://www.w3.org/TR/html4/loose.dtd\">");
        response.append("<html>");
        response.append("<head>");
        response.append("</head>");
        response.append("<body>");
        response.append("<script type=\"text/javascript\">");
        response.append("var referrer = document.referrer;");
        response.append("if (referrer.substr(0,7)==\"http://\") referrer = referrer.substr(7);");
        response.append("if (referrer.substr(0,8)==\"https://\") referrer = referrer.substr(8);");
        response.append("if(referrer && referrer.indexOf(document.location.hostname) != 0) {");
        response.append("document.location = \"" + receiptUrl + "\";");
        response.append("}");
        response.append("</script>");
        response.append("<noscript>");
        response.append("<meta http-equiv=\"refresh\" content=\"0;url=" + receiptUrl + "\">");
        response.append("</noscript>");
        response.append("</body>");
        response.append("</html>");
        return response.toString();
    }

    @Override
    public String createTamperProofSeal(Long customerId, Long orderId) throws NoSuchAlgorithmException, InvalidKeyException {
        String transactionKey = this.authorizeNetPaymentService.getGatewayRequest().getTransactionKey();
        Base64 encoder = new Base64();
        Mac sha1Mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec publicKeySpec = new SecretKeySpec(transactionKey.getBytes(), "HmacSHA1");
        sha1Mac.init(publicKeySpec);
        String customerOrderString = customerId.toString() + orderId.toString();
        byte[] publicBytes = sha1Mac.doFinal(customerOrderString.getBytes());
        String publicDigest = encoder.encodeToString(publicBytes);
        return publicDigest.replaceAll("\\r|\\n", "");
    }
}

