/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util.dao;

import junit.framework.TestCase;
import org.broadleafcommerce.common.util.dao.TQRestriction;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;

public class TypedQueryBuilderTest
extends TestCase {
    public void testNoParameters() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
    }

    public void testSingleParameter() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        q.addRestriction("test.attr", "=", (Object)"sample");
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test").append(" WHERE (test.attr = :p0)");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p0"), (Object)"sample");
        TypedQueryBuilderTest.assertEquals((int)q.getParamMap().size(), (int)1);
    }

    public void testTwoParameters() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        q.addRestriction("test.attr", "=", (Object)"sample");
        q.addRestriction("test.attr2", "=", (Object)"sample2");
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test").append(" WHERE (test.attr = :p0) AND (test.attr2 = :p1)");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p0"), (Object)"sample");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1"), (Object)"sample2");
        TypedQueryBuilderTest.assertEquals((int)q.getParamMap().size(), (int)2);
    }

    public void testThreeParameters() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        q.addRestriction("test.attr", "=", (Object)"sample");
        q.addRestriction("test.attr2", "=", (Object)"sample2");
        q.addRestriction("test.attr3", "=", (Object)"sample3");
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test").append(" WHERE (test.attr = :p0) AND (test.attr2 = :p1) AND (test.attr3 = :p2)");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p0"), (Object)"sample");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1"), (Object)"sample2");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p2"), (Object)"sample3");
        TypedQueryBuilderTest.assertEquals((int)q.getParamMap().size(), (int)3);
    }

    public void testOneNested() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        TQRestriction r = new TQRestriction(TQRestriction.Mode.AND).addChildRestriction(new TQRestriction("test.startDate", "&lt;", (Object)"123")).addChildRestriction(new TQRestriction(TQRestriction.Mode.OR).addChildRestriction(new TQRestriction("test.endDate", "is null")).addChildRestriction(new TQRestriction("test.endDate", "&gt;", (Object)"456")));
        q.addRestriction("test.attr", "=", (Object)"sample");
        q.addRestriction(r);
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test").append(" WHERE (test.attr = :p0)").append(" AND ((test.startDate &lt; :p1_0) AND ((test.endDate is null) OR (test.endDate &gt; :p1_1_1)))");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p0"), (Object)"sample");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_0"), (Object)"123");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1_0"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1_1"), (Object)"456");
        TypedQueryBuilderTest.assertEquals((int)q.getParamMap().size(), (int)5);
    }

    public void testTwoNested() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        TQRestriction r = new TQRestriction(TQRestriction.Mode.AND).addChildRestriction(new TQRestriction("test.startDate", "&lt;", (Object)"123")).addChildRestriction(new TQRestriction(TQRestriction.Mode.OR).addChildRestriction(new TQRestriction("test.endDate", "is null")).addChildRestriction(new TQRestriction("test.endDate", "&gt;", (Object)"456")));
        TQRestriction r2 = new TQRestriction(TQRestriction.Mode.OR).addChildRestriction(new TQRestriction("test.res1", "=", (Object)"333")).addChildRestriction(new TQRestriction(TQRestriction.Mode.AND).addChildRestriction(new TQRestriction("test.res2", "is null")).addChildRestriction(new TQRestriction("test.res3", "&gt;", (Object)"456")));
        q.addRestriction("test.attr", "=", (Object)"sample");
        q.addRestriction(r);
        q.addRestriction(r2);
        System.out.println(q.toQueryString());
        StringBuilder expected = new StringBuilder("SELECT test FROM " + String.class.getName() + " test").append(" WHERE (test.attr = :p0)").append(" AND ((test.startDate &lt; :p1_0) AND ((test.endDate is null) OR (test.endDate &gt; :p1_1_1)))").append(" AND ((test.res1 = :p2_0) OR ((test.res2 is null) AND (test.res3 &gt; :p2_1_1)))");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(), (String)expected.toString());
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p0"), (Object)"sample");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_0"), (Object)"123");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1_0"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p1_1_1"), (Object)"456");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p2_0"), (Object)"333");
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p2_1"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p2_1_0"), null);
        TypedQueryBuilderTest.assertEquals(q.getParamMap().get("p2_1_1"), (Object)"456");
        TypedQueryBuilderTest.assertEquals((int)q.getParamMap().size(), (int)9);
    }

    public void testCountQuery() {
        TypedQueryBuilder q = new TypedQueryBuilder(String.class, "test");
        StringBuilder expected = new StringBuilder("SELECT COUNT(*) FROM " + String.class.getName() + " test");
        TypedQueryBuilderTest.assertEquals((String)q.toQueryString(true), (String)expected.toString());
    }
}

