/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.rule;

import java.util.HashMap;
import junit.framework.TestCase;
import org.broadleafcommerce.common.locale.domain.LocaleImpl;
import org.broadleafcommerce.common.rule.MvelHelper;

public class MvelHelperTest
extends TestCase {
    public void testBlankRule() {
        boolean result = MvelHelper.evaluateRule((String)"", null);
        MvelHelperTest.assertTrue((boolean)result);
    }

    public void testNullRule() {
        boolean result = MvelHelper.evaluateRule(null, null);
        MvelHelperTest.assertTrue((boolean)result);
    }

    public void testRuleWithParseErrors() {
        MvelHelper.setTestMode((boolean)true);
        boolean result = MvelHelper.evaluateRule((String)"BadFunction(xyz)", null);
        MvelHelper.setTestMode((boolean)false);
        MvelHelperTest.assertFalse((boolean)result);
    }

    public void testRuleThatEvaluatesToTrue() {
        LocaleImpl testLocale = new LocaleImpl();
        testLocale.setLocaleCode("US");
        HashMap<String, LocaleImpl> parameters = new HashMap<String, LocaleImpl>();
        parameters.put("locale", testLocale);
        boolean result = MvelHelper.evaluateRule((String)"locale.localeCode == 'US'", parameters);
        MvelHelperTest.assertTrue((boolean)result);
    }

    public void testRuleThatEvaluatesToFalse() {
        LocaleImpl testLocale = new LocaleImpl();
        testLocale.setLocaleCode("GB");
        HashMap<String, LocaleImpl> parameters = new HashMap<String, LocaleImpl>();
        parameters.put("locale", testLocale);
        boolean result = MvelHelper.evaluateRule((String)"locale.localeCode == 'US'", parameters);
        MvelHelperTest.assertFalse((boolean)result);
    }
}

