/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.file.service;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.broadleafcommerce.common.file.domain.FileWorkArea;
import org.broadleafcommerce.common.file.service.BroadleafFileServiceImpl;
import org.broadleafcommerce.common.file.service.FileSystemFileServiceProvider;

public class BroadleafFileServiceImplTest
extends TestCase {
    private final BroadleafFileServiceImpl bfs = new BroadleafFileServiceImpl();
    private final FileSystemFileServiceProvider fsp = new FileSystemFileServiceProvider();
    private FileWorkArea baseSystemDirectory;

    public void setUp() throws Exception {
        this.fsp.maxGeneratedDirectoryDepth = 2;
        this.bfs.defaultFileServiceProvider = this.fsp;
        this.bfs.maxGeneratedDirectoryDepth = 2;
        this.baseSystemDirectory = this.bfs.initializeWorkArea();
        this.fsp.fileSystemBaseDirectory = this.baseSystemDirectory.getFilePathLocation();
    }

    public void tearDown() throws Exception {
        this.bfs.closeWorkArea(this.baseSystemDirectory);
    }

    public void testCreateWorkArea() throws Exception {
        FileWorkArea workArea1 = this.bfs.initializeWorkArea();
        File f1 = new File(workArea1.getFilePathLocation());
        BroadleafFileServiceImplTest.assertTrue((boolean)f1.exists());
        FileWorkArea workArea2 = this.bfs.initializeWorkArea();
        BroadleafFileServiceImplTest.assertFalse((boolean)workArea2.getFilePathLocation().equals(workArea1.getFilePathLocation()));
        this.bfs.closeWorkArea(workArea1);
        BroadleafFileServiceImplTest.assertFalse((boolean)f1.exists());
        this.bfs.closeWorkArea(workArea2);
    }

    public void testCreateAddFile() throws Exception {
        FileWorkArea workArea1 = this.bfs.initializeWorkArea();
        File f1 = new File(workArea1.getFilePathLocation() + "test.txt");
        FileWriter fw = new FileWriter(f1);
        fw.append("Test File");
        fw.close();
        this.bfs.addOrUpdateResource(workArea1, f1, false);
        this.bfs.closeWorkArea(workArea1);
        File resource = this.bfs.getResource("test.txt");
        BroadleafFileServiceImplTest.assertTrue((boolean)resource.exists());
        this.bfs.removeResource("test.txt");
        resource = this.bfs.getResource("test.txt");
        BroadleafFileServiceImplTest.assertFalse((boolean)resource.exists());
    }

    public void testCreateAddFiles() throws Exception {
        FileWorkArea workArea1 = this.bfs.initializeWorkArea();
        File f1 = new File(workArea1.getFilePathLocation() + "test2.txt");
        FileWriter fw = new FileWriter(f1);
        fw.append("Test File 2");
        fw.close();
        File f2 = new File(workArea1.getFilePathLocation() + "test3.txt");
        FileWriter fw2 = new FileWriter(f2);
        fw2.append("Test File 3");
        fw2.close();
        ArrayList<File> files = new ArrayList<File>();
        files.add(f1);
        files.add(f2);
        this.bfs.addOrUpdateResources(workArea1, files, false);
        this.bfs.closeWorkArea(workArea1);
        File resource = this.bfs.getResource("test2.txt");
        BroadleafFileServiceImplTest.assertTrue((boolean)resource.exists());
        resource = this.bfs.getResource("test3.txt");
        BroadleafFileServiceImplTest.assertTrue((boolean)resource.exists());
        this.bfs.removeResource("test2.txt");
        this.bfs.removeResource("test3.txt");
        resource = this.bfs.getResource("test3.txt");
        BroadleafFileServiceImplTest.assertFalse((boolean)resource.exists());
    }

    public void testCreateFilesCopyWorkarea() throws Exception {
        FileWorkArea workArea1 = this.bfs.initializeWorkArea();
        File f1 = new File(workArea1.getFilePathLocation() + "test4.txt");
        FileWriter fw = new FileWriter(f1);
        fw.append("Test File 4");
        fw.close();
        File f2 = new File(workArea1.getFilePathLocation() + "test5.txt");
        FileWriter fw2 = new FileWriter(f2);
        fw2.append("Test File 5");
        fw2.close();
        this.bfs.addOrUpdateResources(workArea1, false);
        this.bfs.closeWorkArea(workArea1);
        File resource = this.bfs.getResource("test4.txt");
        BroadleafFileServiceImplTest.assertTrue((boolean)resource.exists());
        resource = this.bfs.getResource("test5.txt");
        BroadleafFileServiceImplTest.assertTrue((boolean)resource.exists());
        this.bfs.removeResource("test4.txt");
        this.bfs.removeResource("test5.txt");
        resource = this.bfs.getResource("test5.txt");
        BroadleafFileServiceImplTest.assertFalse((boolean)resource.exists());
    }
}

