/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.module;

import java.util.Currency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItemImpl;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.module.PaymentModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.service.module.CyberSourceModule;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceBillingRequest;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceItemRequest;
import org.broadleafcommerce.vendor.cybersource.service.payment.CyberSourcePaymentService;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourceCardRequest;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourceCardResponse;
import org.broadleafcommerce.vendor.cybersource.service.payment.type.CyberSourceTransactionType;

public class CyberSourceCreditCardModule
extends CyberSourceModule
implements PaymentModule {
    private CyberSourceServiceManager serviceManager;

    public PaymentResponseItem authorize(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        return this.authTypeTransaction(paymentContext, CyberSourceTransactionType.AUTHORIZE);
    }

    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        return this.authTypeTransaction(paymentContext, CyberSourceTransactionType.AUTHORIZEANDCAPTURE);
    }

    private PaymentResponseItem authTypeTransaction(PaymentContext paymentContext, CyberSourceTransactionType transactionType) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        this.setCardInfo(paymentContext, cardRequest);
        cardRequest.setTransactionType(transactionType);
        this.setCurrency(paymentContext, cardRequest);
        CyberSourceBillingRequest billingRequest = this.createBillingRequest(paymentContext.getPaymentInfo());
        cardRequest.setBillingRequest(billingRequest);
        CyberSourceItemRequest itemRequest = this.createItemRequest(paymentContext);
        cardRequest.getItemRequests().add(itemRequest);
        CyberSourceCardResponse response = this.callService(cardRequest);
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        responseItem.setAvsCode(response.getAuthResponse().getAvsCode());
        responseItem.setAuthorizationCode(response.getAuthResponse().getAuthorizationCode());
        responseItem.setAmountPaid(response.getAuthResponse().getAmount());
        responseItem.setProcessorResponseCode(response.getAuthResponse().getProcessorResponse());
        responseItem.setProcessorResponseText(response.getAuthResponse().getProcessorResponse());
        return responseItem;
    }

    public PaymentResponseItem balance(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        throw new org.broadleafcommerce.core.payment.service.exception.PaymentException("balance not supported");
    }

    public PaymentResponseItem credit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        cardRequest.setTransactionType(CyberSourceTransactionType.CREDIT);
        this.setCurrency(paymentContext, cardRequest);
        CyberSourceItemRequest itemRequest = this.createItemRequest(paymentContext);
        cardRequest.getItemRequests().add(itemRequest);
        cardRequest.setRequestID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestId"));
        cardRequest.setRequestToken((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestToken"));
        CyberSourceCardResponse response = this.callService(cardRequest);
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        responseItem.setAmountPaid(response.getCreditResponse().getAmount());
        return responseItem;
    }

    public PaymentResponseItem debit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        cardRequest.setTransactionType(CyberSourceTransactionType.CAPTURE);
        this.setCurrency(paymentContext, cardRequest);
        CyberSourceItemRequest itemRequest = this.createItemRequest(paymentContext);
        cardRequest.getItemRequests().add(itemRequest);
        cardRequest.setRequestID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestId"));
        cardRequest.setRequestToken((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestToken"));
        CyberSourceCardResponse response = this.callService(cardRequest);
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        responseItem.setAmountPaid(response.getCaptureResponse().getAmount());
        return responseItem;
    }

    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        cardRequest.setTransactionType(CyberSourceTransactionType.REVERSEAUTHORIZE);
        this.setCurrency(paymentContext, cardRequest);
        CyberSourceItemRequest itemRequest = this.createItemRequest(paymentContext);
        cardRequest.getItemRequests().add(itemRequest);
        cardRequest.setRequestID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestId"));
        cardRequest.setRequestToken((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestToken"));
        CyberSourceCardResponse response = this.callService(cardRequest);
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        responseItem.setAmountPaid(response.getAuthReverseResponse().getAmount());
        responseItem.setAuthorizationCode(response.getAuthReverseResponse().getAuthorizationCode());
        responseItem.setProcessorResponseCode(response.getAuthReverseResponse().getProcessorResponse());
        responseItem.setProcessorResponseText(response.getAuthReverseResponse().getProcessorResponse());
        return responseItem;
    }

    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardRequest cardRequest = new CyberSourceCardRequest();
        cardRequest.setTransactionType(CyberSourceTransactionType.VOIDTRANSACTION);
        this.setCurrency(paymentContext, cardRequest);
        CyberSourceItemRequest itemRequest = this.createItemRequest(paymentContext);
        cardRequest.getItemRequests().add(itemRequest);
        cardRequest.setRequestID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestId"));
        cardRequest.setRequestToken((String)paymentContext.getPaymentInfo().getAdditionalFields().get("requestToken"));
        CyberSourceCardResponse response = this.callService(cardRequest);
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        responseItem.setAmountPaid(response.getVoidResponse().getAmount());
        return responseItem;
    }

    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return PaymentInfoType.CREDIT_CARD.equals((Object)paymentType);
    }

    private CyberSourceCardResponse callService(CyberSourceCardRequest cardRequest) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        CyberSourceCardResponse response;
        CyberSourcePaymentService service = (CyberSourcePaymentService)this.serviceManager.getValidService(cardRequest);
        try {
            response = (CyberSourceCardResponse)service.process(cardRequest);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        return response;
    }

    private PaymentResponseItem buildBasicResponse(CyberSourceCardResponse response) {
        PaymentResponseItemImpl responseItem = new PaymentResponseItemImpl();
        responseItem.setTransactionTimestamp(SystemTime.asDate());
        responseItem.setMiddlewareResponseCode(response.getReasonCode().toString());
        responseItem.setMiddlewareResponseText(response.getDecision());
        responseItem.setReferenceNumber(response.getMerchantReferenceCode());
        responseItem.setTransactionId(response.getRequestToken());
        responseItem.setTransactionSuccess(Boolean.valueOf(response.getReasonCode() == 100));
        responseItem.getAdditionalFields().put("requestId", response.getRequestID());
        responseItem.getAdditionalFields().put("requestToken", response.getRequestToken());
        return responseItem;
    }

    private void setCardInfo(PaymentContext paymentContext, CyberSourceCardRequest cardRequest) {
        CreditCardPaymentInfo ccInfo = (CreditCardPaymentInfo)paymentContext.getReferencedPaymentInfo();
        cardRequest.setAccountNumber(ccInfo.getPan());
        cardRequest.setExpirationMonth(ccInfo.getExpirationMonth());
        cardRequest.setExpirationYear(ccInfo.getExpirationYear());
        cardRequest.setCvNumber(ccInfo.getCvvCode());
    }

    private void setCurrency(PaymentContext paymentContext, CyberSourceCardRequest cardRequest) {
        Currency currency = paymentContext.getPaymentInfo().getAmount().getCurrency();
        if (currency == null) {
            currency = Money.defaultCurrency();
        }
        cardRequest.setCurrency(currency.getCurrencyCode());
    }

    private CyberSourceItemRequest createItemRequest(PaymentContext paymentContext) {
        CyberSourceItemRequest itemRequest = new CyberSourceItemRequest();
        itemRequest.setDescription("Order Charge");
        itemRequest.setQuantity(1L);
        itemRequest.setShortDescription("Order Charge");
        itemRequest.setUnitPrice(paymentContext.getPaymentInfo().getAmount());
        return itemRequest;
    }

    public CyberSourceServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(CyberSourceServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

