/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.cybersource.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CyberSourceServiceType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CyberSourceServiceType> TYPES = new HashMap<String, CyberSourceServiceType>();
    public static final CyberSourceServiceType PAYMENT = new CyberSourceServiceType("PAYMENT", "Payment");
    public static final CyberSourceServiceType TAX = new CyberSourceServiceType("TAX", "Tax");
    private String type;
    private String friendlyType;

    public static CyberSourceServiceType getInstance(String type) {
        return TYPES.get(type);
    }

    public CyberSourceServiceType() {
    }

    public CyberSourceServiceType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CyberSourceServiceType other = (CyberSourceServiceType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

