/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.broadleafcommerce.core.order.domain;

import java.util.List;
import java.util.Map;

import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.money.Money;

public interface DiscreteOrderItem extends OrderItem {

    Sku getSku();

    void setSku(Sku sku);

    Product getProduct();

    void setProduct(Product product);

    BundleOrderItem getBundleOrderItem();

    void setBundleOrderItem(BundleOrderItem bundleOrderItem);

    Money getTaxablePrice();

    public Map<String, String> getAdditionalAttributes();

	public void setAdditionalAttributes(Map<String, String> additionalAttributes);

	public Money getBaseRetailPrice();

	public void setBaseRetailPrice(Money baseRetailPrice);

	public Money getBaseSalePrice();

	public void setBaseSalePrice(Money baseSalePrice);
	
	public List<DiscreteOrderItemFeePrice> getDiscreteOrderItemFeePrices();

	public void setDiscreteOrderItemFeePrices(List<DiscreteOrderItemFeePrice> orderItemFeePrices);
}
