/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;

public class PromotableOrderItemAdjustmentImpl
implements PromotableOrderItemAdjustment {
    private static final long serialVersionUID = 1L;
    protected PromotableOrderItem orderItem;
    protected OrderItemAdjustment delegate;

    public PromotableOrderItemAdjustmentImpl(OrderItemAdjustment orderItemAdjustment, PromotableOrderItem orderItem) {
        this.delegate = orderItemAdjustment;
        this.orderItem = orderItem;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public OrderItemAdjustment getDelegate() {
        return this.delegate;
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.delegate.getOffer() != null && this.orderItem != null) {
            Money adjustmentPrice = this.orderItem.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.delegate.getOffer().getApplyDiscountToSalePrice() && this.orderItem.getSalePrice() != null ? this.orderItem.getSalePrice() : this.orderItem.getRetailPrice();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.delegate.setValue(new Money(this.delegate.getOffer().getValue()));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                this.delegate.setValue(adjustmentPrice.subtract(new Money(this.delegate.getOffer().getValue())));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                this.delegate.setValue(adjustmentPrice.multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"))));
            }
            if (adjustmentPrice.lessThan(this.delegate.getValue())) {
                this.delegate.setValue(adjustmentPrice);
            }
        }
    }

    @Override
    public Money getValue() {
        if (this.delegate.getValue() == null) {
            this.computeAdjustmentValue();
        }
        return this.delegate.getValue();
    }
}

