/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.AbstractBaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemSplitContainer;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.compass.core.util.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="blOrderOfferProcessor")
public class OrderOfferProcessorImpl
extends AbstractBaseProcessor
implements OrderOfferProcessor {
    private static final Log LOG = LogFactory.getLog(OrderOfferProcessorImpl.class);
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blCartService")
    protected CartService cartService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;

    @Override
    public void filterOrderLevelOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidatePromotionItems candidates;
        boolean orderLevelQualification;
        block6: {
            if (offer.getDiscountType().getType().equals(OfferDiscountType.FIX_PRICE.getType())) {
                LOG.warn((Object)("Offers of type ORDER may not have a discount type of FIX_PRICE. Ignoring order offer (name=" + offer.getName() + ")"));
                return;
            }
            orderLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, order)) {
                orderLevelQualification = true;
            } else {
                for (PromotableOrderItem discreteOrderItem : order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice())) {
                    if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem)) continue;
                    orderLevelQualification = true;
                    break block6;
                }
                for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                    if (!this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) continue;
                    orderLevelQualification = true;
                    break;
                }
            }
        }
        if (orderLevelQualification && (candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice()))).isMatchedQualifier()) {
            PromotableCandidateOrderOffer candidateOffer = this.createCandidateOrderOffer(order, qualifiedOrderOffers, offer);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    @Override
    public boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order) {
        return this.couldOfferApplyToOrder(offer, order, null, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem) {
        return this.couldOfferApplyToOrder(offer, order, discreteOrderItem, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableFulfillmentGroup fulfillmentGroup) {
        return this.couldOfferApplyToOrder(offer, order, null, fulfillmentGroup);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem, PromotableFulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        String rule = null;
        if (offer.getAppliesToOrderRules() != null && offer.getAppliesToOrderRules().trim().length() != 0) {
            rule = offer.getAppliesToOrderRules();
        } else {
            OfferRule orderRule = offer.getOfferMatchRules().get(OfferRuleType.ORDER.getType());
            if (orderRule != null) {
                rule = orderRule.getMatchRule();
            }
        }
        if (rule != null) {
            Boolean expressionOutcome;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("order", order.getDelegate());
            vars.put("offer", offer);
            if (fulfillmentGroup != null) {
                vars.put("fulfillmentGroup", fulfillmentGroup.getDelegate());
            }
            if (discreteOrderItem != null) {
                vars.put("discreteOrderItem", discreteOrderItem.getDelegate());
            }
            if ((expressionOutcome = this.executeExpression(rule, vars)) != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateOrderOffer createCandidateOrderOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidateOrderOffer candidateOffer = this.offerDao.createCandidateOrderOffer();
        candidateOffer.setOrder(order.getDelegate());
        candidateOffer.setOffer(offer);
        PromotableCandidateOrderOffer promotableCandidateOrderOffer = this.promotableItemFactory.createPromotableCandidateOrderOffer(candidateOffer, order);
        qualifiedOrderOffers.add(promotableCandidateOrderOffer);
        return promotableCandidateOrderOffer;
    }

    @Override
    public List<PromotableCandidateOrderOffer> removeTrailingNotCombinableOrderOffers(List<PromotableCandidateOrderOffer> candidateOffers) {
        ArrayList<PromotableCandidateOrderOffer> remainingCandidateOffers = new ArrayList<PromotableCandidateOrderOffer>();
        int offerCount = 0;
        for (PromotableCandidateOrderOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    @Override
    public boolean applyAllOrderOffers(List<PromotableCandidateOrderOffer> orderOffers, PromotableOrder order) {
        boolean orderOffersApplied = false;
        Iterator<PromotableCandidateOrderOffer> orderOfferIterator = orderOffers.iterator();
        while (orderOfferIterator.hasNext()) {
            PromotableCandidateOrderOffer orderOffer = orderOfferIterator.next();
            if (orderOffer.getOffer().getTreatAsNewFormat() == null || !orderOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                if (!orderOffer.getOffer().isStackable() && order.isHasOrderAdjustments()) continue;
                boolean alreadyContainsNotCombinableOfferAtAnyLevel = order.isNotCombinableOfferAppliedAtAnyLevel();
                this.applyOrderOffer(order, orderOffer);
                orderOffersApplied = true;
                if (orderOffer.getOffer().isCombinableWithOtherOffers() && !alreadyContainsNotCombinableOfferAtAnyLevel) continue;
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (order.containsNotStackableOrderOffer() && order.isHasOrderAdjustments()) continue;
            boolean alreadyContainsTotalitarianOffer = order.isTotalitarianOfferApplied();
            this.applyOrderOffer(order, orderOffer);
            orderOffersApplied = true;
            if (orderOffer.getOffer().isTotalitarianOffer() != null && orderOffer.getOffer().isTotalitarianOffer().booleanValue() || alreadyContainsTotalitarianOffer) {
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (orderOffer.getOffer().isCombinableWithOtherOffers()) continue;
            break;
        }
        return orderOffersApplied;
    }

    @Override
    public void initializeSplitItems(PromotableOrder order, List<PromotableOrderItem> items) {
        for (PromotableOrderItem item : items) {
            ArrayList<PromotableOrderItem> temp = new ArrayList<PromotableOrderItem>();
            temp.add(item);
            OrderItemSplitContainer container = new OrderItemSplitContainer();
            container.setKey(item.getDelegate());
            container.setSplitItems(temp);
            order.getSplitItems().add(container);
        }
    }

    protected boolean compareAndAdjustOrderAndItemOffers(PromotableOrder order, boolean orderOffersApplied) {
        if (order.getAdjustmentPrice().greaterThanOrEqual(order.calculateOrderItemsCurrentPrice())) {
            order.removeAllOrderAdjustments();
            orderOffersApplied = false;
        } else {
            order.removeAllItemAdjustments();
            this.gatherCart(order);
            this.initializeSplitItems(order, order.getDiscountableDiscreteOrderItems());
        }
        return orderOffersApplied;
    }

    @Override
    public void gatherCart(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getDelegate();
        ArrayList<OrderItem> itemsToRemove = new ArrayList<OrderItem>();
        HashMap gatherMap = new HashMap();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherMap.get(group);
            if (gatheredItem == null) {
                gatheredItem = new HashMap<String, Object[]>();
                gatherMap.put(group.getId(), gatheredItem);
            }
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) continue;
                Object[] gatheredOrderItem = (Object[])gatheredItem.get(orderItem.getName());
                if (gatheredOrderItem == null) {
                    gatheredItem.put(orderItem.getName(), new Object[]{orderItem, fgItem});
                    continue;
                }
                ((OrderItem)gatheredOrderItem[0]).setQuantity(((OrderItem)gatheredOrderItem[0]).getQuantity() + orderItem.getQuantity());
                ((FulfillmentGroupItem)gatheredOrderItem[1]).setQuantity(((FulfillmentGroupItem)gatheredOrderItem[1]).getQuantity() + fgItem.getQuantity());
                itemsToRemove.add(orderItem);
            }
        }
        try {
            for (Map values : gatherMap.values()) {
                for (Object[] item : values.values()) {
                    this.orderItemService.saveOrderItem((OrderItem)item[0]);
                    this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
                }
            }
            for (OrderItem orderItem : itemsToRemove) {
                this.cartService.removeItemFromOrder(order, orderItem, false);
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not gather the cart", e);
        }
    }

    protected void applyOrderOffer(PromotableOrder order, PromotableCandidateOrderOffer orderOffer) {
        OrderAdjustment orderAdjustment = this.offerDao.createOrderAdjustment();
        orderAdjustment.init(order.getDelegate(), orderOffer.getOffer(), orderOffer.getOffer().getName());
        PromotableOrderAdjustment promotableOrderAdjustment = this.promotableItemFactory.createPromotableOrderAdjustment(orderAdjustment, order);
        order.addOrderAdjustments(promotableOrderAdjustment);
    }

    protected void mergeSplitItems(PromotableOrder order) {
        ArrayList<PromotableOrderItem> itemsToRemove = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem nextItem : order.getDiscountableDiscreteOrderItems()) {
            List<PromotableOrderItem> mySplits = order.searchSplitItems(nextItem);
            if (CollectionUtils.isEmpty(mySplits)) continue;
            if (mySplits.size() == 1 && mySplits.contains(nextItem)) {
                mySplits.remove(nextItem);
                continue;
            }
            PromotableOrderItem cloneItem = nextItem.clone();
            cloneItem.clearAllDiscount();
            cloneItem.clearAllQualifiers();
            cloneItem.removeAllAdjustments();
            cloneItem.setQuantity(0);
            Iterator<PromotableOrderItem> splitItemIterator = mySplits.iterator();
            while (splitItemIterator.hasNext()) {
                PromotableOrderItem splitItem = splitItemIterator.next();
                if (splitItem.isHasOrderItemAdjustments()) continue;
                cloneItem.setQuantity(cloneItem.getQuantity() + splitItem.getQuantity());
                splitItemIterator.remove();
            }
            if (cloneItem.getQuantity() > 0) {
                mySplits.add(cloneItem);
            }
            if (mySplits.contains(nextItem)) {
                mySplits.remove(nextItem);
                continue;
            }
            itemsToRemove.add(nextItem);
        }
        try {
            for (OrderItemSplitContainer key : order.getSplitItems()) {
                List<PromotableOrderItem> mySplits = key.getSplitItems();
                if (CollectionUtils.isEmpty(mySplits)) continue;
                PromotableFulfillmentGroup targetGroup = null;
                block5: for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
                    for (FulfillmentGroupItem fgItem : fg.getDelegate().getFulfillmentGroupItems()) {
                        if (!fgItem.getOrderItem().equals(key.getKey())) continue;
                        targetGroup = fg;
                        break block5;
                    }
                }
                for (PromotableOrderItem myItem : mySplits) {
                    DiscreteOrderItem delegateItem = myItem.getDelegate();
                    if (delegateItem.getBundleOrderItem() == null) {
                        delegateItem = (DiscreteOrderItem)this.cartService.addOrderItemToOrder(order.getDelegate(), delegateItem, false);
                        this.cartService.addItemToFulfillmentGroup((OrderItem)delegateItem, targetGroup.getDelegate(), false);
                        continue;
                    }
                    delegateItem = (DiscreteOrderItem)this.cartService.addOrderItemToBundle(order.getDelegate(), delegateItem.getBundleOrderItem(), delegateItem, false);
                }
            }
            for (PromotableOrderItem orderItem : itemsToRemove) {
                DiscreteOrderItem delegateItem = orderItem.getDelegate();
                if (delegateItem.getBundleOrderItem() == null) {
                    this.cartService.removeItemFromOrder(order.getDelegate(), orderItem.getDelegate(), false);
                    continue;
                }
                this.cartService.removeItemFromBundle(order.getDelegate(), delegateItem.getBundleOrderItem(), orderItem.getDelegate(), false);
            }
            order.resetDiscreteOrderItems();
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not propagate the items split by the promotion engine into the order", e);
        }
    }

    @Override
    public void compileOrderTotal(PromotableOrder order) {
        order.assignOrderItemsFinalPrice();
        order.setSubTotal(order.calculateOrderItemsFinalPrice(true));
    }

    @Override
    public OfferDao getOfferDao() {
        return this.offerDao;
    }

    @Override
    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }

    @Override
    public CartService getCartService() {
        return this.cartService;
    }

    @Override
    public void setCartService(CartService cartService) {
        this.cartService = cartService;
    }

    @Override
    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    @Override
    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    @Override
    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }
}

