/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blFulfillmentGroupDao")
public class FulfillmentGroupDaoImpl
implements FulfillmentGroupDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public FulfillmentGroup save(FulfillmentGroup fulfillmentGroup) {
        return (FulfillmentGroup)this.em.merge((Object)fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup readFulfillmentGroupById(Long fulfillmentGroupId) {
        return (FulfillmentGroup)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.order.domain.FulfillmentGroup"), (Object)fulfillmentGroupId);
    }

    @Override
    public FulfillmentGroupImpl readDefaultFulfillmentGroupForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_DEFAULT_FULFILLMENT_GROUP_BY_ORDER_ID");
        query.setParameter("orderId", (Object)order.getId());
        List fulfillmentGroups = query.getResultList();
        return fulfillmentGroups == null || fulfillmentGroups.isEmpty() ? null : (FulfillmentGroupImpl)fulfillmentGroups.get(0);
    }

    @Override
    public void delete(FulfillmentGroup fulfillmentGroup) {
        if (!this.em.contains((Object)fulfillmentGroup)) {
            fulfillmentGroup = this.readFulfillmentGroupById(fulfillmentGroup.getId());
        }
        this.em.remove((Object)fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup createDefault() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.FulfillmentGroup");
        fg.setPrimary(true);
        fg.setType(FulfillmentGroupType.SHIPPING);
        return fg;
    }

    @Override
    public FulfillmentGroup create() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.FulfillmentGroup");
        fg.setType(FulfillmentGroupType.SHIPPING);
        return fg;
    }
}

