/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.ProductDimension;
import org.broadleafcommerce.core.catalog.domain.ProductWeight;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.media.domain.Media;
import org.broadleafcommerce.core.media.domain.MediaImpl;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.presentation.RequiredOverride;
import org.broadleafcommerce.profile.util.DateUtil;
import org.broadleafcommerce.profile.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.profile.vendor.service.type.ContainerSizeType;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.compass.annotations.SupportUnmarshall;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@Searchable(alias="product", supportUnmarshall=SupportUnmarshall.FALSE)
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseProduct")
public class ProductImpl
implements Product {
    private static final Log LOG = LogFactory.getLog(ProductImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductId")
    @GenericGenerator(name="ProductId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="ProductImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductImpl")})
    @Column(name="PRODUCT_ID")
    @SearchableId
    @AdminPresentation(friendlyName="Product ID", group="Primary Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="NAME", nullable=false)
    @SearchableProperty(name="productName")
    @Index(name="PRODUCT_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="Product Name", order=1, group="Product Description", prominent=true, columnWidth="25%", groupOrder=1)
    protected String name;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="Product Description", order=2, group="Product Description", prominent=false, largeEntry=true, groupOrder=1)
    protected String description;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="LONG_DESCRIPTION")
    @SearchableProperty(name="productDescription")
    @AdminPresentation(friendlyName="Product Long Description", order=3, group="Product Description", prominent=false, largeEntry=true, groupOrder=1)
    protected String longDescription;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="Product Active Start Date", order=8, group="Active Date Range", groupOrder=2)
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @AdminPresentation(friendlyName="Product Active End Date", order=9, group="Active Date Range", groupOrder=2)
    protected Date activeEndDate;
    @Column(name="MODEL")
    @SearchableProperty(name="productModel")
    @AdminPresentation(friendlyName="Product Model", order=4, group="Product Description", prominent=true, groupOrder=1)
    protected String model;
    @Column(name="MANUFACTURE")
    @SearchableProperty(name="productManufacturer")
    @AdminPresentation(friendlyName="Product Manufacturer", order=5, group="Product Description", prominent=true, groupOrder=1)
    protected String manufacturer;
    @Embedded
    protected ProductDimension dimension = new ProductDimension();
    @Embedded
    protected ProductWeight weight = new ProductWeight();
    @Column(name="IS_FEATURED_PRODUCT", nullable=false)
    @AdminPresentation(friendlyName="Is Featured Product", order=6, group="Product Description", prominent=false)
    protected boolean isFeaturedProduct = false;
    @Column(name="IS_MACHINE_SORTABLE")
    @AdminPresentation(friendlyName="Is Product Machine Sortable", order=7, group="Product Description", prominent=false)
    protected boolean isMachineSortable = true;
    @Transient
    protected List<Sku> skus = new ArrayList<Sku>();
    @Transient
    protected String promoMessage;
    @OneToMany(mappedBy="product", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="product", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @OrderBy(value="sequence")
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class)
    @JoinTable(name="BLC_PRODUCT_SKU_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Sku> allSkus = new ArrayList<Sku>();
    @CollectionOfElements
    @JoinTable(name="BLC_PRODUCT_IMAGE", joinColumns={@JoinColumn(name="PRODUCT_ID")})
    @MapKey(columns={@Column(name="NAME", length=5, nullable=false)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @Deprecated
    protected Map<String, String> productImages = new HashMap<String, String>();
    @ManyToMany(targetEntity=MediaImpl.class)
    @JoinTable(name="BLC_PRODUCT_MEDIA_MAP", inverseJoinColumns={@JoinColumn(name="MEDIA_ID", referencedColumnName="MEDIA_ID")})
    @MapKey(columns={@Column(name="MAP_KEY", nullable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected Map<String, Media> productMedia = new HashMap<String, Media>();
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_CATEGORY_ID")
    @Index(name="PRODUCT_CATEGORY_INDEX", columnNames={"DEFAULT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="Product Default Category", order=6, group="Product Description", excluded=true, requiredOverride=RequiredOverride.REQUIRED)
    protected Category defaultCategory;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=CategoryImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="BLC_CATEGORY_PRODUCT_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", referencedColumnName="CATEGORY_ID", nullable=true)})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Category> allParentCategories = new ArrayList<Category>();
    @OneToMany(mappedBy="product", targetEntity=ProductAttributeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<ProductAttribute> productAttributes = new ArrayList<ProductAttribute>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
            LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true);
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public ProductDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(ProductDimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public BigDecimal getWidth() {
        return this.dimension == null ? null : this.dimension.getWidth();
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.dimension.setWidth(width);
    }

    @Override
    public BigDecimal getHeight() {
        return this.dimension == null ? null : this.dimension.getHeight();
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.dimension.setHeight(height);
    }

    @Override
    public BigDecimal getDepth() {
        return this.dimension == null ? null : this.dimension.getDepth();
    }

    @Override
    public void setDepth(BigDecimal depth) {
        this.dimension.setDepth(depth);
    }

    @Override
    public void setGirth(BigDecimal girth) {
        this.dimension.setGirth(girth);
    }

    @Override
    public BigDecimal getGirth() {
        return this.dimension == null ? null : this.dimension.getGirth();
    }

    @Override
    public ContainerSizeType getSize() {
        return this.dimension == null ? null : this.dimension.getSize();
    }

    @Override
    public void setSize(ContainerSizeType size) {
        this.dimension.setSize(size);
    }

    @Override
    public ContainerShapeType getContainer() {
        return this.dimension == null ? null : this.dimension.getContainer();
    }

    @Override
    public void setContainer(ContainerShapeType container) {
        this.dimension.setContainer(container);
    }

    @Override
    public String getDimensionString() {
        return this.dimension == null ? null : this.dimension.getDimensionString();
    }

    @Override
    public boolean isFeaturedProduct() {
        return this.isFeaturedProduct;
    }

    @Override
    public void setFeaturedProduct(boolean isFeaturedProduct) {
        this.isFeaturedProduct = isFeaturedProduct;
    }

    @Override
    public boolean isMachineSortable() {
        return this.isMachineSortable;
    }

    @Override
    public void setMachineSortable(boolean isMachineSortable) {
        this.isMachineSortable = isMachineSortable;
    }

    @Override
    public ProductWeight getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(ProductWeight weight) {
        this.weight = weight;
    }

    @Override
    public String getPromoMessage() {
        return this.promoMessage;
    }

    @Override
    public void setPromoMessage(String promoMessage) {
        this.promoMessage = promoMessage;
    }

    @Override
    public List<Sku> getAllSkus() {
        return this.allSkus;
    }

    @Override
    public List<Sku> getSkus() {
        if (this.skus.size() == 0) {
            List<Sku> allSkus = this.getAllSkus();
            for (Sku sku : allSkus) {
                if (!sku.isActive()) continue;
                this.skus.add(sku);
            }
        }
        return this.skus;
    }

    @Override
    public void setAllSkus(List<Sku> skus) {
        this.allSkus.clear();
        for (Sku sku : skus) {
            this.allSkus.add(sku);
        }
    }

    @Override
    @Deprecated
    public Map<String, String> getProductImages() {
        return this.productImages;
    }

    @Override
    @Deprecated
    public String getProductImage(String imageKey) {
        return this.productImages.get(imageKey);
    }

    @Override
    @Deprecated
    public void setProductImages(Map<String, String> productImages) {
        this.productImages.clear();
        for (Map.Entry<String, String> me : productImages.entrySet()) {
            this.productImages.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public Map<String, Media> getProductMedia() {
        return this.productMedia;
    }

    @Override
    public void setProductMedia(Map<String, Media> productMedia) {
        this.productMedia.clear();
        for (Map.Entry<String, Media> me : productMedia.entrySet()) {
            this.productMedia.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public List<Category> getAllParentCategories() {
        return this.allParentCategories;
    }

    @Override
    public void setAllParentCategories(List<Category> allParentCategories) {
        this.allParentCategories.clear();
        for (Category category : allParentCategories) {
            this.allParentCategories.add(category);
        }
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        return this.crossSaleProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts.clear();
        for (RelatedProduct relatedProduct : crossSaleProducts) {
            this.crossSaleProducts.add(relatedProduct);
        }
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        return this.upSaleProducts;
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts.clear();
        for (RelatedProduct relatedProduct : upSaleProducts) {
            this.upSaleProducts.add(relatedProduct);
        }
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public List<ProductAttribute> getProductAttributes() {
        return this.productAttributes;
    }

    @Override
    public void setProductAttributes(List<ProductAttribute> productAttributes) {
        this.productAttributes = productAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.skus == null ? 0 : ((Object)this.skus).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductImpl other = (ProductImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.skus == null ? other.skus != null : !((Object)this.skus).equals(other.skus));
    }
}

