/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.money.Money;

public class PromotableFulfillmentGroupAdjustmentImpl
implements PromotableFulfillmentGroupAdjustment {
    private static final long serialVersionUID = 1L;
    protected PromotableFulfillmentGroup fulfillmentGroup;
    protected FulfillmentGroupAdjustment delegate;

    public PromotableFulfillmentGroupAdjustmentImpl(FulfillmentGroupAdjustment fulfillmentGroupAdjustment, PromotableFulfillmentGroup fulfillmentGroup) {
        this.delegate = fulfillmentGroupAdjustment;
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public FulfillmentGroupAdjustment getDelegate() {
        return this.delegate;
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.getOffer() != null && this.fulfillmentGroup != null) {
            BigDecimal offerValue;
            Money adjustmentPrice = this.fulfillmentGroup.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.getOffer().getApplyDiscountToSalePrice() && this.fulfillmentGroup.getSaleShippingPrice() != null ? this.fulfillmentGroup.getSaleShippingPrice() : this.fulfillmentGroup.getRetailShippingPrice();
            }
            if (this.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.setValue(new Money(this.delegate.getOffer().getValue(), adjustmentPrice.getCurrency(), 5));
            }
            if (this.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                offerValue = adjustmentPrice.getAmount().subtract(this.delegate.getOffer().getValue());
                this.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (this.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                offerValue = adjustmentPrice.getAmount().multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
                this.setValue(new Money(offerValue, adjustmentPrice.getCurrency(), 5));
            }
            if (adjustmentPrice.lessThan(this.getValue())) {
                this.setValue(adjustmentPrice);
            }
        }
    }

    public Long getId() {
        return this.delegate.getId();
    }

    public void setId(Long id) {
        this.delegate.setId(id);
    }

    public Offer getOffer() {
        return this.delegate.getOffer();
    }

    public FulfillmentGroup getFulfillmentGroup() {
        return this.delegate.getFulfillmentGroup();
    }

    public String getReason() {
        return this.delegate.getReason();
    }

    public void setReason(String reason) {
        this.delegate.setReason(reason);
    }

    public void init(FulfillmentGroup fulfillmentGroup, Offer offer, String reason) {
        this.delegate.init(fulfillmentGroup, offer, reason);
    }

    public void setValue(Money value) {
        this.delegate.setValue(value);
    }

    @Override
    public Money getValue() {
        if (this.delegate.getValue() == null || this.delegate.getValue().equals((Object)Money.ZERO)) {
            this.computeAdjustmentValue();
        }
        return this.delegate.getValue();
    }
}

