/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.BaseProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.hibernate.tool.hbm2x.StringUtils;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class AbstractBaseProcessor
implements BaseProcessor {
    private static final Log LOG = LogFactory.getLog(AbstractBaseProcessor.class);
    private static final Map EXPRESSION_CACHE = new LRUMap(1000);

    protected CandidatePromotionItems couldOfferApplyToOrderItems(Offer offer, List<PromotableOrderItem> promotableOrderItems) {
        CandidatePromotionItems candidates = new CandidatePromotionItems();
        if (offer.getQualifyingItemCriteria() == null || offer.getQualifyingItemCriteria().size() == 0) {
            candidates.setMatchedQualifier(true);
        } else {
            for (OfferItemCriteria criteria : offer.getQualifyingItemCriteria()) {
                this.checkForItemRequirements(candidates, criteria, promotableOrderItems, true);
                if (candidates.isMatchedQualifier()) continue;
                break;
            }
        }
        if (offer.getType().equals(OfferType.ORDER_ITEM)) {
            this.checkForItemRequirements(candidates, offer.getTargetItemCriteria(), promotableOrderItems, false);
        }
        return candidates;
    }

    protected void checkForItemRequirements(CandidatePromotionItems candidates, OfferItemCriteria criteria, List<PromotableOrderItem> promotableOrderItems, boolean isQualifier) {
        boolean matchFound = false;
        int criteriaQuantity = criteria.getQuantity();
        if (criteriaQuantity > 0) {
            for (PromotableOrderItem item : promotableOrderItems) {
                if (!this.couldOrderItemMeetOfferRequirement(criteria, item)) continue;
                if (isQualifier) {
                    candidates.addQualifier(criteria, item);
                } else {
                    candidates.addTarget(item);
                }
                matchFound = true;
            }
        }
        if (isQualifier) {
            candidates.setMatchedQualifier(matchFound);
        } else {
            candidates.setMatchedTarget(matchFound);
        }
    }

    protected boolean couldOrderItemMeetOfferRequirement(OfferItemCriteria criteria, PromotableOrderItem discreteOrderItem) {
        boolean appliesToItem = false;
        if (criteria.getOrderItemMatchRule() != null && criteria.getOrderItemMatchRule().trim().length() != 0) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("discreteOrderItem", discreteOrderItem.getDelegate());
            Boolean expressionOutcome = this.executeExpression(criteria.getOrderItemMatchRule(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean executeExpression(String expression, Map<String, Object> vars) {
        try {
            Serializable exp;
            Map map = EXPRESSION_CACHE;
            synchronized (map) {
                exp = (Serializable)EXPRESSION_CACHE.get(expression);
                if (exp == null) {
                    ParserContext context = new ParserContext();
                    context.addImport("OfferType", OfferType.class);
                    context.addImport("FulfillmentGroupType", FulfillmentGroupType.class);
                    context.addImport("MVEL", MVEL.class);
                    exp = MVEL.compileExpression((String)expression, (ParserContext)context);
                    EXPRESSION_CACHE.put(expression, exp);
                }
            }
            Object test = MVEL.executeExpression((Object)exp, vars);
            return (Boolean)test;
        }
        catch (Exception e) {
            LOG.info((Object)"Unable to parse and/or execute an mvel expression. Reporting to the logs and returning false for the match expression", (Throwable)e);
            return false;
        }
    }

    protected void clearAllNonFinalizedQuantities(List<PromotableOrderItem> chargeableItems) {
        for (PromotableOrderItem chargeableItem : chargeableItems) {
            chargeableItem.clearAllNonFinalizedQuantities();
        }
    }

    protected void finalizeQuantities(List<PromotableOrderItem> chargeableItems) {
        for (PromotableOrderItem chargeableItem : chargeableItems) {
            chargeableItem.finalizeQuantities();
        }
    }

    @Override
    public void clearOffersandAdjustments(PromotableOrder order) {
        order.removeAllCandidateOffers();
        order.removeAllAdjustments();
    }

    @Override
    public List<Offer> filterOffers(List<Offer> offers, Customer customer) {
        List<Offer> filteredOffers = new ArrayList<Offer>();
        if (offers != null && !offers.isEmpty()) {
            filteredOffers = this.removeOutOfDateOffers(offers);
            filteredOffers = this.removeInvalidCustomerOffers(filteredOffers, customer);
        }
        return filteredOffers;
    }

    protected List<Offer> removeOutOfDateOffers(List<Offer> offers) {
        Date now = SystemTime.asDate();
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (offer.getStartDate() == null || offer.getStartDate().after(now)) {
                offersToRemove.add(offer);
                continue;
            }
            if (offer.getEndDate() == null || !offer.getEndDate().before(now)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected List<Offer> removeInvalidCustomerOffers(List<Offer> offers, Customer customer) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToCustomer(offer, customer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToCustomer(Offer offer, Customer customer) {
        boolean appliesToCustomer = false;
        String rule = null;
        if (!StringUtils.isEmpty((String)offer.getAppliesToCustomerRules())) {
            rule = offer.getAppliesToCustomerRules();
        } else {
            OfferRule customerRule = offer.getOfferMatchRules().get(OfferRuleType.CUSTOMER.getType());
            if (customerRule != null) {
                rule = customerRule.getMatchRule();
            }
        }
        if (rule != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("customer", customer);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToCustomer = true;
            }
        } else {
            appliesToCustomer = true;
        }
        return appliesToCustomer;
    }
}

