/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.util.domain.CodeType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="BLC_CODE_TYPES")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class CodeTypeImpl
implements CodeType {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CodeTypeId", strategy=GenerationType.TABLE)
    @TableGenerator(name="CodeTypeId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="CodeTypeId", allocationSize=50)
    @Column(name="CODE_ID")
    protected Long id;
    @Column(name="CODE_TYPE", nullable=false)
    protected String codeType;
    @Column(name="CODE_KEY", nullable=false)
    protected String key;
    @Column(name="CODE_DESC")
    protected String description;
    @Column(name="MODIFIABLE")
    protected Character modifiable;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getCodeType() {
        return this.codeType;
    }

    @Override
    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Boolean isModifiable() {
        if (this.modifiable == null) {
            return null;
        }
        return this.modifiable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean getModifiable() {
        return this.isModifiable();
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.modifiable = modifiable == null ? null : Character.valueOf(modifiable != false ? (char)'Y' : 'N');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codeType == null ? 0 : this.codeType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.modifiable == null ? 0 : this.modifiable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeTypeImpl other = (CodeTypeImpl)obj;
        if (this.codeType == null ? other.codeType != null : !this.codeType.equals(other.codeType)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.modifiable == null ? other.modifiable != null : !this.modifiable.equals(other.modifiable));
    }
}

