/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.module;

import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.exception.TaxException;
import org.broadleafcommerce.core.pricing.service.module.TaxModule;

public class SimpleTaxModule
implements TaxModule {
    public static final String MODULENAME = "simpleTaxModule";
    protected String name = "simpleTaxModule";
    protected Double factor;

    @Override
    public Order calculateTaxForOrder(Order order) throws TaxException {
        Money subTotal = order.calculateOrderItemsFinalPrice(false);
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupFee fulfillmentGroupFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                if (!fulfillmentGroupFee.isTaxable().booleanValue()) continue;
                subTotal = subTotal.add(fulfillmentGroupFee.getAmount());
            }
        }
        Money totalTax = subTotal.multiply(this.factor.doubleValue());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            Money fgTotalTax = fulfillmentGroup.isShippingPriceTaxable() == null || fulfillmentGroup.isShippingPriceTaxable() != false ? fulfillmentGroup.getShippingPrice().multiply(this.factor.doubleValue()) : new Money(0.0);
            fulfillmentGroup.setTotalTax(fgTotalTax);
            fulfillmentGroup.setCityTax(new Money(0.0));
            fulfillmentGroup.setStateTax(new Money(0.0));
            fulfillmentGroup.setDistrictTax(new Money(0.0));
            fulfillmentGroup.setCountyTax(new Money(0.0));
            fulfillmentGroup.setCountryTax(new Money(0.0));
            totalTax = totalTax.add(fgTotalTax);
        }
        order.setCityTax(new Money(0.0));
        order.setStateTax(new Money(0.0));
        order.setDistrictTax(new Money(0.0));
        order.setCountyTax(new Money(0.0));
        order.setCountryTax(new Money(0.0));
        order.setTotalTax(totalTax);
        return order;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Double getFactor() {
        return this.factor;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }
}

