/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;

public class OfferDataItemProvider {
    public static Long orderItemId = 1L;

    public static Long getOrderItemId() {
        Long l = orderItemId;
        Long l2 = orderItemId = Long.valueOf(orderItemId + 1L);
        return l;
    }

    public static IAnswer<FulfillmentGroup> getAddItemToFulfillmentGroupAnswer() {
        return new IAnswer<FulfillmentGroup>(){

            public FulfillmentGroup answer() throws Throwable {
                FulfillmentGroup fg = (FulfillmentGroup)EasyMock.getCurrentArguments()[1];
                FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
                fgItem.setOrderItem((OrderItem)EasyMock.getCurrentArguments()[0]);
                fgItem.setQuantity(((OrderItem)EasyMock.getCurrentArguments()[0]).getQuantity());
                fg.getFulfillmentGroupItems().add(fgItem);
                return fg;
            }
        };
    }

    public static IAnswer<OrderItem> getAddOrderItemToOrderAnswer() {
        return new IAnswer<OrderItem>(){

            public OrderItem answer() throws Throwable {
                Order order = (Order)EasyMock.getCurrentArguments()[0];
                order.getOrderItems().add((OrderItem)EasyMock.getCurrentArguments()[1]);
                if (((OrderItem)EasyMock.getCurrentArguments()[1]).getId() == null) {
                    ((OrderItem)EasyMock.getCurrentArguments()[1]).setId(OfferDataItemProvider.getOrderItemId());
                }
                return (OrderItem)EasyMock.getCurrentArguments()[1];
            }
        };
    }

    public static IAnswer<OrderItem> getSaveOrderItemAnswer() {
        return new IAnswer<OrderItem>(){

            public OrderItem answer() throws Throwable {
                return (OrderItem)EasyMock.getCurrentArguments()[0];
            }
        };
    }

    public static IAnswer<FulfillmentGroupItem> getSaveFulfillmentGroupItemAnswer() {
        return new IAnswer<FulfillmentGroupItem>(){

            public FulfillmentGroupItem answer() throws Throwable {
                return (FulfillmentGroupItem)EasyMock.getCurrentArguments()[0];
            }
        };
    }

    public static IAnswer<Order> getRemoveItemFromOrderAnswer() {
        return new IAnswer<Order>(){

            public Order answer() throws Throwable {
                Order order = (Order)EasyMock.getCurrentArguments()[0];
                order.getOrderItems().remove((OrderItem)EasyMock.getCurrentArguments()[1]);
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    Iterator itr = fg.getFulfillmentGroupItems().iterator();
                    while (itr.hasNext()) {
                        if (!((FulfillmentGroupItem)itr.next()).getOrderItem().equals((OrderItem)EasyMock.getCurrentArguments()[1])) continue;
                        itr.remove();
                    }
                }
                return order;
            }
        };
    }

    public PromotableOrder createBasicOrder() {
        OrderImpl order = new OrderImpl();
        CategoryImpl category1 = new CategoryImpl();
        category1.setName("test1");
        category1.setId(Long.valueOf(1L));
        ProductImpl product1 = new ProductImpl();
        product1.setName("test1");
        SkuImpl sku1 = new SkuImpl();
        sku1.setName("test1");
        sku1.setId(Long.valueOf(1L));
        sku1.setDiscountable(Boolean.valueOf(true));
        sku1.setRetailPrice(new Money(19.99));
        product1.getAllSkus().add(sku1);
        category1.getAllProducts().add(product1);
        CategoryImpl category2 = new CategoryImpl();
        category2.setName("test2");
        category2.setId(Long.valueOf(2L));
        ProductImpl product2 = new ProductImpl();
        product2.setName("test2");
        SkuImpl sku2 = new SkuImpl();
        sku2.setName("test2");
        sku2.setId(Long.valueOf(2L));
        sku2.setDiscountable(Boolean.valueOf(true));
        sku2.setRetailPrice(new Money(29.99));
        product2.getAllSkus().add(sku2);
        category2.getAllProducts().add(product2);
        DiscreteOrderItemImpl orderItem1 = new DiscreteOrderItemImpl();
        orderItem1.setCategory((Category)category1);
        orderItem1.setName("test1");
        orderItem1.setOrder((Order)order);
        orderItem1.setOrderItemType(OrderItemType.DISCRETE);
        orderItem1.setProduct((Product)product1);
        orderItem1.setQuantity(2);
        orderItem1.setSku((Sku)sku1);
        orderItem1.setRetailPrice(new Money(19.99));
        orderItem1.setPrice(new Money(19.99));
        orderItem1.setId(OfferDataItemProvider.getOrderItemId());
        order.getOrderItems().add(orderItem1);
        DiscreteOrderItemImpl orderItem2 = new DiscreteOrderItemImpl();
        orderItem2.setCategory((Category)category2);
        orderItem2.setName("test2");
        orderItem2.setOrder((Order)order);
        orderItem2.setOrderItemType(OrderItemType.DISCRETE);
        orderItem2.setProduct((Product)product2);
        orderItem2.setQuantity(3);
        orderItem2.setSku((Sku)sku2);
        orderItem2.setRetailPrice(new Money(29.99));
        orderItem2.setPrice(new Money(29.99));
        orderItem2.setId(OfferDataItemProvider.getOrderItemId());
        order.getOrderItems().add(orderItem2);
        CustomerImpl customer = new CustomerImpl();
        customer.setEmailAddress("test@test.com");
        customer.setFirstName("John");
        customer.setLastName("Tester");
        customer.setReceiveEmail(true);
        customer.setRegistered(true);
        order.setCustomer((Customer)customer);
        order.setEmailAddress("test@test.com");
        FulfillmentGroupImpl fg1 = new FulfillmentGroupImpl();
        fg1.setId(Long.valueOf(1L));
        AddressImpl address1 = new AddressImpl();
        address1.setAddressLine1("123 Test Road");
        address1.setCity("Dallas");
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        address1.setCountry((Country)country);
        address1.setDefault(true);
        address1.setFirstName("John");
        address1.setLastName("Tester");
        address1.setPostalCode("75244");
        address1.setPrimaryPhone("972-976-1234");
        StateImpl state = new StateImpl();
        state.setAbbreviation("TX");
        state.setCountry((Country)country);
        state.setName("Texas");
        address1.setState((State)state);
        fg1.setAddress((Address)address1);
        fg1.setOrder((Order)order);
        fg1.setPrimary(true);
        fg1.setRetailShippingPrice(new Money(10.0));
        fg1.setShippingPrice(new Money(10.0));
        fg1.setType(FulfillmentGroupType.SHIPPING);
        FulfillmentGroupItemImpl fgItem1 = new FulfillmentGroupItemImpl();
        fgItem1.setFulfillmentGroup((FulfillmentGroup)fg1);
        fgItem1.setOrderItem((OrderItem)orderItem1);
        fgItem1.setQuantity(2);
        fg1.getFulfillmentGroupItems().add(fgItem1);
        order.getFulfillmentGroups().add(fg1);
        FulfillmentGroupImpl fg2 = new FulfillmentGroupImpl();
        fg2.setId(Long.valueOf(2L));
        AddressImpl address2 = new AddressImpl();
        address2.setAddressLine1("124 Test Road");
        address2.setCity("Dallas");
        CountryImpl country2 = new CountryImpl();
        country2.setAbbreviation("US");
        country2.setName("United States");
        address2.setCountry((Country)country2);
        address2.setDefault(true);
        address2.setFirstName("John");
        address2.setLastName("Tester");
        address2.setPostalCode("75244");
        address2.setPrimaryPhone("972-976-1234");
        StateImpl state2 = new StateImpl();
        state2.setAbbreviation("TX");
        state2.setCountry((Country)country2);
        state2.setName("Texas");
        address2.setState((State)state2);
        fg2.setAddress((Address)address2);
        fg2.setOrder((Order)order);
        fg2.setPrimary(true);
        fg2.setRetailShippingPrice(new Money(20.0));
        fg2.setShippingPrice(new Money(20.0));
        fg2.setType(FulfillmentGroupType.SHIPPING);
        FulfillmentGroupItemImpl fgItem2 = new FulfillmentGroupItemImpl();
        fgItem2.setFulfillmentGroup((FulfillmentGroup)fg2);
        fgItem2.setOrderItem((OrderItem)orderItem2);
        fgItem2.setQuantity(3);
        fg2.getFulfillmentGroupItems().add(fgItem2);
        order.getFulfillmentGroups().add(fg2);
        order.setSubTotal(new Money(129.95));
        PromotableOrderImpl promotableOrder = new PromotableOrderImpl((Order)order, (PromotableItemFactory)new PromotableItemFactoryImpl());
        return promotableOrder;
    }

    public Offer createOffer(String appliesToCustomerRules, String appliesToFulfillmentGroupRules, String appliesToRules, boolean applyToSalePrice, boolean combinableWithOtherOffers, OfferDeliveryType deliveryType, OfferDiscountType type, Date endDate, int maxUses, OfferItemRestrictionRuleType qualifierType, OfferItemRestrictionRuleType targetType, int priority, Set<OfferItemCriteria> qualifyingItemCriteria, boolean stackable, Date startDate, OfferItemCriteria targetItemCriteria, boolean totalitarianOffer, OfferType offerType, BigDecimal value) {
        OfferImpl offer = new OfferImpl();
        OfferRuleImpl customerRule = new OfferRuleImpl();
        customerRule.setMatchRule(appliesToCustomerRules);
        offer.getOfferMatchRules().put(OfferRuleType.CUSTOMER.getType(), customerRule);
        OfferRuleImpl fgRule = new OfferRuleImpl();
        fgRule.setMatchRule(appliesToFulfillmentGroupRules);
        offer.getOfferMatchRules().put(OfferRuleType.FULFILLMENT_GROUP.getType(), fgRule);
        OfferRuleImpl orderRule = new OfferRuleImpl();
        orderRule.setMatchRule(appliesToRules);
        offer.getOfferMatchRules().put(OfferRuleType.ORDER.getType(), orderRule);
        offer.setApplyDiscountToSalePrice(applyToSalePrice);
        offer.setCombinableWithOtherOffers(combinableWithOtherOffers);
        offer.setDeliveryType(deliveryType);
        offer.setDiscountType(type);
        offer.setEndDate(endDate);
        offer.setMaxUses(maxUses);
        offer.setOfferItemQualifierRuleType(qualifierType);
        offer.setOfferItemTargetRuleType(targetType);
        offer.setPriority(priority);
        offer.setQualifyingItemCriteria(qualifyingItemCriteria);
        offer.setStackable(stackable);
        offer.setStartDate(startDate);
        offer.setTargetItemCriteria(targetItemCriteria);
        offer.setTotalitarianOffer(Boolean.valueOf(totalitarianOffer));
        offer.setType(offerType);
        offer.setValue(value);
        offer.setTreatAsNewFormat(Boolean.valueOf(true));
        return offer;
    }

    public Date yesterday() {
        long now = System.currentTimeMillis();
        long then = now - 86400000L;
        return new Date(then);
    }

    public Date tomorrow() {
        long now = System.currentTimeMillis();
        long then = now + 86400000L;
        return new Date(then);
    }

    public List<Offer> createCustomerBasedOffer(String customerRule, Date startDate, Date endDate, OfferDiscountType discountType) {
        Offer offer = this.createOffer(customerRule, null, null, true, true, OfferDeliveryType.AUTOMATIC, discountType, endDate, 0, OfferItemRestrictionRuleType.NONE, OfferItemRestrictionRuleType.NONE, 1, null, true, startDate, null, false, OfferType.ORDER, BigDecimal.valueOf(10L));
        ArrayList<Offer> offers = new ArrayList<Offer>();
        offers.add(offer);
        return offers;
    }

    public List<Offer> createOrderBasedOffer(String orderRule, OfferDiscountType discountType) {
        Offer offer = this.createOffer(null, null, orderRule, true, true, OfferDeliveryType.AUTOMATIC, discountType, this.tomorrow(), 0, OfferItemRestrictionRuleType.NONE, OfferItemRestrictionRuleType.NONE, 1, null, true, this.yesterday(), null, false, OfferType.ORDER, BigDecimal.valueOf(10L));
        ArrayList<Offer> offers = new ArrayList<Offer>();
        offers.add(offer);
        return offers;
    }

    public List<Offer> createFGBasedOffer(String orderRule, String fgRule, OfferDiscountType discountType) {
        Offer offer = this.createOffer(null, fgRule, orderRule, true, true, OfferDeliveryType.AUTOMATIC, discountType, this.tomorrow(), 0, OfferItemRestrictionRuleType.NONE, OfferItemRestrictionRuleType.NONE, 1, null, true, this.yesterday(), null, false, OfferType.FULFILLMENT_GROUP, BigDecimal.valueOf(10L));
        ArrayList<Offer> offers = new ArrayList<Offer>();
        offers.add(offer);
        return offers;
    }

    public List<Offer> createItemBasedOffer(String orderRule, String targetRule, OfferDiscountType discountType) {
        List<Offer> offers = this.createOrderBasedOffer(orderRule, discountType);
        offers.get(0).setType(OfferType.ORDER_ITEM);
        if (targetRule != null) {
            OfferItemCriteriaImpl targetCriteria = new OfferItemCriteriaImpl();
            targetCriteria.setOffer(offers.get(0));
            targetCriteria.setQuantity(Integer.valueOf(1));
            targetCriteria.setOrderItemMatchRule(targetRule);
            offers.get(0).setTargetItemCriteria((OfferItemCriteria)targetCriteria);
        }
        return offers;
    }

    public List<Offer> createOrderBasedOfferWithItemCriteria(String orderRule, OfferDiscountType discountType, String orderItemMatchRule) {
        List<Offer> offers = this.createOrderBasedOffer(orderRule, discountType);
        OfferItemCriteriaImpl qualCriteria = new OfferItemCriteriaImpl();
        qualCriteria.setOffer(offers.get(0));
        qualCriteria.setQuantity(Integer.valueOf(1));
        qualCriteria.setOrderItemMatchRule(orderItemMatchRule);
        HashSet<OfferItemCriteriaImpl> criterias = new HashSet<OfferItemCriteriaImpl>();
        criterias.add(qualCriteria);
        offers.get(0).setQualifyingItemCriteria(criterias);
        return offers;
    }

    public List<Offer> createFGBasedOfferWithItemCriteria(String orderRule, String fgRule, OfferDiscountType discountType, String orderItemMatchRule) {
        List<Offer> offers = this.createFGBasedOffer(orderRule, fgRule, discountType);
        OfferItemCriteriaImpl qualCriteria = new OfferItemCriteriaImpl();
        qualCriteria.setOffer(offers.get(0));
        qualCriteria.setQuantity(Integer.valueOf(1));
        qualCriteria.setOrderItemMatchRule(orderItemMatchRule);
        HashSet<OfferItemCriteriaImpl> criterias = new HashSet<OfferItemCriteriaImpl>();
        criterias.add(qualCriteria);
        offers.get(0).setQualifyingItemCriteria(criterias);
        return offers;
    }

    public List<Offer> createItemBasedOfferWithItemCriteria(String orderRule, OfferDiscountType discountType, String qualRule, String targetRule) {
        List<Offer> offers = this.createItemBasedOffer(orderRule, targetRule, discountType);
        if (qualRule != null) {
            OfferItemCriteriaImpl qualCriteria = new OfferItemCriteriaImpl();
            qualCriteria.setOffer(offers.get(0));
            qualCriteria.setQuantity(Integer.valueOf(1));
            qualCriteria.setOrderItemMatchRule(qualRule);
            HashSet<OfferItemCriteriaImpl> criterias = new HashSet<OfferItemCriteriaImpl>();
            criterias.add(qualCriteria);
            offers.get(0).setQualifyingItemCriteria(criterias);
        }
        return offers;
    }
}

