/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationOverride;
import org.broadleafcommerce.common.presentation.AdminPresentationOverrides;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="targetItemCriteria.offer", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseOffer")
public class OfferImpl
implements Offer {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferId")
    @GenericGenerator(name="OfferId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="OfferImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferImpl")})
    @Column(name="OFFER_ID")
    @AdminPresentation(friendlyName="Offer Id", order=1, group="Description", groupOrder=1, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="OFFER_NAME", nullable=false)
    @Index(name="OFFER_NAME_INDEX", columnNames={"OFFER_NAME"})
    @AdminPresentation(friendlyName="Offer Name", order=1, group="Description", prominent=true, groupOrder=1)
    protected String name;
    @Column(name="OFFER_DESCRIPTION")
    @AdminPresentation(friendlyName="Offer Description", order=2, group="Description", largeEntry=true, prominent=true, groupOrder=1)
    protected String description;
    @Column(name="OFFER_TYPE", nullable=false)
    @Index(name="OFFER_TYPE_INDEX", columnNames={"OFFER_TYPE"})
    @AdminPresentation(friendlyName="Offer Type", order=3, group="Description", prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferType", groupOrder=1)
    protected String type;
    @Column(name="OFFER_DISCOUNT_TYPE")
    @Index(name="OFFER_DISCOUNT_INDEX", columnNames={"OFFER_DISCOUNT_TYPE"})
    @AdminPresentation(friendlyName="Offer Discount Type", order=4, group="Amount", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferDiscountType", groupOrder=2)
    protected String discountType;
    @Column(name="OFFER_VALUE", nullable=false)
    @AdminPresentation(friendlyName="Offer Value", order=5, group="Amount", prominent=true, groupOrder=2)
    protected BigDecimal value;
    @Column(name="OFFER_PRIORITY")
    @AdminPresentation(friendlyName="Offer Priority", group="Description", groupOrder=1)
    protected int priority;
    @Column(name="START_DATE")
    @AdminPresentation(friendlyName="Offer Start Date", group="Activity Range", order=1, groupOrder=3)
    protected Date startDate;
    @Column(name="END_DATE")
    @AdminPresentation(friendlyName="Offer End Date", group="Activity Range", order=2, groupOrder=3)
    protected Date endDate;
    @Column(name="STACKABLE")
    @AdminPresentation(friendlyName="Offer Stackable", group="Application", groupOrder=4)
    protected boolean stackable;
    @Column(name="TARGET_SYSTEM")
    @AdminPresentation(friendlyName="Offer Target System", group="Description", groupOrder=1)
    protected String targetSystem;
    @Column(name="APPLY_TO_SALE_PRICE")
    @AdminPresentation(friendlyName="Apply To Sale Price", group="Application", groupOrder=4)
    protected boolean applyToSalePrice;
    @Column(name="APPLIES_TO_RULES")
    @Deprecated
    protected String appliesToOrderRules;
    @Column(name="APPLIES_WHEN_RULES")
    @Deprecated
    protected String appliesToCustomerRules;
    @Column(name="APPLY_OFFER_TO_MARKED_ITEMS")
    @AdminPresentation(excluded=true)
    @Deprecated
    protected boolean applyDiscountToMarkedItems;
    @Column(name="COMBINABLE_WITH_OTHER_OFFERS")
    @AdminPresentation(friendlyName="Offer Combinable", group="Application", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected boolean combinableWithOtherOffers;
    @Column(name="OFFER_DELIVERY_TYPE", nullable=false)
    @AdminPresentation(friendlyName="Offer Delivery Type", group="Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferDeliveryType", groupOrder=1)
    @Index(name="OFFER_DELIVERY_INDEX", columnNames={"OFFER_DELIVERY_TYPE"})
    protected String deliveryType;
    @Column(name="MAX_USES")
    @AdminPresentation(friendlyName="Offer Max Uses Per Order", order=7, group="Description", groupOrder=2)
    protected int maxUsesPerOrder;
    @Column(name="MAX_USES_PER_CUSTOMER")
    @AdminPresentation(friendlyName="Max Uses Per Customer", order=7, group="Description", groupOrder=1)
    protected Long maxUsesPerCustomer;
    @Column(name="USES")
    @AdminPresentation(friendlyName="Offer Current Uses", visibility=VisibilityEnum.HIDDEN_ALL)
    @Deprecated
    protected int uses;
    @Column(name="OFFER_ITEM_QUALIFIER_RULE")
    @AdminPresentation(friendlyName="Item Qualifier Rule", group="Application", groupOrder=4, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemQualifierRuleType;
    @Column(name="OFFER_ITEM_TARGET_RULE")
    @AdminPresentation(friendlyName="Item Target Rule", group="Application", groupOrder=4, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemTargetRuleType;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_QUAL_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Set<OfferItemCriteria> qualifyingItemCriteria = new HashSet<OfferItemCriteria>();
    @ManyToOne(targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.ALL})
    @AdminPresentation(friendlyName="Target Item Criteria", group="Application", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    @JoinTable(name="BLC_TAR_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected OfferItemCriteria targetItemCriteria;
    @Column(name="TOTALITARIAN_OFFER")
    @AdminPresentation(friendlyName="Totalitarian Offer", group="Application", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean totalitarianOffer;
    @ManyToMany(targetEntity=OfferRuleImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_OFFER_RULE_MAP", inverseJoinColumns={@JoinColumn(name="OFFER_RULE_ID", referencedColumnName="OFFER_RULE_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @MapKeyColumn(name="MAP_KEY", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    Map<String, OfferRule> offerMatchRules = new HashMap<String, OfferRule>();
    @Column(name="USE_NEW_FORMAT")
    @AdminPresentation(friendlyName="Treat As New Format", group="Application", groupOrder=4, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean treatAsNewFormat;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OfferType getType() {
        return OfferType.getInstance(this.type);
    }

    @Override
    public void setType(OfferType type) {
        this.type = type.getType();
    }

    @Override
    public OfferDiscountType getDiscountType() {
        return OfferDiscountType.getInstance(this.discountType);
    }

    @Override
    public void setDiscountType(OfferDiscountType discountType) {
        this.discountType = discountType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemQualifierRuleType() {
        return OfferItemRestrictionRuleType.getInstance(this.offerItemQualifierRuleType);
    }

    @Override
    public void setOfferItemQualifierRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemQualifierRuleType = restrictionRuleType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemTargetRuleType() {
        return OfferItemRestrictionRuleType.getInstance(this.offerItemTargetRuleType);
    }

    @Override
    public void setOfferItemTargetRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemTargetRuleType = restrictionRuleType.getType();
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean isStackable() {
        return this.stackable;
    }

    @Override
    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    @Deprecated
    @JsonIgnore
    public boolean getStackable() {
        return this.stackable;
    }

    @Override
    public String getTargetSystem() {
        return this.targetSystem;
    }

    @Override
    public void setTargetSystem(String targetSystem) {
        this.targetSystem = targetSystem;
    }

    @Override
    public boolean getApplyDiscountToSalePrice() {
        return this.applyToSalePrice;
    }

    @Override
    public void setApplyDiscountToSalePrice(boolean applyToSalePrice) {
        this.applyToSalePrice = applyToSalePrice;
    }

    @Override
    @Deprecated
    public String getAppliesToOrderRules() {
        return this.appliesToOrderRules;
    }

    @Override
    @Deprecated
    public void setAppliesToOrderRules(String appliesToOrderRules) {
        this.appliesToOrderRules = appliesToOrderRules;
    }

    @Override
    @Deprecated
    public String getAppliesToCustomerRules() {
        return this.appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public void setAppliesToCustomerRules(String appliesToCustomerRules) {
        this.appliesToCustomerRules = appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public boolean isApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Deprecated
    @JsonIgnore
    public boolean getApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Override
    @Deprecated
    public void setApplyDiscountToMarkedItems(boolean applyDiscountToMarkedItems) {
        this.applyDiscountToMarkedItems = applyDiscountToMarkedItems;
    }

    @Override
    public boolean isCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public void setCombinableWithOtherOffers(boolean combinableWithOtherOffers) {
        this.combinableWithOtherOffers = combinableWithOtherOffers;
    }

    @Deprecated
    @JsonIgnore
    public boolean getCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public OfferDeliveryType getDeliveryType() {
        return OfferDeliveryType.getInstance(this.deliveryType);
    }

    @Override
    public void setDeliveryType(OfferDeliveryType deliveryType) {
        this.deliveryType = deliveryType.getType();
    }

    @Override
    public Long getMaxUsesPerCustomer() {
        return this.maxUsesPerCustomer;
    }

    @Override
    public void setMaxUsesPerCustomer(Long maxUsesPerCustomer) {
        this.maxUsesPerCustomer = maxUsesPerCustomer;
    }

    public int getMaxUsesPerOrder() {
        return this.maxUsesPerOrder;
    }

    public void setMaxUsesPerOrder(int maxUsesPerOrder) {
        this.maxUsesPerOrder = maxUsesPerOrder;
    }

    @Override
    public int getMaxUses() {
        return this.maxUsesPerOrder;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.maxUsesPerOrder = maxUses;
    }

    @Override
    @Deprecated
    public int getUses() {
        return this.uses;
    }

    @Override
    @Deprecated
    public void setUses(int uses) {
        this.uses = uses;
    }

    @Override
    public Set<OfferItemCriteria> getQualifyingItemCriteria() {
        return this.qualifyingItemCriteria;
    }

    @Override
    public void setQualifyingItemCriteria(Set<OfferItemCriteria> qualifyingItemCriteria) {
        this.qualifyingItemCriteria = qualifyingItemCriteria;
    }

    @Override
    public OfferItemCriteria getTargetItemCriteria() {
        return this.targetItemCriteria;
    }

    @Override
    public void setTargetItemCriteria(OfferItemCriteria targetItemCriteria) {
        this.targetItemCriteria = targetItemCriteria;
    }

    @Override
    public Boolean isTotalitarianOffer() {
        return this.totalitarianOffer;
    }

    @Override
    public void setTotalitarianOffer(Boolean totalitarianOffer) {
        this.totalitarianOffer = totalitarianOffer;
    }

    @Override
    public Map<String, OfferRule> getOfferMatchRules() {
        if (this.offerMatchRules == null) {
            this.offerMatchRules = new HashMap<String, OfferRule>();
        }
        return this.offerMatchRules;
    }

    @Override
    public void setOfferMatchRules(Map<String, OfferRule> offerMatchRules) {
        this.offerMatchRules = offerMatchRules;
    }

    @Override
    public Boolean getTreatAsNewFormat() {
        return this.treatAsNewFormat;
    }

    @Override
    public void setTreatAsNewFormat(Boolean treatAsNewFormat) {
        this.treatAsNewFormat = treatAsNewFormat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferImpl other = (OfferImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

